/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.text.ITextField;
import net.minecraft.client.gui.text.TextFieldEditor;
import net.minecraft.client.render.FontRenderer;

public class GuiTextField
extends Gui
implements ITextField {
    private final FontRenderer fontRenderer;
    public int xPosition;
    public int yPosition;
    public final int width;
    public final int height;
    private String text = "";
    private int maxStringLength;
    private int cursorCounter;
    public boolean isFocused = false;
    public boolean isEnabled = true;
    public GuiScreen parent;
    private ITextChangeListener textChangeListener;
    private String placeholder;
    public boolean drawBackground = true;
    private TextFieldEditor editor;

    public GuiTextField(GuiScreen parent, FontRenderer fontrenderer, int xPosition, int yPosition, int width, int height, String defaultText, String placeholder) {
        this.parent = parent;
        this.fontRenderer = fontrenderer;
        this.xPosition = xPosition;
        this.yPosition = yPosition;
        this.width = width;
        this.height = height;
        this.editor = new TextFieldEditor(this);
        this.placeholder = placeholder;
        this.setText(defaultText);
        this.editor.setCursor(10000);
    }

    @Override
    public void setText(String text) {
        if (text == null) {
            this.editor.setCursor(0);
        } else if (text.length() < this.editor.getCursor()) {
            this.editor.setCursor(text.length());
        }
        this.text = text;
        if (this.textChangeListener != null) {
            this.textChangeListener.textChanged(this);
        }
    }

    @Override
    public String getText() {
        return this.text;
    }

    public void setPlaceholder(String placeholder) {
        this.placeholder = placeholder;
    }

    public void updateCursorCounter() {
        ++this.cursorCounter;
    }

    public void textboxKeyTyped(char c, int key) {
        if (!this.isEnabled || !this.isFocused) {
            return;
        }
        if (key == 15 && this.parent != null) {
            this.parent.selectNextField();
        }
        if (this.editor.handleInput(key, c) && this.textChangeListener != null) {
            this.textChangeListener.textChanged(this);
        }
    }

    public void mouseClicked(int i, int j, int k) {
        boolean flag = this.isEnabled && i >= this.xPosition && i < this.xPosition + this.width && j >= this.yPosition && j < this.yPosition + this.height;
        this.setFocused(flag);
        if (flag && k == 1) {
            this.setText("");
        }
    }

    public void setFocused(boolean flag) {
        if (flag && !this.isFocused) {
            this.cursorCounter = 0;
            this.editor.setCursor(10000);
        }
        this.isFocused = flag;
    }

    public void drawTextBox() {
        if (this.drawBackground) {
            this.drawRect(this.xPosition - 1, this.yPosition - 1, this.xPosition + this.width + 1, this.yPosition + this.height + 1, -6250336);
            this.drawRect(this.xPosition, this.yPosition, this.xPosition + this.width, this.yPosition + this.height, -16777216);
        }
        if (this.text.isEmpty() && !this.isFocused) {
            this.drawString(this.fontRenderer, this.placeholder, this.xPosition + 4, this.yPosition + (this.height - 8) / 2, 0x5F5F5F);
        }
        if (this.isEnabled) {
            boolean drawCursor = this.isFocused && this.cursorCounter / 6 % 2 == 0;
            int cursor = this.editor.getCursor();
            int maxDisplayableChars = this.width / this.fontRenderer.getCharWidth('_');
            if (this.text.length() <= maxDisplayableChars - 1) {
                this.drawString(this.fontRenderer, this.text, this.xPosition + 4, this.yPosition + (this.height - 8) / 2, 0xE0E0E0);
            } else {
                int begin = Math.max(0, cursor - maxDisplayableChars);
                int end = Math.max(maxDisplayableChars, Math.min(this.text.length(), cursor));
                this.drawString(this.fontRenderer, this.text.substring(begin, end), this.xPosition + 4, this.yPosition + (this.height - 8) / 2, 0xE0E0E0);
            }
            if (drawCursor) {
                int width = this.fontRenderer.getStringWidth(this.text);
                if (cursor < this.text.length()) {
                    width = this.fontRenderer.getStringWidth(this.text.substring(0, cursor));
                }
                if (width >= this.width - 4) {
                    width = this.width - 4 - this.fontRenderer.getStringWidth(this.text.substring(this.text.length() - 2, this.text.length() - 1));
                }
                this.drawString(this.fontRenderer, "_", this.xPosition + 4 + width, this.yPosition + (this.height - 8) / 2, 0xE0E0E0);
            }
        } else {
            this.drawString(this.fontRenderer, this.text, this.xPosition + 4, this.yPosition + (this.height - 8) / 2, 0x707070);
        }
    }

    public void setMaxStringLength(int i) {
        this.maxStringLength = i;
    }

    @Override
    public int maxLength() {
        return this.maxStringLength == 0 ? 1000 : this.maxStringLength;
    }

    public void setTextChangeListener(ITextChangeListener textChangeListener) {
        this.textChangeListener = textChangeListener;
    }

    public static interface ITextChangeListener {
        public void textChanged(GuiTextField var1);
    }
}

