/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.modelviewer.categories.entries.entity;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.modelviewer.categories.entries.entity.EntityEntry;
import net.minecraft.client.gui.modelviewer.elements.GuiListenerSlider;
import net.minecraft.core.entity.animal.EntitySheep;
import net.minecraft.core.item.ItemDye;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.world.World;

public class EntitySheepEntry
extends EntityEntry<EntitySheep> {
    @Override
    public void onTick(EntitySheep entity) {
    }

    @Override
    public List<GuiButton> getEntryButtons(Minecraft mc, GuiScreen parentScreen, EntitySheep sheep) {
        ArrayList<GuiButton> buttonList = new ArrayList<GuiButton>();
        GuiListenerSlider slider = new GuiListenerSlider(-1, -120, 0, 120, 20, I18n.getInstance().translateKeyAndFormat("model.category.entity.sheep.slider.color", "White"), 0.0f);
        slider.setOnValueChanged(() -> {
            sheep.setFleeceColor((int)(slider.sliderValue * 15.0f));
            String color = ItemDye.dyeColors[15 - sheep.getFleeceColor()];
            String c = String.valueOf(color.charAt(0));
            color = c.toUpperCase() + color.substring(1);
            slider.displayString = I18n.getInstance().translateKeyAndFormat("model.category.entity.sheep.slider.color", color);
        });
        buttonList.add(slider);
        return buttonList;
    }

    @Override
    public EntitySheep getEntityInstance(Minecraft mc, World world) {
        EntitySheep sheep = new EntitySheep(world);
        sheep.setFleeceColor(0);
        return sheep;
    }

    @Override
    public void onOpen() {
    }

    @Override
    public void onClose() {
    }
}

