/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.popup;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.popup.PopupComponent;
import net.minecraft.client.render.Scissor;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.core.net.command.TextFormatting;
import net.minecraft.core.util.helper.MathHelper;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class MessageBoxComponent
extends PopupComponent {
    private final Minecraft minecraft;
    private float scrollAmount = 0.0f;
    private final List<String> lines = new ArrayList<String>();
    private final int height;
    private int scrollbarX;
    private int scrollbarY;
    private int scrollbarWidth;
    private int scrollbarHeight;
    private boolean isScrolling = false;
    private int clickY;
    private float previousScrollAmount = 0.0f;

    public MessageBoxComponent(int width, int height, String text, int chars) {
        super(width);
        this.minecraft = Minecraft.getMinecraft(this);
        this.height = height;
        String currentFormat = TextFormatting.WHITE.toString();
        String[] newlines = text.split("\\n", Integer.MAX_VALUE);
        ArrayList<String> split = new ArrayList<String>();
        for (String newline : newlines) {
            if (newline.isEmpty()) {
                split.add("");
                continue;
            }
            String nextFormat = currentFormat;
            for (int start = 0; start < newline.length(); start += chars) {
                String s = newline.substring(start, Math.min(newline.length(), start + chars));
                char[] charArray = s.toCharArray();
                for (int i = 0; i < charArray.length; ++i) {
                    char c = charArray[i];
                    if (c != '\u00a7' || i + 1 >= s.length()) continue;
                    nextFormat = "\u00a7" + charArray[i + 1];
                }
                split.add(currentFormat + s);
                currentFormat = nextFormat;
            }
        }
        this.lines.addAll(split);
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    private void scroll(float amount) {
        this.scrollAmount = MathHelper.clamp(this.scrollAmount + amount, 0.0f, 1.0f);
    }

    @Override
    public void render(int x, int y, int mouseX, int mouseY) {
        float wheel;
        if (this.mouseInRegion(x, y, mouseX, mouseY) && (wheel = (float)Mouse.getDWheel()) != 0.0f) {
            this.scroll(wheel / -1200.0f);
        }
        GL11.glDisable((int)3553);
        this.drawBackground(x, y);
        this.drawScrollbar(x, y, mouseX, mouseY);
        Scissor.enable(x + 1, y + 1, this.getWidth() - 2, this.getHeight() - 2);
        GL11.glEnable((int)3553);
        for (int i = 0; i < this.lines.size(); ++i) {
            this.minecraft.fontRenderer.drawStringWithShadow(this.lines.get(i), x + 4, y + 4 + i * 12 - this.getScrollPixels(), -1);
        }
        Scissor.disable();
    }

    private boolean mouseInRegion(int x, int y, int mouseX, int mouseY) {
        return mouseX >= x && mouseX < x + this.getWidth() && mouseY >= y && mouseY < y + this.height;
    }

    private int getScrollPixels() {
        return (int)(this.scrollAmount * (float)(this.getScrollableHeight() - (this.height - 2)));
    }

    private int getScrollableHeight() {
        return Math.max(20 * this.lines.size(), this.height);
    }

    @Override
    public void onClick(int x, int y, int button) {
        super.onClick(x, y, button);
        if (button == 0 && x >= this.scrollbarX && x < this.scrollbarX + this.scrollbarWidth && y >= this.scrollbarY && y < this.scrollbarY + this.scrollbarHeight) {
            this.isScrolling = true;
            this.previousScrollAmount = this.scrollAmount;
            this.clickY = y;
            return;
        }
    }

    @Override
    public void mouseMovedOrUp(int x, int y, int button) {
        super.mouseMovedOrUp(x, y, button);
        if (button == 0) {
            this.isScrolling = false;
            this.previousScrollAmount = 0.0f;
            this.clickY = 0;
        }
    }

    private void drawBackground(int x, int y) {
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        tessellator.setColorOpaque_I(0xA0A0A0);
        tessellator.addVertex(x, y + this.height, 0.0);
        tessellator.addVertex(x + this.getWidth(), y + this.height, 0.0);
        tessellator.addVertex(x + this.getWidth(), y, 0.0);
        tessellator.addVertex(x, y, 0.0);
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setColorOpaque_I(0);
        tessellator.addVertex(x + 1, y + this.height - 1, 0.0);
        tessellator.addVertex(x + this.getWidth() - 1, y + this.height - 1, 0.0);
        tessellator.addVertex(x + this.getWidth() - 1, y + 1, 0.0);
        tessellator.addVertex(x + 1, y + 1, 0.0);
        tessellator.draw();
    }

    private void drawScrollbar(int x, int y, int mouseX, int mouseY) {
        int scrollableHeight = this.getScrollableHeight();
        int displayRegionHeight = this.height - 2;
        float scrollbarScale = (float)displayRegionHeight / (float)scrollableHeight;
        this.scrollbarWidth = 6;
        this.scrollbarHeight = (int)(scrollbarScale * (float)displayRegionHeight);
        int minScrollbarY = 0;
        int maxScrollbarY = displayRegionHeight - this.scrollbarHeight;
        int scrollbarDelta = maxScrollbarY - minScrollbarY;
        this.scrollbarY = y + 1 + (int)(this.scrollAmount * (float)scrollbarDelta);
        this.scrollbarX = x + this.getWidth() - 1 - 6;
        Tessellator t = Tessellator.instance;
        t.startDrawingQuads();
        t.setColorRGBA_I(0x808080, 255);
        t.drawRectangle(this.scrollbarX, this.scrollbarY, 6, this.scrollbarHeight);
        t.setColorRGBA_I(0xC0C0C0, 255);
        t.drawRectangle(this.scrollbarX, this.scrollbarY, 5, this.scrollbarHeight - 1);
        t.draw();
        if (this.isScrolling) {
            int delta = mouseY - this.clickY;
            float scrolledScreens = (float)delta / (float)this.scrollbarHeight;
            float scrolledPixels = (float)displayRegionHeight * scrolledScreens;
            float scrolledAmount = scrolledPixels / (float)(scrollableHeight - displayRegionHeight);
            this.scrollAmount = MathHelper.clamp(this.previousScrollAmount + scrolledAmount, 0.0f, 1.0f);
        }
    }
}

