/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.stitcher.IconCoordinate;
import net.minecraft.client.render.stitcher.TextureRegistry;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.logic.PistonDirections;
import net.minecraft.core.block.piston.BlockPistonBase;
import net.minecraft.core.util.helper.Side;

public class BlockModelPiston<T extends BlockPistonBase>
extends BlockModelStandard<T> {
    private final IconCoordinate faceTexture;
    protected IconCoordinate sideTexture = TextureRegistry.getTexture("minecraft:block/piston_side");
    protected IconCoordinate topTexture = TextureRegistry.getTexture("minecraft:block/piston_top");
    protected IconCoordinate bottomTexture = TextureRegistry.getTexture("minecraft:block/piston_bottom");

    public BlockModelPiston(Block block, IconCoordinate faceTexture) {
        super(block);
        this.faceTexture = faceTexture;
    }

    @Override
    public boolean render(Tessellator tessellator, int x, int y, int z) {
        ((BlockPistonBase)this.block).setBlockBoundsBasedOnState(BlockModelPiston.renderBlocks.blockAccess, x, y, z);
        return this.renderPistonBase(tessellator, x, y, z, false);
    }

    @Override
    public boolean renderNoCulling(Tessellator tessellator, int x, int y, int z) {
        BlockModelPiston.renderBlocks.renderAllFaces = true;
        boolean result = this.renderPistonBase(tessellator, x, y, z, true);
        BlockModelPiston.renderBlocks.renderAllFaces = false;
        return result;
    }

    protected boolean renderPistonBase(Tessellator tessellator, int i, int j, int k, boolean flag) {
        int l = BlockModelPiston.renderBlocks.blockAccess.getBlockMetadata(i, j, k);
        boolean flag1 = flag || (l & 8) != 0;
        int i1 = BlockPistonBase.getDirection(l);
        if (flag1) {
            switch (i1) {
                case 0: {
                    BlockModelPiston.renderBlocks.uvRotateEast = 3;
                    BlockModelPiston.renderBlocks.uvRotateWest = 3;
                    BlockModelPiston.renderBlocks.uvRotateSouth = 3;
                    BlockModelPiston.renderBlocks.uvRotateNorth = 3;
                    ((BlockPistonBase)this.block).setBlockBounds(0.0, 0.25, 0.0, 1.0, 1.0, 1.0);
                    break;
                }
                case 1: {
                    ((BlockPistonBase)this.block).setBlockBounds(0.0, 0.0, 0.0, 1.0, 0.75, 1.0);
                    break;
                }
                case 2: {
                    BlockModelPiston.renderBlocks.uvRotateSouth = 1;
                    BlockModelPiston.renderBlocks.uvRotateNorth = 2;
                    ((BlockPistonBase)this.block).setBlockBounds(0.0, 0.0, 0.25, 1.0, 1.0, 1.0);
                    break;
                }
                case 3: {
                    BlockModelPiston.renderBlocks.uvRotateSouth = 2;
                    BlockModelPiston.renderBlocks.uvRotateNorth = 1;
                    BlockModelPiston.renderBlocks.uvRotateTop = 3;
                    BlockModelPiston.renderBlocks.uvRotateBottom = 3;
                    ((BlockPistonBase)this.block).setBlockBounds(0.0, 0.0, 0.0, 1.0, 1.0, 0.75);
                    break;
                }
                case 4: {
                    BlockModelPiston.renderBlocks.uvRotateEast = 1;
                    BlockModelPiston.renderBlocks.uvRotateWest = 2;
                    BlockModelPiston.renderBlocks.uvRotateTop = 2;
                    BlockModelPiston.renderBlocks.uvRotateBottom = 1;
                    ((BlockPistonBase)this.block).setBlockBounds(0.25, 0.0, 0.0, 1.0, 1.0, 1.0);
                    break;
                }
                case 5: {
                    BlockModelPiston.renderBlocks.uvRotateEast = 2;
                    BlockModelPiston.renderBlocks.uvRotateWest = 1;
                    BlockModelPiston.renderBlocks.uvRotateTop = 1;
                    BlockModelPiston.renderBlocks.uvRotateBottom = 2;
                    ((BlockPistonBase)this.block).setBlockBounds(0.0, 0.0, 0.0, 0.75, 1.0, 1.0);
                }
            }
            this.renderStandardBlock(tessellator, this.block, i, j, k);
            this.resetRenderBlocks();
            ((BlockPistonBase)this.block).setBlockBounds(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        } else {
            switch (i1) {
                case 0: {
                    BlockModelPiston.renderBlocks.uvRotateEast = 3;
                    BlockModelPiston.renderBlocks.uvRotateWest = 3;
                    BlockModelPiston.renderBlocks.uvRotateSouth = 3;
                    BlockModelPiston.renderBlocks.uvRotateNorth = 3;
                    break;
                }
                case 2: {
                    BlockModelPiston.renderBlocks.uvRotateSouth = 1;
                    BlockModelPiston.renderBlocks.uvRotateNorth = 2;
                    break;
                }
                case 3: {
                    BlockModelPiston.renderBlocks.uvRotateSouth = 2;
                    BlockModelPiston.renderBlocks.uvRotateNorth = 1;
                    BlockModelPiston.renderBlocks.uvRotateTop = 3;
                    BlockModelPiston.renderBlocks.uvRotateBottom = 3;
                    break;
                }
                case 4: {
                    BlockModelPiston.renderBlocks.uvRotateEast = 1;
                    BlockModelPiston.renderBlocks.uvRotateWest = 2;
                    BlockModelPiston.renderBlocks.uvRotateTop = 2;
                    BlockModelPiston.renderBlocks.uvRotateBottom = 1;
                    break;
                }
                case 5: {
                    BlockModelPiston.renderBlocks.uvRotateEast = 2;
                    BlockModelPiston.renderBlocks.uvRotateWest = 1;
                    BlockModelPiston.renderBlocks.uvRotateTop = 1;
                    BlockModelPiston.renderBlocks.uvRotateBottom = 2;
                }
            }
            this.renderStandardBlock(tessellator, this.block, i, j, k);
            this.resetRenderBlocks();
        }
        return true;
    }

    @Override
    public void renderBlockOnInventory(Tessellator tessellator, int metadata, float brightness, float alpha) {
        super.renderBlockOnInventory(tessellator, 1, brightness, alpha);
    }

    public IconCoordinate getFaceTexture() {
        return this.faceTexture;
    }

    @Override
    public IconCoordinate getBlockTextureFromSideAndMetadata(Side side, int data) {
        int direction = BlockPistonBase.getDirection(data);
        if (direction > 5) {
            return this.atlasIndices[0];
        }
        if (side.getId() == direction) {
            if (BlockPistonBase.isPowered(data) || ((BlockPistonBase)this.block).minX > 0.0 || ((BlockPistonBase)this.block).minY > 0.0 || ((BlockPistonBase)this.block).minZ > 0.0 || ((BlockPistonBase)this.block).maxX < 1.0 || ((BlockPistonBase)this.block).maxY < 1.0 || ((BlockPistonBase)this.block).maxZ < 1.0) {
                return this.topTexture;
            }
            return this.atlasIndices[0];
        }
        return side.getId() != PistonDirections.directionMap[direction] ? this.sideTexture : this.bottomTexture;
    }
}

