/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.block.color.BlockColor;
import net.minecraft.client.render.block.color.BlockColorDispatcher;
import net.minecraft.client.render.block.model.BlockModel;
import net.minecraft.client.render.stitcher.IconCoordinate;
import net.minecraft.client.render.stitcher.TextureRegistry;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.core.block.Block;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.WorldSource;
import org.lwjgl.opengl.GL11;

public class BlockModelStandard<T extends Block>
extends BlockModel<T> {
    public static final IconCoordinate BLOCK_TEXTURE_MISSING = TextureRegistry.getTexture("minecraft:block/texture_missing");
    public static final IconCoordinate BLOCK_TEXTURE_UNASSIGNED = TextureRegistry.getTexture("minecraft:block/texture_unassigned");
    public IconCoordinate[] atlasIndices = new IconCoordinate[]{BLOCK_TEXTURE_UNASSIGNED, BLOCK_TEXTURE_UNASSIGNED, BLOCK_TEXTURE_UNASSIGNED, BLOCK_TEXTURE_UNASSIGNED, BLOCK_TEXTURE_UNASSIGNED, BLOCK_TEXTURE_UNASSIGNED};
    public double[] itemRenderBounds = null;
    public IconCoordinate overbrightTexture = null;

    public BlockModelStandard(Block block) {
        super(block);
    }

    @Override
    public boolean render(Tessellator tessellator, int x, int y, int z) {
        this.block.setBlockBoundsBasedOnState(BlockModelStandard.renderBlocks.blockAccess, x, y, z);
        return this.renderStandardBlock(tessellator, this.block, x, y, z);
    }

    @Override
    public void renderBlockOnInventory(Tessellator tessellator, int metadata, float brightness, float alpha) {
        if (BlockModelStandard.renderBlocks.useInventoryTint) {
            int color = ((BlockColor)BlockColorDispatcher.getInstance().getDispatch(this.block)).getFallbackColor(metadata);
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            GL11.glColor4f((float)(r * brightness), (float)(g * brightness), (float)(b * brightness), (float)alpha);
        } else {
            GL11.glColor4f((float)brightness, (float)brightness, (float)brightness, (float)alpha);
        }
        float yOffset = 0.5f;
        this.setBlockBoundsForItemRender();
        GL11.glTranslatef((float)-0.5f, (float)(0.0f - yOffset), (float)-0.5f);
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, -1.0f, 0.0f);
        this.renderBottomFace(tessellator, this.block, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.BOTTOM, metadata));
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, 1.0f, 0.0f);
        this.renderTopFace(tessellator, this.block, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.TOP, metadata));
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, 0.0f, -1.0f);
        this.renderNorthFace(tessellator, this.block, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.NORTH, metadata));
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, 0.0f, 1.0f);
        this.renderSouthFace(tessellator, this.block, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.SOUTH, metadata));
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(-1.0f, 0.0f, 0.0f);
        this.renderWestFace(tessellator, this.block, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.WEST, metadata));
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(1.0f, 0.0f, 0.0f);
        this.renderEastFace(tessellator, this.block, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.EAST, metadata));
        tessellator.draw();
        if (this.hasOverbright()) {
            brightness = 1.0f;
            if (BlockModelStandard.renderBlocks.useInventoryTint) {
                int color = ((BlockColor)BlockColorDispatcher.getInstance().getDispatch(this.block)).getFallbackColor(metadata);
                float r = (float)(color >> 16 & 0xFF) / 255.0f;
                float g = (float)(color >> 8 & 0xFF) / 255.0f;
                float b = (float)(color & 0xFF) / 255.0f;
                GL11.glColor4f((float)(r * brightness), (float)(g * brightness), (float)(b * brightness), (float)alpha);
            } else {
                GL11.glColor4f((float)brightness, (float)brightness, (float)brightness, (float)alpha);
            }
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, -1.0f, 0.0f);
            this.renderBottomFace(tessellator, this.block, 0.0, 0.0, 0.0, this.getBlockOverbrightTextureFromSideAndMeta(Side.BOTTOM, metadata));
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, 1.0f, 0.0f);
            this.renderTopFace(tessellator, this.block, 0.0, 0.0, 0.0, this.getBlockOverbrightTextureFromSideAndMeta(Side.TOP, metadata));
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, 0.0f, -1.0f);
            this.renderNorthFace(tessellator, this.block, 0.0, 0.0, 0.0, this.getBlockOverbrightTextureFromSideAndMeta(Side.NORTH, metadata));
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, 0.0f, 1.0f);
            this.renderSouthFace(tessellator, this.block, 0.0, 0.0, 0.0, this.getBlockOverbrightTextureFromSideAndMeta(Side.SOUTH, metadata));
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(-1.0f, 0.0f, 0.0f);
            this.renderWestFace(tessellator, this.block, 0.0, 0.0, 0.0, this.getBlockOverbrightTextureFromSideAndMeta(Side.WEST, metadata));
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(1.0f, 0.0f, 0.0f);
            this.renderEastFace(tessellator, this.block, 0.0, 0.0, 0.0, this.getBlockOverbrightTextureFromSideAndMeta(Side.EAST, metadata));
            tessellator.draw();
        }
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
    }

    @Override
    public boolean shouldItemRender3d() {
        return true;
    }

    @Override
    public float getItemRenderScale() {
        return 0.25f;
    }

    @Override
    public IconCoordinate getBlockTexture(WorldSource blockAccess, int x, int y, int z, Side side) {
        return this.getBlockTextureFromSideAndMetadata(side, blockAccess.getBlockMetadata(x, y, z));
    }

    @Override
    public IconCoordinate getBlockOverbrightTexture(WorldSource blockAccess, int x, int y, int z, int side) {
        return this.getBlockOverbrightTextureFromSideAndMeta(Side.getSideById(side), blockAccess.getBlockMetadata(x, y, z));
    }

    @Override
    public IconCoordinate getBlockOverbrightTextureFromSideAndMeta(Side side, int data) {
        return this.overbrightTexture;
    }

    @Override
    public IconCoordinate getBlockTextureFromSideAndMetadata(Side side, int data) {
        return this.atlasIndices[side.getId()];
    }

    @Override
    public IconCoordinate getParticleTexture(Side side, int meta) {
        return this.getBlockTextureFromSideAndMetadata(side, meta);
    }

    @Override
    public boolean shouldSideBeRendered(WorldSource blockAccess, int x, int y, int z, int side, int meta) {
        return this.shouldSideBeRendered(blockAccess, x, y, z, side);
    }

    @Override
    public boolean shouldSideBeRendered(WorldSource blockAccess, int x, int y, int z, int side) {
        Side side1 = Side.getSideById(side);
        if (side1 == Side.BOTTOM && this.block.minY > 0.0) {
            return true;
        }
        if (side1 == Side.TOP && this.block.maxY < 1.0) {
            return true;
        }
        if (side1 == Side.NORTH && this.block.minZ > 0.0) {
            return true;
        }
        if (side1 == Side.SOUTH && this.block.maxZ < 1.0) {
            return true;
        }
        if (side1 == Side.WEST && this.block.minX > 0.0) {
            return true;
        }
        if (side1 == Side.EAST && this.block.maxX < 1.0) {
            return true;
        }
        return !blockAccess.isBlockOpaqueCube(x, y, z);
    }

    @Override
    public boolean shouldSideBeColored(WorldSource blockAccess, int x, int y, int z, int side, int meta) {
        return true;
    }

    @Override
    public void setBlockBoundsForItemRender() {
        if (this.itemRenderBounds != null) {
            this.block.setBlockBounds(this.itemRenderBounds[0], this.itemRenderBounds[1], this.itemRenderBounds[2], this.itemRenderBounds[3], this.itemRenderBounds[4], this.itemRenderBounds[5]);
        }
    }

    public BlockModelStandard<T> withCustomItemBounds(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        this.itemRenderBounds = new double[]{minX, minY, minZ, maxX, maxY, maxZ};
        return this;
    }

    public BlockModelStandard<T> withOverbrightTexture(String texture) {
        this.hasOverbright = true;
        this.overbrightTexture = TextureRegistry.getTexture(texture);
        return this;
    }

    public BlockModelStandard<T> withTextures(String texture) {
        return this.withTextures(texture, texture, texture);
    }

    public BlockModelStandard<T> withTextures(String textureTopBottom, String textureSides) {
        return this.withTextures(textureTopBottom, textureTopBottom, textureSides);
    }

    public BlockModelStandard<T> withTextures(String textureTop, String textureBottom, String textureSides) {
        return this.withTextures(textureTop, textureBottom, textureSides, textureSides, textureSides, textureSides);
    }

    public BlockModelStandard<T> withTextures(String textureTop, String textureBottom, String textureNorth, String textureEast, String textureSouth, String textureWest) {
        this.atlasIndices[Side.TOP.getId()] = TextureRegistry.getTexture(textureTop);
        this.atlasIndices[Side.BOTTOM.getId()] = TextureRegistry.getTexture(textureBottom);
        this.atlasIndices[Side.NORTH.getId()] = TextureRegistry.getTexture(textureNorth);
        this.atlasIndices[Side.EAST.getId()] = TextureRegistry.getTexture(textureEast);
        this.atlasIndices[Side.SOUTH.getId()] = TextureRegistry.getTexture(textureSouth);
        this.atlasIndices[Side.WEST.getId()] = TextureRegistry.getTexture(textureWest);
        return this;
    }
}

