/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.tessellator;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import net.minecraft.client.GLAllocation;
import net.minecraft.client.Minecraft;
import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.tessellator.TessellatorBase;
import org.lwjgl.opengl.ARBVertexBufferObject;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GLContext;

public class TessellatorStandard
extends TessellatorBase {
    private static boolean convertQuadsToTriangles = true;
    private ByteBuffer byteBuffer;
    private IntBuffer intBuffer;
    private FloatBuffer floatBuffer;
    private ShortBuffer shortBuffer;
    private int[] rawBuffer;
    private int vertexCount;
    private double textureU;
    private double textureV;
    private int lightmapCoord;
    private int color;
    private boolean hasColor;
    private boolean hasTexture;
    private boolean hasNormals;
    private boolean hasLightmap;
    private int rawBufferIndex;
    private int addedVertices;
    private boolean isColorDisabled;
    private int drawMode;
    private double xOffset;
    private double yOffset;
    private double zOffset;
    private int normal;
    private boolean isDrawing;
    private boolean useVBO;
    private IntBuffer vertexBuffers;
    private int vboIndex;
    private int vboCount = 10;
    private int bufferSize;

    TessellatorStandard(int bufferSize) {
        this.bufferSize = bufferSize;
        this.byteBuffer = GLAllocation.createDirectByteBuffer(bufferSize * 4);
        this.intBuffer = this.byteBuffer.asIntBuffer();
        this.floatBuffer = this.byteBuffer.asFloatBuffer();
        this.shortBuffer = this.byteBuffer.asShortBuffer();
        this.rawBuffer = new int[bufferSize];
        this.setUseVBO((Boolean)Minecraft.getMinecraft((Object)this).gameSettings.enableVbos.value);
    }

    @Override
    public void setUseVBO(boolean flag) {
        boolean bl = this.useVBO = flag && GLContext.getCapabilities().GL_ARB_vertex_buffer_object;
        if (this.useVBO) {
            this.vertexBuffers = GLAllocation.createDirectIntBuffer(this.vboCount);
            ARBVertexBufferObject.glGenBuffersARB((IntBuffer)this.vertexBuffers);
        } else {
            GL15.glBindBuffer((int)34962, (int)0);
        }
    }

    @Override
    public void draw() {
        this.checkIsDrawing();
        this.isDrawing = false;
        if (this.vertexCount > 0) {
            this.intBuffer.clear();
            this.intBuffer.put(this.rawBuffer, 0, this.rawBufferIndex);
            this.byteBuffer.position(0);
            this.byteBuffer.limit(this.rawBufferIndex * 4);
            if (this.useVBO) {
                this.vboIndex = (this.vboIndex + 1) % this.vboCount;
                ARBVertexBufferObject.glBindBufferARB((int)34962, (int)this.vertexBuffers.get(this.vboIndex));
                ARBVertexBufferObject.glBufferDataARB((int)34962, (ByteBuffer)this.byteBuffer, (int)35040);
            }
            if (this.hasTexture) {
                if (this.useVBO) {
                    GL11.glTexCoordPointer((int)2, (int)5126, (int)32, (long)12L);
                } else {
                    this.floatBuffer.position(3);
                    GL11.glTexCoordPointer((int)2, (int)32, (FloatBuffer)this.floatBuffer);
                }
                GL11.glEnableClientState((int)32888);
            }
            if (this.hasLightmap) {
                GL13.glClientActiveTexture((int)33985);
                if (this.useVBO) {
                    GL11.glTexCoordPointer((int)2, (int)5122, (int)32, (long)28L);
                } else {
                    this.shortBuffer.position(14);
                    GL11.glTexCoordPointer((int)2, (int)32, (ShortBuffer)this.shortBuffer);
                }
                GL11.glEnableClientState((int)32888);
                GL13.glClientActiveTexture((int)33984);
            }
            if (this.hasColor) {
                if (this.useVBO) {
                    GL11.glColorPointer((int)4, (int)5121, (int)32, (long)20L);
                } else {
                    this.byteBuffer.position(20);
                    GL11.glColorPointer((int)4, (boolean)true, (int)32, (ByteBuffer)this.byteBuffer);
                }
                GL11.glEnableClientState((int)32886);
            }
            if (this.hasNormals) {
                if (this.useVBO) {
                    GL11.glNormalPointer((int)5120, (int)32, (long)24L);
                } else {
                    this.byteBuffer.position(24);
                    GL11.glNormalPointer((int)32, (ByteBuffer)this.byteBuffer);
                }
                GL11.glEnableClientState((int)32885);
            }
            if (this.useVBO) {
                GL11.glVertexPointer((int)3, (int)5126, (int)32, (long)0L);
            } else {
                this.floatBuffer.position(0);
                GL11.glVertexPointer((int)3, (int)32, (FloatBuffer)this.floatBuffer);
            }
            GL11.glEnableClientState((int)32884);
            if (this.drawMode == 7 && convertQuadsToTriangles) {
                GL11.glDrawArrays((int)4, (int)0, (int)this.vertexCount);
            } else {
                GL11.glDrawArrays((int)this.drawMode, (int)0, (int)this.vertexCount);
            }
            GL11.glDisableClientState((int)32884);
            if (this.hasTexture) {
                GL11.glDisableClientState((int)32888);
            }
            if (this.hasLightmap) {
                GL13.glClientActiveTexture((int)33985);
                GL11.glDisableClientState((int)32888);
                GL13.glClientActiveTexture((int)33984);
            }
            if (this.hasColor) {
                GL11.glDisableClientState((int)32886);
            }
            if (this.hasNormals) {
                GL11.glDisableClientState((int)32885);
            }
        }
        this.reset();
    }

    private void reset() {
        this.vertexCount = 0;
        this.byteBuffer.clear();
        this.rawBufferIndex = 0;
        this.addedVertices = 0;
    }

    @Override
    public void startDrawing(int drawMode) {
        if (this.isDrawing) {
            throw new IllegalStateException("Already tesselating!");
        }
        this.isDrawing = true;
        this.reset();
        this.drawMode = drawMode;
        this.hasNormals = false;
        this.hasColor = false;
        this.hasTexture = false;
        this.hasLightmap = false;
        this.isColorDisabled = false;
    }

    @Override
    public void setTextureUV(double u, double v) {
        this.hasTexture = true;
        this.textureU = u;
        this.textureV = v;
    }

    @Override
    public void setLightmapCoord(int lightmapCoord) {
        if (!LightmapHelper.isLightmapEnabled()) {
            throw new IllegalStateException("Lightmap is disabled!");
        }
        this.hasLightmap = true;
        this.lightmapCoord = lightmapCoord;
    }

    @Override
    public void setColorRGBA(int r, int g, int b, int a) {
        if (this.isColorDisabled) {
            return;
        }
        if (r > 255) {
            r = 255;
        }
        if (g > 255) {
            g = 255;
        }
        if (b > 255) {
            b = 255;
        }
        if (a > 255) {
            a = 255;
        }
        if (r < 0) {
            r = 0;
        }
        if (g < 0) {
            g = 0;
        }
        if (b < 0) {
            b = 0;
        }
        if (a < 0) {
            a = 0;
        }
        this.hasColor = true;
        this.color = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? a << 24 | b << 16 | g << 8 | r : r << 24 | g << 16 | b << 8 | a;
    }

    @Override
    public void addVertex(double x, double y, double z) {
        ++this.addedVertices;
        if (this.drawMode == 7 && convertQuadsToTriangles && this.addedVertices % 4 == 0) {
            for (int i = 0; i < 2; ++i) {
                int j = 8 * (3 - i);
                if (this.hasTexture) {
                    this.rawBuffer[this.rawBufferIndex + 3] = this.rawBuffer[this.rawBufferIndex - j + 3];
                    this.rawBuffer[this.rawBufferIndex + 4] = this.rawBuffer[this.rawBufferIndex - j + 4];
                }
                if (this.hasLightmap) {
                    this.rawBuffer[this.rawBufferIndex + 7] = this.rawBuffer[this.rawBufferIndex - j + 7];
                }
                if (this.hasColor) {
                    this.rawBuffer[this.rawBufferIndex + 5] = this.rawBuffer[this.rawBufferIndex - j + 5];
                }
                this.rawBuffer[this.rawBufferIndex + 0] = this.rawBuffer[this.rawBufferIndex - j + 0];
                this.rawBuffer[this.rawBufferIndex + 1] = this.rawBuffer[this.rawBufferIndex - j + 1];
                this.rawBuffer[this.rawBufferIndex + 2] = this.rawBuffer[this.rawBufferIndex - j + 2];
                ++this.vertexCount;
                this.rawBufferIndex += 8;
            }
        }
        if (this.hasTexture) {
            this.rawBuffer[this.rawBufferIndex + 3] = Float.floatToRawIntBits((float)this.textureU);
            this.rawBuffer[this.rawBufferIndex + 4] = Float.floatToRawIntBits((float)this.textureV);
        }
        if (this.hasLightmap) {
            this.rawBuffer[this.rawBufferIndex + 7] = this.lightmapCoord;
        }
        if (this.hasColor) {
            this.rawBuffer[this.rawBufferIndex + 5] = this.color;
        }
        if (this.hasNormals) {
            this.rawBuffer[this.rawBufferIndex + 6] = this.normal;
        }
        this.rawBuffer[this.rawBufferIndex + 0] = Float.floatToRawIntBits((float)(x + this.xOffset));
        this.rawBuffer[this.rawBufferIndex + 1] = Float.floatToRawIntBits((float)(y + this.yOffset));
        this.rawBuffer[this.rawBufferIndex + 2] = Float.floatToRawIntBits((float)(z + this.zOffset));
        this.rawBufferIndex += 8;
        ++this.vertexCount;
        if (this.vertexCount % 4 == 0 && this.rawBufferIndex >= this.bufferSize - 32) {
            this.draw();
            this.isDrawing = true;
        }
    }

    @Override
    public void disableColor() {
        this.isColorDisabled = true;
    }

    @Override
    public void setNormal(float x, float y, float z) {
        if (!this.isDrawing) {
            System.out.println("But..");
        }
        this.hasNormals = true;
        byte bx = (byte)(x * 127.0f);
        byte by = (byte)(y * 127.0f);
        byte bz = (byte)(z * 127.0f);
        this.normal = bx | by << 8 | bz << 16;
    }

    @Override
    public void setTranslation(double x, double y, double z) {
        this.xOffset = x;
        this.yOffset = y;
        this.zOffset = z;
    }

    @Override
    public void offsetTranslation(float x, float y, float z) {
        this.xOffset += (double)x;
        this.yOffset += (double)y;
        this.zOffset += (double)z;
    }

    @Override
    public void checkIsDrawing() {
        if (!this.isDrawing) {
            throw new IllegalStateException("Not tesselating!");
        }
    }
}

