/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.texturepack;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.render.FontRenderer;
import net.minecraft.client.render.texturepack.TexturePack;
import net.minecraft.client.render.texturepack.TexturePackCustom;
import net.minecraft.client.render.texturepack.TexturePackDefault;

public class TexturePackList {
    private static final String SEPERATOR = "<-=-=->";
    private List<TexturePack> availableTexturePacks = new ArrayList<TexturePack>();
    private final TexturePack defaultTexturePack = new TexturePackDefault();
    public List<TexturePack> selectedPacks = new ArrayList<TexturePack>();
    private final Map<String, TexturePack> texturePackIDs = new HashMap<String, TexturePack>();
    private final Minecraft mc;
    private final File texturePackDir;
    private boolean isDirty = false;

    public TexturePackList(Minecraft minecraft, File file) {
        this.mc = minecraft;
        this.texturePackDir = new File(file, "texturepacks");
        if (!this.texturePackDir.exists()) {
            this.texturePackDir.mkdirs();
        }
        this.updateAvailableTexturePacks();
    }

    public void shiftPack(TexturePack pack, int shiftAmount) {
        if (!this.selectedPacks.contains(pack)) {
            return;
        }
        if (shiftAmount == 0) {
            return;
        }
        int currentIndex = this.selectedPacks.indexOf(pack);
        int newIndex = currentIndex + shiftAmount;
        if (newIndex < 0) {
            newIndex = 0;
        }
        if (newIndex >= this.selectedPacks.size()) {
            newIndex = this.selectedPacks.size() - 1;
        }
        this.selectedPacks.remove(pack);
        this.selectedPacks.add(newIndex, pack);
        this.savePacksToSettings();
        this.isDirty = true;
    }

    public void setTexturePack(TexturePack newPack) {
        if (!this.selectedPacks.contains(newPack)) {
            this.selectedPacks.add(newPack);
            newPack.readZipFile();
            this.savePacksToSettings();
            this.isDirty = true;
        }
    }

    public void savePacksToSettings() {
        this.mc.gameSettings.skin.value = this.packSaveString();
        this.mc.gameSettings.saveOptions();
    }

    public String packSaveString() {
        StringBuilder builder = new StringBuilder();
        for (TexturePack pack : this.selectedPacks) {
            if (pack == this.defaultTexturePack) continue;
            builder.append(pack.fileName).append(SEPERATOR);
        }
        return builder.toString();
    }

    public void unsetTexturePack(TexturePack pack) {
        pack.closeTexturePackFile();
        this.selectedPacks.remove(pack);
        this.savePacksToSettings();
        this.isDirty = true;
    }

    public void refreshIfReady() {
        if (this.isDirty) {
            this.isDirty = false;
            this.refresh();
        }
    }

    public void refresh() {
        this.mc.renderEngine.refreshTexturesAndDisplayErrors();
        this.mc.fontRenderer = new FontRenderer(this.mc.gameSettings, "/font/default.png", this.mc.renderEngine);
        this.mc.renderGlobal.loadRenderers();
        this.mc.currentScreen.refreshFontRenderer();
        this.mc.renderEngine.updateDynamicTextures();
    }

    public boolean updateAvailableTexturePacks() {
        String[] packStrings;
        File[] filesInDir;
        ArrayList<TexturePack> currentTexturePacks = new ArrayList<TexturePack>();
        boolean update = false;
        if (this.texturePackDir.exists() && this.texturePackDir.isDirectory() && (filesInDir = this.texturePackDir.listFiles()) != null) {
            for (File file : filesInDir) {
                if (!this.isTexturePack(file)) continue;
                String id = this.getTexturePackID(file);
                try {
                    TexturePack pack;
                    if (!this.texturePackIDs.containsKey(id)) {
                        pack = new TexturePackCustom(file);
                        pack.packId = id;
                        pack.readZipFile();
                        pack.readTexturePackManifest();
                        this.texturePackIDs.put(id, pack);
                        pack.closeTexturePackFile();
                        update = true;
                    }
                    pack = this.texturePackIDs.get(id);
                    currentTexturePacks.add(pack);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        List<TexturePack> previousTexturePacks = this.availableTexturePacks;
        previousTexturePacks.removeAll(currentTexturePacks);
        if (previousTexturePacks.size() > 0) {
            update = true;
        }
        for (TexturePack texturePack : previousTexturePacks) {
            texturePack.disposeOfTexturePack(this.mc);
            this.texturePackIDs.remove(texturePack.packId);
        }
        this.availableTexturePacks = currentTexturePacks;
        for (String string : packStrings = ((String)this.mc.gameSettings.skin.value).split(SEPERATOR)) {
            for (TexturePack pack : this.availableTexturePacks) {
                if (!string.equals(pack.fileName) || this.selectedPacks.contains(pack)) continue;
                pack.readZipFile();
                this.selectedPacks.add(pack);
            }
        }
        return update;
    }

    private String getTexturePackID(File file) {
        if (file.isFile()) {
            return file.getName() + ":" + file.length() + ":" + file.lastModified();
        }
        File manifestFile = new File(file, "manifest.json");
        File packPngFile = new File(file, "pack.png");
        return file.getName() + ":" + manifestFile.length() + ":" + manifestFile.lastModified() + ":" + packPngFile.length() + ":" + packPngFile.lastModified();
    }

    private boolean isTexturePack(File file) {
        if (file.isDirectory()) {
            return new File(file, "pack.txt").exists() || new File(file, "manifest.json").exists();
        }
        return file.getName().toLowerCase().endsWith(".zip");
    }

    public List<TexturePack> availableTexturePacks() {
        return new ArrayList<TexturePack>(this.availableTexturePacks);
    }

    public TexturePack getDefaultTexturePack() {
        return this.defaultTexturePack;
    }

    public InputStream getResourceAsStream(String s) {
        for (int i = this.selectedPacks.size() - 1; i >= 0; --i) {
            TexturePack pack = this.selectedPacks.get(i);
            InputStream stream = pack.getResourceAsStream(s);
            if (stream == null) continue;
            return stream;
        }
        return this.defaultTexturePack.getResourceAsStream(s);
    }

    public TexturePack getHighestPriorityPack() {
        if (this.selectedPacks.isEmpty()) {
            return this.defaultTexturePack;
        }
        return this.selectedPacks.get(this.selectedPacks.size() - 1);
    }
}

