/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.EntityLiving;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.sound.SoundCategory;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;

public class BlockButton
extends Block {
    public BlockButton(String key, int id) {
        super(key, id, Material.decoration);
        this.setTicking(true);
    }

    @Override
    public AABB getCollisionBoundingBoxFromPool(WorldSource world, int x, int y, int z) {
        return null;
    }

    @Override
    public int tickRate() {
        return 20;
    }

    @Override
    public boolean isSolidRender() {
        return false;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public boolean canPlaceBlockOnSide(World world, int x, int y, int z, int side) {
        if (side == 0 && world.isBlockNormalCube(x, y + 1, z)) {
            return true;
        }
        if (side == 1 && world.isBlockNormalCube(x, y - 1, z)) {
            return true;
        }
        if (side == 2 && world.isBlockNormalCube(x, y, z + 1)) {
            return true;
        }
        if (side == 3 && world.isBlockNormalCube(x, y, z - 1)) {
            return true;
        }
        if (side == 4 && world.isBlockNormalCube(x + 1, y, z)) {
            return true;
        }
        return side == 5 && world.isBlockNormalCube(x - 1, y, z);
    }

    @Override
    public boolean canPlaceBlockAt(World world, int x, int y, int z) {
        if (world.isBlockNormalCube(x, y - 1, z)) {
            return true;
        }
        if (world.isBlockNormalCube(x, y + 1, z)) {
            return true;
        }
        if (world.isBlockNormalCube(x - 1, y, z)) {
            return true;
        }
        if (world.isBlockNormalCube(x + 1, y, z)) {
            return true;
        }
        if (world.isBlockNormalCube(x, y, z - 1)) {
            return true;
        }
        return world.isBlockNormalCube(x, y, z + 1);
    }

    @Override
    public void onBlockPlaced(World world, int x, int y, int z, Side side, EntityLiving entity, double sideHeight) {
        int i1 = world.getBlockMetadata(x, y, z);
        int j1 = i1 & 8;
        i1 &= 7;
        i1 = side == Side.BOTTOM && world.isBlockNormalCube(x, y + 1, z) ? 5 : (side == Side.TOP && world.isBlockNormalCube(x, y - 1, z) ? 6 : (side == Side.NORTH && world.isBlockNormalCube(x, y, z + 1) ? 4 : (side == Side.SOUTH && world.isBlockNormalCube(x, y, z - 1) ? 3 : (side == Side.WEST && world.isBlockNormalCube(x + 1, y, z) ? 2 : (side == Side.EAST && world.isBlockNormalCube(x - 1, y, z) ? 1 : this.getOrientation(world, x, y, z))))));
        world.setBlockMetadataWithNotify(x, y, z, i1 + j1);
    }

    private int getOrientation(World world, int x, int y, int z) {
        if (world.isBlockNormalCube(x - 1, y, z)) {
            return 1;
        }
        if (world.isBlockNormalCube(x + 1, y, z)) {
            return 2;
        }
        if (world.isBlockNormalCube(x, y, z - 1)) {
            return 3;
        }
        if (world.isBlockNormalCube(x, y, z + 1)) {
            return 4;
        }
        if (world.isBlockNormalCube(x, y + 1, z)) {
            return 5;
        }
        if (world.isBlockNormalCube(x, y - 1, z)) {
            return 6;
        }
        return 1;
    }

    @Override
    public void onNeighborBlockChange(World world, int x, int y, int z, int blockId) {
        if (this.canButtonStay(world, x, y, z)) {
            int i1 = world.getBlockMetadata(x, y, z) & 7;
            boolean flag = false;
            if (!world.isBlockNormalCube(x - 1, y, z) && i1 == 1) {
                flag = true;
            }
            if (!world.isBlockNormalCube(x + 1, y, z) && i1 == 2) {
                flag = true;
            }
            if (!world.isBlockNormalCube(x, y, z - 1) && i1 == 3) {
                flag = true;
            }
            if (!world.isBlockNormalCube(x, y, z + 1) && i1 == 4) {
                flag = true;
            }
            if (!world.isBlockNormalCube(x, y + 1, z) && i1 == 5) {
                flag = true;
            }
            if (!world.isBlockNormalCube(x, y - 1, z) && i1 == 6) {
                flag = true;
            }
            if (flag) {
                this.dropBlockWithCause(world, EnumDropCause.WORLD, x, y, z, i1, null);
                world.setBlockWithNotify(x, y, z, 0);
            }
        }
    }

    private boolean canButtonStay(World world, int x, int y, int z) {
        if (!this.canPlaceBlockAt(world, x, y, z)) {
            this.dropBlockWithCause(world, EnumDropCause.WORLD, x, y, z, world.getBlockMetadata(x, y, z), null);
            world.setBlockWithNotify(x, y, z, 0);
            return false;
        }
        return true;
    }

    @Override
    public void setBlockBoundsBasedOnState(WorldSource world, int x, int y, int z) {
        int l = world.getBlockMetadata(x, y, z);
        int i1 = l & 7;
        boolean flag = (l & 8) > 0;
        float f = 0.375f;
        float f1 = 0.625f;
        float f2 = 0.1875f;
        float f3 = 0.125f;
        if (flag) {
            f3 = 0.0625f;
        }
        if (i1 == 1) {
            this.setBlockBounds(0.0, f, 0.5f - f2, f3, f1, 0.5f + f2);
        } else if (i1 == 2) {
            this.setBlockBounds(1.0f - f3, f, 0.5f - f2, 1.0, f1, 0.5f + f2);
        } else if (i1 == 3) {
            this.setBlockBounds(0.5f - f2, f, 0.0, 0.5f + f2, f1, f3);
        } else if (i1 == 4) {
            this.setBlockBounds(0.5f - f2, f, 1.0f - f3, 0.5f + f2, f1, 1.0);
        } else if (i1 == 5) {
            this.setBlockBounds(0.5f - f2, 1.0f - f3, f, 0.5f + f2, 1.0, f1);
        } else if (i1 == 6) {
            this.setBlockBounds(0.5f - f2, 0.0, f, 0.5f + f2, f3, f1);
        }
    }

    @Override
    public void onBlockClicked(World world, int x, int y, int z, EntityPlayer player) {
        if (!player.isSneaking()) {
            this.blockActivated(world, x, y, z, player);
        }
    }

    @Override
    public boolean blockActivated(World world, int x, int y, int z, EntityPlayer player) {
        int l = world.getBlockMetadata(x, y, z);
        int i1 = l & 7;
        int j1 = 8 - (l & 8);
        if (j1 == 0) {
            return true;
        }
        world.setBlockMetadataWithNotify(x, y, z, i1 + j1);
        world.markBlocksDirty(x, y, z, x, y, z);
        world.playSoundEffect(player, SoundCategory.WORLD_SOUNDS, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "random.click", 0.3f, 0.6f);
        world.notifyBlocksOfNeighborChange(x, y, z, this.id);
        if (i1 == 1) {
            world.notifyBlocksOfNeighborChange(x - 1, y, z, this.id);
        } else if (i1 == 2) {
            world.notifyBlocksOfNeighborChange(x + 1, y, z, this.id);
        } else if (i1 == 3) {
            world.notifyBlocksOfNeighborChange(x, y, z - 1, this.id);
        } else if (i1 == 4) {
            world.notifyBlocksOfNeighborChange(x, y, z + 1, this.id);
        } else if (i1 == 5) {
            world.notifyBlocksOfNeighborChange(x, y + 1, z, this.id);
        } else {
            world.notifyBlocksOfNeighborChange(x, y - 1, z, this.id);
        }
        world.scheduleBlockUpdate(x, y, z, this.id, this.tickRate());
        return true;
    }

    @Override
    public void onBlockRemoved(World world, int x, int y, int z, int data) {
        if ((data & 8) > 0) {
            world.notifyBlocksOfNeighborChange(x, y, z, this.id);
            int i1 = data & 7;
            if (i1 == 1) {
                world.notifyBlocksOfNeighborChange(x - 1, y, z, this.id);
            } else if (i1 == 2) {
                world.notifyBlocksOfNeighborChange(x + 1, y, z, this.id);
            } else if (i1 == 3) {
                world.notifyBlocksOfNeighborChange(x, y, z - 1, this.id);
            } else if (i1 == 4) {
                world.notifyBlocksOfNeighborChange(x, y, z + 1, this.id);
            } else if (i1 == 5) {
                world.notifyBlocksOfNeighborChange(x, y + 1, z, this.id);
            } else {
                world.notifyBlocksOfNeighborChange(x, y - 1, z, this.id);
            }
        }
        super.onBlockRemoved(world, x, y, z, data);
    }

    @Override
    public boolean isPoweringTo(WorldSource blockAccess, int x, int y, int z, int side) {
        return (blockAccess.getBlockMetadata(x, y, z) & 8) > 0;
    }

    @Override
    public boolean isIndirectlyPoweringTo(World world, int x, int y, int z, int side) {
        int i1 = world.getBlockMetadata(x, y, z);
        if ((i1 & 8) == 0) {
            return false;
        }
        int j1 = i1 & 7;
        if (j1 == 6 && side == 1) {
            return true;
        }
        if (j1 == 5 && side == 0) {
            return true;
        }
        if (j1 == 4 && side == 2) {
            return true;
        }
        if (j1 == 3 && side == 3) {
            return true;
        }
        if (j1 == 2 && side == 4) {
            return true;
        }
        return j1 == 1 && side == 5;
    }

    @Override
    public boolean canProvidePower() {
        return true;
    }

    @Override
    public void updateTick(World world, int x, int y, int z, Random rand) {
        if (world.isClientSide) {
            return;
        }
        int l = world.getBlockMetadata(x, y, z);
        if ((l & 8) == 0) {
            return;
        }
        world.setBlockMetadataWithNotify(x, y, z, l & 7);
        world.notifyBlocksOfNeighborChange(x, y, z, this.id);
        int i1 = l & 7;
        if (i1 == 1) {
            world.notifyBlocksOfNeighborChange(x - 1, y, z, this.id);
        } else if (i1 == 2) {
            world.notifyBlocksOfNeighborChange(x + 1, y, z, this.id);
        } else if (i1 == 3) {
            world.notifyBlocksOfNeighborChange(x, y, z - 1, this.id);
        } else if (i1 == 4) {
            world.notifyBlocksOfNeighborChange(x, y, z + 1, this.id);
        } else if (i1 == 5) {
            world.notifyBlocksOfNeighborChange(x, y + 1, z, this.id);
        } else {
            world.notifyBlocksOfNeighborChange(x, y - 1, z, this.id);
        }
        world.playSoundEffect(null, SoundCategory.WORLD_SOUNDS, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "random.click", 0.3f, 0.5f);
        world.markBlocksDirty(x, y, z, x, y, z);
    }
}

