/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.entity.animal;

import com.mojang.nbt.CompoundTag;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.entity.EntityPathfinder;
import net.minecraft.core.entity.animal.IAnimal;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;
import net.minecraft.core.world.season.Seasons;

public abstract class EntityAnimal
extends EntityPathfinder
implements IAnimal {
    public EntityAnimal(World world) {
        super(world);
        this.scoreValue = 10;
    }

    @Override
    public int getMaxSpawnedInChunk() {
        if (this.world.getSeasonManager().getCurrentSeason() == Seasons.OVERWORLD_SPRING) {
            return 8;
        }
        if (this.world.getSeasonManager().getCurrentSeason() == Seasons.OVERWORLD_WINTER) {
            return 1;
        }
        return 4;
    }

    @Override
    protected float getBlockPathWeight(int x, int y, int z) {
        if (this.world.getBlockId(x, y - 1, z) == Block.grass.id) {
            return 10.0f;
        }
        return this.world.getLightBrightness(x, y, z) - 0.5f;
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
    }

    @Override
    public boolean getCanSpawnHere() {
        int z;
        int y;
        int x = MathHelper.floor_double(this.x);
        int id = this.world.getBlockId(x, (y = MathHelper.floor_double(this.bb.minY)) - 1, z = MathHelper.floor_double(this.z));
        if (Block.blocksList[id] != null) {
            return Block.blocksList[id].hasTag(BlockTags.PASSIVE_MOBS_SPAWN) && this.world.getFullBlockLightValue(x, y, z) > 8 && super.getCanSpawnHere();
        }
        return false;
    }

    @Override
    public int getTalkInterval() {
        return 120;
    }
}

