/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.entity.monster;

import com.mojang.nbt.CompoundTag;
import net.minecraft.core.WeightedRandomLootObject;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.monster.EntityMonster;
import net.minecraft.core.entity.projectile.EntityArrow;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.collection.NamespaceID;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;
import net.minecraft.core.world.weather.Weather;

public class EntitySkeleton
extends EntityMonster {
    private static final ItemStack defaultHeldItem = new ItemStack(Item.toolBow, 1);

    public EntitySkeleton(World world) {
        super(world);
        this.textureIdentifier = new NamespaceID("minecraft", "skeleton");
        this.scoreValue = 500;
        this.mobDrops.add(new WeightedRandomLootObject(Item.ammoArrow.getDefaultStack(), 0, 2));
        this.mobDrops.add(new WeightedRandomLootObject(Item.bone.getDefaultStack(), 0, 2));
    }

    @Override
    public String getLivingSound() {
        return "mob.skeleton";
    }

    @Override
    protected String getHurtSound() {
        return "mob.skeletonhurt";
    }

    @Override
    protected String getDeathSound() {
        return "mob.skeletonhurt";
    }

    @Override
    protected void init() {
        super.init();
        this.entityData.define(15, this.attackTime);
    }

    @Override
    public void onLivingUpdate() {
        float f;
        if (this.world.isClientSide) {
            this.attackTime = this.entityData.getInt(15);
        } else {
            this.entityData.set(15, this.attackTime);
        }
        if (this.world.isDaytime() && (f = this.getBrightness(1.0f)) > 0.5f && this.world.canBlockSeeTheSky(MathHelper.floor_double(this.x), MathHelper.floor_double(this.y), MathHelper.floor_double(this.z)) && this.random.nextFloat() * 30.0f < (f - 0.4f) * 2.0f && (this.world.getCurrentWeather() != Weather.overworldFog || this.world.weatherManager.getWeatherPower() < 0.75f)) {
            this.remainingFireTicks = 300;
        }
        super.onLivingUpdate();
    }

    @Override
    protected void attackEntity(Entity entity, float distance) {
        if (distance < 10.0f) {
            double d = entity.x - this.x;
            double d1 = entity.z - this.z;
            if (this.attackTime == 0) {
                if (!this.world.isClientSide) {
                    EntityArrow entityarrow = new EntityArrow(this.world, this, false, 0);
                    entityarrow.y += (double)1.4f;
                    double d2 = entity.y + (double)entity.getHeadHeight() - (double)0.2f - entityarrow.y;
                    float f1 = MathHelper.sqrt_double(d * d + d1 * d1) * 0.2f;
                    this.world.playSoundAtEntity(null, this, "random.bow", 1.0f, 1.0f / (this.random.nextFloat() * 0.4f + 0.8f));
                    entityarrow.setHeading(d, d2 + (double)f1, d1, 0.6f, 12.0f);
                    this.world.entityJoinedWorld(entityarrow);
                }
                this.attackTime = 30;
            }
            this.yRot = (float)(Math.atan2(d1, d) * 180.0 / 3.1415927410125732) - 90.0f;
            this.hasAttacked = true;
        }
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
    }

    @Override
    public ItemStack getHeldItem() {
        return defaultHeldItem;
    }
}

