/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.entity.monster;

import net.minecraft.core.WeightedRandomLootObject;
import net.minecraft.core.entity.monster.EntityMonster;
import net.minecraft.core.item.Item;
import net.minecraft.core.util.collection.NamespaceID;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;
import net.minecraft.core.world.weather.Weather;

public class EntityZombie
extends EntityMonster {
    public EntityZombie(World world) {
        super(world);
        this.textureIdentifier = new NamespaceID("minecraft", "zombie");
        this.moveSpeed = 0.5f;
        this.attackStrength = 5;
        this.scoreValue = 300;
        this.mobDrops.add(new WeightedRandomLootObject(Item.cloth.getDefaultStack(), 0, 2));
    }

    @Override
    public void onLivingUpdate() {
        float f;
        if (this.world.isDaytime() && (f = this.getBrightness(1.0f)) > 0.5f && this.world.canBlockSeeTheSky(MathHelper.floor_double(this.x), MathHelper.floor_double(this.y), MathHelper.floor_double(this.z)) && this.random.nextFloat() * 30.0f < (f - 0.4f) * 2.0f && (this.world.getCurrentWeather() != Weather.overworldFog || this.world.weatherManager.getWeatherPower() < 0.75f)) {
            this.remainingFireTicks = 300;
        }
        super.onLivingUpdate();
    }

    @Override
    public String getLivingSound() {
        return "mob.zombie";
    }

    @Override
    protected String getHurtSound() {
        return "mob.zombiehurt";
    }

    @Override
    protected String getDeathSound() {
        return "mob.zombiedeath";
    }
}

