/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.item;

import java.util.Random;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityDispatcher;
import net.minecraft.core.entity.EntityLiving;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.item.IDispensable;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.player.gamemode.Gamemode;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;

public class ItemWandSpawner
extends Item
implements IDispensable {
    public ItemWandSpawner(String name, int id) {
        super(name, id);
    }

    @Override
    public ItemStack onItemRightClick(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        if (entityplayer.gamemode != Gamemode.creative) {
            entityplayer.sendTranslatedChatMessage("wand.wrongmode");
            return itemstack;
        }
        entityplayer.displayGUIWandMonsterPicker(itemstack);
        return itemstack;
    }

    private String getEntityId(ItemStack itemStack) {
        String id = itemStack.getData().getString("monster");
        if (id == null || id.isEmpty()) {
            id = "Pig";
        }
        return id;
    }

    @Override
    public boolean onItemUse(ItemStack itemstack, EntityPlayer entityplayer, World world, int blockX, int blockY, int blockZ, Side side, double xPlaced, double yPlaced) {
        Entity entity;
        if (entityplayer.gamemode != Gamemode.creative) {
            entityplayer.sendTranslatedChatMessage("wand.wrongmode");
            return false;
        }
        if (!world.isClientSide && (entity = EntityDispatcher.createEntityInWorld(this.getEntityId(itemstack), world)) != null) {
            entity.setPos((float)(blockX + side.getOffsetX()) + 0.5f, blockY + side.getOffsetY(), (float)(blockZ + side.getOffsetZ()) + 0.5f);
            entity.spawnInit();
            if (itemstack.hasCustomName() && entity instanceof EntityLiving) {
                ((EntityLiving)entity).setNickname(itemstack.getCustomName());
            }
            world.entityJoinedWorld(entity);
        }
        return true;
    }

    @Override
    public void onDispensed(ItemStack itemStack, World world, double x, double y, double z, int xOffset, int zOffset, Random random) {
        Entity entity = EntityDispatcher.createEntityInWorld(this.getEntityId(itemStack), world);
        if (entity != null) {
            entity.setPos(x + (double)xOffset * 0.5, y, z + (double)zOffset * 0.5);
            entity.spawnInit();
            if (itemStack.hasCustomName() && entity instanceof EntityLiving) {
                ((EntityLiving)entity).setNickname(itemStack.getCustomName());
            }
            world.entityJoinedWorld(entity);
        }
    }

    @Override
    public boolean isRemovedOnDispense() {
        return false;
    }
}

