/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.item.block;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLadder;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.enums.EnumBlockSoundEffectType;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.block.ItemBlock;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;

public class ItemBlockLadder
extends ItemBlock {
    private BlockLadder blockLadder;

    public ItemBlockLadder(BlockLadder block) {
        super(block);
        this.blockLadder = block;
    }

    @Override
    public boolean onItemUse(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, Side side, double xPlaced, double yPlaced) {
        Side sideForPlacement;
        Block clickedBlock = world.getBlock(x, y, z);
        if (clickedBlock == this.blockLadder && !player.isSneaking()) {
            Side clickedLadderSide = this.blockLadder.getSideFromMeta(world.getBlockMetadata(x, y, z));
            while (world.getBlock(x, y, z) == this.blockLadder && this.blockLadder.getSideFromMeta(world.getBlockMetadata(x, y, z)) == clickedLadderSide) {
                --y;
            }
            int meta = this.blockLadder.getMetaForSide(clickedLadderSide);
            if (this.blockLadder.canExistAt(world, x, y, z, meta)) {
                return this.placeBlock(world, x, y, z, meta, player, stack, clickedLadderSide, 0.5);
            }
            return false;
        }
        if (!world.canPlaceInsideBlock(x, y, z)) {
            x += side.getOffsetX();
            y += side.getOffsetY();
            z += side.getOffsetZ();
        }
        if ((sideForPlacement = this.blockLadder.getSideForPlacement(world, x, y, z, side)) == null) {
            return false;
        }
        int meta = this.blockLadder.getMetaForSide(sideForPlacement);
        if (this.blockLadder.canExistAt(world, x, y, z, meta)) {
            return this.placeBlock(world, x, y, z, meta, player, stack, sideForPlacement, yPlaced);
        }
        return false;
    }

    public boolean placeBlock(World world, int x, int y, int z, int meta, EntityPlayer player, ItemStack stack, Side side, double sideHeight) {
        if (world.canPlaceInsideBlock(x, y, z) && world.canBlockBePlacedAt(this.blockID, x, y, z, false, side) && stack.consumeItem(player) && world.setBlockAndMetadataWithNotify(x, y, z, this.blockID, meta)) {
            Block.getBlock(this.blockID).onBlockPlaced(world, x, y, z, side, player, sideHeight);
            world.playBlockSoundEffect(player, (float)x + 0.5f, (float)y + 0.5f, (float)z + 0.5f, this.blockLadder, EnumBlockSoundEffectType.PLACE);
            return true;
        }
        return false;
    }
}

