/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.command;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.net.command.Command;
import net.minecraft.core.net.command.MeCommand;
import net.minecraft.core.net.command.commands.BiomeCommand;
import net.minecraft.core.net.command.commands.ChunkCommand;
import net.minecraft.core.net.command.commands.ClearCommand;
import net.minecraft.core.net.command.commands.ColorCommand;
import net.minecraft.core.net.command.commands.DeopCommand;
import net.minecraft.core.net.command.commands.DifficultyCommand;
import net.minecraft.core.net.command.commands.EmotesCommand;
import net.minecraft.core.net.command.commands.GamemodeCommand;
import net.minecraft.core.net.command.commands.GameruleCommand;
import net.minecraft.core.net.command.commands.GenerateCommand;
import net.minecraft.core.net.command.commands.GiveCommand;
import net.minecraft.core.net.command.commands.HarmCommand;
import net.minecraft.core.net.command.commands.HelpCommand;
import net.minecraft.core.net.command.commands.KillCommand;
import net.minecraft.core.net.command.commands.ListCommand;
import net.minecraft.core.net.command.commands.NicknameCommand;
import net.minecraft.core.net.command.commands.OpCommand;
import net.minecraft.core.net.command.commands.PlaySoundCommand;
import net.minecraft.core.net.command.commands.ScoreCommand;
import net.minecraft.core.net.command.commands.SeedCommand;
import net.minecraft.core.net.command.commands.SetBlockCommand;
import net.minecraft.core.net.command.commands.SetSpawnCommand;
import net.minecraft.core.net.command.commands.SpawnCommand;
import net.minecraft.core.net.command.commands.SpawnParticleCommand;
import net.minecraft.core.net.command.commands.StopCommand;
import net.minecraft.core.net.command.commands.SummonCommand;
import net.minecraft.core.net.command.commands.TeleportCommand;
import net.minecraft.core.net.command.commands.TimeCommand;
import net.minecraft.core.net.command.commands.WeatherCommand;
import net.minecraft.core.net.command.commands.WhisperCommand;
import net.minecraft.core.net.command.commands.WhoisCommand;
import net.minecraft.server.MinecraftServer;

public final class Commands {
    public static List<Command> commands = new ArrayList<Command>();

    public static void initCommands() {
        if (commands.size() > 0) {
            throw new RuntimeException();
        }
        commands.add(new TeleportCommand());
        commands.add(new WhisperCommand());
        commands.add(new GiveCommand());
        commands.add(new HelpCommand());
        commands.add(new WeatherCommand());
        commands.add(new SummonCommand());
        commands.add(new TimeCommand());
        commands.add(new ClearCommand());
        commands.add(new SeedCommand());
        commands.add(new GamemodeCommand());
        commands.add(new SetSpawnCommand());
        commands.add(new SpawnCommand());
        commands.add(new SetBlockCommand());
        commands.add(new KillCommand());
        commands.add(new GenerateCommand());
        commands.add(new ChunkCommand());
        commands.add(new GameruleCommand());
        commands.add(new BiomeCommand());
        commands.add(new SpawnParticleCommand());
        commands.add(new PlaySoundCommand());
        commands.add(new HarmCommand());
    }

    public static void initServerCommands(MinecraftServer server) {
        if (commands.size() > 0) {
            throw new RuntimeException();
        }
        Commands.initCommands();
        commands.add(new StopCommand(server));
        commands.add(new OpCommand(server));
        commands.add(new DeopCommand(server));
        commands.add(new ListCommand(server));
        commands.add(new DifficultyCommand(server));
        commands.add(new ColorCommand(server));
        commands.add(new NicknameCommand(server));
        commands.add(new WhoisCommand(server));
        commands.add(new ScoreCommand(server));
        commands.add(new MeCommand(server));
        commands.add(new EmotesCommand(server));
        commands.add(new BiomeCommand());
    }

    public static void initClientCommands(Minecraft minecraft) {
        if (commands.size() > 0) {
            throw new RuntimeException();
        }
        Commands.initCommands();
    }

    public static Command getCommand(String string) {
        for (Command command : commands) {
            for (String name : command.getNames()) {
                if (!name.equalsIgnoreCase(string)) continue;
                return command;
            }
        }
        return null;
    }
}

