/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.command.commands;

import com.b100.utils.Utils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.core.block.Block;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.net.command.Command;
import net.minecraft.core.net.command.CommandError;
import net.minecraft.core.net.command.CommandHandler;
import net.minecraft.core.net.command.CommandSender;
import net.minecraft.core.net.command.TextFormatting;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.helper.ReflectionHelper;
import net.minecraft.core.world.generate.feature.MethodParametersAnnotation;
import net.minecraft.core.world.generate.feature.WorldFeature;

public class GenerateCommand
extends Command {
    private static Map<String, Class<? extends WorldFeature>> worldFeatures = new HashMap<String, Class<? extends WorldFeature>>();

    public GenerateCommand() {
        super("generate", "gen");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean execute(CommandHandler handler, CommandSender sender, String[] args) {
        if (!sender.isPlayer()) {
            throw new CommandError("Must be used by a player!");
        }
        EntityPlayer player = sender.getPlayer();
        if (args.length < 1) {
            return false;
        }
        if (args[0].equalsIgnoreCase("list")) {
            sender.sendMessage(TextFormatting.LIGHT_GRAY + "Available world features: ");
            Set<String> keys = worldFeatures.keySet();
            StringBuilder string = new StringBuilder();
            int i = 0;
            for (String key : keys) {
                if (i > 0) {
                    string.append(", ");
                }
                string.append(key);
                ++i;
            }
            sender.sendMessage(string.toString());
            return true;
        }
        Class<? extends WorldFeature> worldFeatureClass = GenerateCommand.getWorldFeature(args[0]);
        if (worldFeatureClass == null) {
            throw new CommandError("Feature " + args[0] + " doesn't exist!");
        }
        ArrayList<Object> featureArgs = null;
        Constructor<?> constructor = null;
        for (Constructor<?> c : worldFeatureClass.getConstructors()) {
            if (c.getParameterCount() != args.length - 1) continue;
            ArrayList<Object> featureArgsList = new ArrayList<Object>();
            int i = 0;
            for (Parameter parameter : c.getParameters()) {
                Class<?> type = parameter.getType();
                String arg = args[i + 1];
                if (type == String.class) {
                    featureArgsList.add(arg);
                } else if (type == Integer.TYPE) {
                    featureArgsList.add(Integer.parseInt(arg));
                } else {
                    Block block;
                    if (type != Block.class) throw new RuntimeException("Can't parse type: " + type.getName());
                    try {
                        block = Block.blocksList[Integer.parseInt(arg)];
                    }
                    catch (Exception e) {
                        block = Block.getBlockByName(arg);
                    }
                    if (block == null) throw new CommandError("Can't find block: " + arg);
                    featureArgsList.add(block);
                }
                ++i;
            }
            constructor = c;
            featureArgs = featureArgsList;
        }
        if (constructor == null) {
            sender.sendMessage("Feature " + worldFeatureClass.getSimpleName() + " requires arguments: ");
            for (Constructor<?> c : worldFeatureClass.getConstructors()) {
                StringBuilder argString = new StringBuilder();
                MethodParametersAnnotation annotation = null;
                if (c.isAnnotationPresent(MethodParametersAnnotation.class)) {
                    annotation = c.getAnnotation(MethodParametersAnnotation.class);
                }
                int i = 0;
                for (Parameter parameter : c.getParameters()) {
                    if (i > 0) {
                        argString.append(", ");
                    }
                    String argname = annotation != null && annotation.names().length > i ? annotation.names()[i] : parameter.getName();
                    argString.append(argname).append(" (").append(parameter.getType().getSimpleName()).append(")");
                    ++i;
                }
                sender.sendMessage(argString.toString());
            }
            return true;
        }
        WorldFeature feature = GenerateCommand.createWorldFeature(worldFeatureClass, constructor, featureArgs);
        if (feature.generate(handler.getWorld(player), new Random(), MathHelper.floor_double(player.x), MathHelper.floor_double(player.y), MathHelper.floor_double(player.z))) return true;
        throw new CommandError("Could not spawn feature here!");
    }

    public static WorldFeature createWorldFeature(Class<? extends WorldFeature> worldFeatureClass, Constructor<?> constructor, List<Object> featureArgs) {
        if (featureArgs.size() != constructor.getParameterCount()) {
            throw new RuntimeException("Invalid Parameter Count!");
        }
        try {
            return (WorldFeature)constructor.newInstance(Utils.toArray(Object.class, featureArgs));
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static Class<? extends WorldFeature> getWorldFeature(String name) {
        for (Map.Entry<String, Class<? extends WorldFeature>> entry : worldFeatures.entrySet()) {
            if (!entry.getKey().equalsIgnoreCase(name)) continue;
            return entry.getValue();
        }
        return null;
    }

    @Override
    public boolean opRequired(String[] args) {
        return true;
    }

    @Override
    public void sendCommandSyntax(CommandHandler handler, CommandSender sender) {
        sender.sendMessage("/generate <feature> [params...]");
        sender.sendMessage("/generate <list>");
    }

    static {
        try {
            for (Class<?> clazz : ReflectionHelper.getAllClasses(className -> className.startsWith("net.minecraft.core.world.generate.feature"))) {
                if (!WorldFeature.class.isAssignableFrom(clazz) || clazz == WorldFeature.class) continue;
                Class<?> worldGenClass = clazz;
                worldFeatures.put(clazz.getSimpleName().substring(12), worldGenClass);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

