/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.net;

import java.util.Set;
import net.minecraft.core.net.ICommandListener;
import net.minecraft.core.net.ServerCommand;
import net.minecraft.core.net.command.Command;
import net.minecraft.core.net.command.CommandError;
import net.minecraft.core.net.command.Commands;
import net.minecraft.core.net.command.ConsoleCommandSender;
import net.minecraft.core.net.command.TextFormatting;
import net.minecraft.core.net.packet.Packet3Chat;
import net.minecraft.core.player.gamemode.Gamemode;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.entity.player.EntityPlayerMP;
import net.minecraft.server.net.PlayerList;
import net.minecraft.server.world.WorldServer;
import org.apache.log4j.Logger;

public class ConsoleCommandHandler {
    private static Logger minecraftLogger = Logger.getLogger("Minecraft");
    private MinecraftServer minecraftServer;
    public final ConsoleCommandSender sender;

    public ConsoleCommandHandler(MinecraftServer server) {
        this.minecraftServer = server;
        Commands.initServerCommands(server);
        this.sender = new ConsoleCommandSender(server);
    }

    public boolean handleCommandNew(ServerCommand serverCommand) {
        System.out.println("ServerCommand: " + serverCommand.command);
        String[] args = serverCommand.command.split(" ");
        String[] args1 = new String[args.length - 1];
        System.arraycopy(args, 1, args1, 0, args.length - 1);
        for (Command command : Commands.commands) {
            if (!command.isName(args[0])) continue;
            try {
                boolean success = command.execute(this.minecraftServer.serverCommandHandler, this.sender, args1);
                if (!success) {
                    command.sendCommandSyntax(this.minecraftServer.serverCommandHandler, this.sender);
                }
            }
            catch (CommandError e) {
                this.sender.sendMessage(TextFormatting.RED + e.getMessage());
            }
            return true;
        }
        return false;
    }

    public void handleCommand(ServerCommand servercommand) {
        String s = servercommand.command;
        ICommandListener icommandlistener = servercommand.commandListener;
        String s1 = icommandlistener.getUsername();
        PlayerList serverconfigurationmanager = this.minecraftServer.playerList;
        if (!this.handleCommandNew(servercommand)) {
            if (s.toLowerCase().startsWith("help") || s.toLowerCase().startsWith("?")) {
                this.printHelp(icommandlistener);
            } else if (s.toLowerCase().startsWith("save-all")) {
                this.sendNoticeToOps(s1, "Forcing save..");
                if (serverconfigurationmanager != null) {
                    serverconfigurationmanager.savePlayerStates();
                }
                for (int i = 0; i < this.minecraftServer.dimensionWorlds.length; ++i) {
                    WorldServer worldserver = this.minecraftServer.dimensionWorlds[i];
                    worldserver.saveWorld(true, null, i == 0);
                }
                this.sendNoticeToOps(s1, "Save complete.");
            } else if (s.toLowerCase().startsWith("save-off")) {
                this.sendNoticeToOps(s1, "Disabling level saving..");
                for (int j = 0; j < this.minecraftServer.dimensionWorlds.length; ++j) {
                    WorldServer worldserver1 = this.minecraftServer.dimensionWorlds[j];
                    worldserver1.levelSaving = true;
                }
            } else if (s.toLowerCase().startsWith("save-on")) {
                this.sendNoticeToOps(s1, "Enabling level saving..");
                for (int k = 0; k < this.minecraftServer.dimensionWorlds.length; ++k) {
                    WorldServer worldserver2 = this.minecraftServer.dimensionWorlds[k];
                    worldserver2.levelSaving = false;
                }
            } else if (s.toLowerCase().startsWith("ban-ip ")) {
                String s4 = s.substring(s.indexOf(" ")).trim();
                serverconfigurationmanager.banIP(s4);
                this.sendNoticeToOps(s1, "Banning ip " + s4);
            } else if (s.toLowerCase().startsWith("pardon-ip ")) {
                String s5 = s.substring(s.indexOf(" ")).trim();
                serverconfigurationmanager.pardonIP(s5);
                this.sendNoticeToOps(s1, "Pardoning ip " + s5);
            } else if (s.toLowerCase().startsWith("ban ")) {
                String s6 = s.substring(s.indexOf(" ")).trim();
                serverconfigurationmanager.banPlayer(s6);
                this.sendNoticeToOps(s1, "Banning " + s6);
                EntityPlayerMP entityplayermp = serverconfigurationmanager.getPlayerEntity(s6);
                if (entityplayermp != null) {
                    entityplayermp.playerNetServerHandler.kickPlayer("Banned by admin");
                }
            } else if (s.toLowerCase().startsWith("pardon ")) {
                String s7 = s.substring(s.indexOf(" ")).trim();
                serverconfigurationmanager.pardonPlayer(s7);
                this.sendNoticeToOps(s1, "Pardoning " + s7);
            } else if (s.toLowerCase().startsWith("kick ")) {
                String s8 = s.substring(s.indexOf(" ")).trim();
                EntityPlayerMP entityplayermp1 = null;
                for (int l = 0; l < serverconfigurationmanager.playerEntities.size(); ++l) {
                    EntityPlayerMP entityplayermp5 = serverconfigurationmanager.playerEntities.get(l);
                    if (!entityplayermp5.username.equalsIgnoreCase(s8)) continue;
                    entityplayermp1 = entityplayermp5;
                }
                if (entityplayermp1 != null) {
                    entityplayermp1.playerNetServerHandler.kickPlayer("Kicked by admin");
                    this.sendNoticeToOps(s1, "Kicking " + entityplayermp1.getDisplayName());
                } else {
                    icommandlistener.log("Can't find user " + s8 + ". No kick.");
                }
            } else if (s.toLowerCase().startsWith("say ")) {
                s = s.substring(s.indexOf(" ")).trim();
                minecraftLogger.info("[" + s1 + "] " + s);
                serverconfigurationmanager.sendPacketToAllPlayers(new Packet3Chat(TextFormatting.PINK + "[Server] " + s));
            } else if (s.toLowerCase().startsWith("whitelist ")) {
                this.handleWhitelist(s1, s, icommandlistener);
            } else if (s.startsWith("gamemode ")) {
                String[] as = s.split(" ");
                if (as.length == 3) {
                    int gamemodeId = -1;
                    try {
                        gamemodeId = Integer.parseInt(as[2]);
                    }
                    catch (Exception e) {
                        icommandlistener.log("Unknown or invalid gamemode ID.");
                    }
                    if (gamemodeId != -1) {
                        if (gamemodeId >= Gamemode.gamemodesList.length || Gamemode.gamemodesList[gamemodeId] == null) {
                            icommandlistener.log("Unknown or invalid gamemode ID.");
                        } else {
                            EntityPlayerMP player = serverconfigurationmanager.getPlayerEntity(as[1]);
                            if (player == null) {
                                icommandlistener.log("There's no player by that name online.");
                            } else {
                                player.setGamemode(Gamemode.gamemodesList[gamemodeId]);
                                this.sendNoticeToOps(s1, "Setting " + player.getDisplayName() + "\u00a77" + "'s gamemode to " + Gamemode.gamemodesList[gamemodeId].getLanguageKey());
                            }
                        }
                    }
                }
            } else {
                minecraftLogger.info("Unknown console command. Type \"help\" for help.");
            }
        }
    }

    private void handleWhitelist(String s, String s1, ICommandListener icommandlistener) {
        String[] as = s1.split(" ");
        if (as.length < 2) {
            return;
        }
        String s2 = as[1].toLowerCase();
        if ("on".equals(s2)) {
            this.sendNoticeToOps(s, "Turned on white-listing");
            this.minecraftServer.propertyManager.setProperty("white-list", true);
        } else if ("off".equals(s2)) {
            this.sendNoticeToOps(s, "Turned off white-listing");
            this.minecraftServer.propertyManager.setProperty("white-list", false);
        } else if ("list".equals(s2)) {
            Set set = this.minecraftServer.playerList.getWhitelist();
            String s5 = "";
            for (String s6 : set) {
                s5 = s5 + s6 + " ";
            }
            icommandlistener.log("White-listed players: " + s5);
        } else if ("add".equals(s2) && as.length == 3) {
            String s3 = as[2].toLowerCase();
            this.minecraftServer.playerList.addToWhiteList(s3);
            this.sendNoticeToOps(s, "Added " + s3 + " to white-list");
        } else if ("remove".equals(s2) && as.length == 3) {
            String s4 = as[2].toLowerCase();
            this.minecraftServer.playerList.removeFromWhiteList(s4);
            this.sendNoticeToOps(s, "Removed " + s4 + " from white-list");
        } else if ("reload".equals(s2)) {
            this.minecraftServer.playerList.reloadWhiteList();
            this.sendNoticeToOps(s, "Reloaded white-list from file");
        }
    }

    private void printHelp(ICommandListener icommandlistener) {
        icommandlistener.log("To run the server without a gui, start it like this:");
        icommandlistener.log("   java -Xmx1024M -Xms1024M -jar minecraft_server.jar nogui");
        icommandlistener.log("Console commands:");
        icommandlistener.log("   help  or  ?               shows this message");
        icommandlistener.log("   kick <player>             removes a player from the server");
        icommandlistener.log("   ban <player>              bans a player from the server");
        icommandlistener.log("   pardon <player>           pardons a banned player so that they can connect again");
        icommandlistener.log("   ban-ip <ip>               bans an IP address from the server");
        icommandlistener.log("   pardon-ip <ip>            pardons a banned IP address so that they can connect again");
        icommandlistener.log("   op <player>               turns a player into an op");
        icommandlistener.log("   deop <player>             removes op status from a player");
        icommandlistener.log("   tp <player1> <player2>    moves one player to the same location as another player");
        icommandlistener.log("   give <player> <id> [num]  gives a player a resource");
        icommandlistener.log("   tell <player> <message>   sends a private message to a player");
        icommandlistener.log("   stop                      gracefully stops the server");
        icommandlistener.log("   save-all                  forces a server-wide level save");
        icommandlistener.log("   save-off                  disables terrain saving (useful for backup scripts)");
        icommandlistener.log("   save-on                   re-enables terrain saving");
        icommandlistener.log("   list                      lists all currently connected players");
        icommandlistener.log("   say <message>             broadcasts a message to all players");
        icommandlistener.log("   time <add|set> <amount>   adds to or sets the world time (0-24000)");
        icommandlistener.log("   gamemode <player> <id>   sets the target player's gamemode");
        icommandlistener.log("   setspawn <x> <y> <z>   sets the server spawn point to the given coordinates");
    }

    private void sendNoticeToOps(String s, String s1) {
        String s2 = s + ": " + s1;
        this.minecraftServer.playerList.sendChatMessageToAllOps("\u00a77(" + s2 + ")");
        minecraftLogger.info(s2);
    }

    private int tryParse(String s, int i) {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException numberformatexception) {
            return i;
        }
    }
}

