/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiSelectServer;
import net.minecraft.client.net.handler.NetClientHandler;
import net.minecraft.client.net.thread.ThreadConnectToServer;
import net.minecraft.core.lang.I18n;

public class GuiConnecting
extends GuiScreen {
    private NetClientHandler clientHandler;
    private boolean cancelled = false;

    public GuiConnecting(Minecraft minecraft, String s, int i) {
        System.out.println("Connecting to " + s + ", " + i);
        minecraft.changeWorld(null);
        new ThreadConnectToServer(this, minecraft, s, i).start();
    }

    @Override
    public void tick() {
        if (this.clientHandler != null) {
            this.clientHandler.processReadPackets();
        }
    }

    @Override
    public void keyTyped(char c, int i, int mouseX, int mouseY) {
    }

    @Override
    public void init() {
        I18n stringtranslate = I18n.getInstance();
        this.controlList.clear();
        this.controlList.add(new GuiButton(0, this.width / 2 - 100, this.height / 4 + 120 + 12, stringtranslate.translateKey("gui.connecting.button.cancel")));
    }

    @Override
    protected void buttonPressed(GuiButton button) {
        if (button.id == 0) {
            this.cancelled = true;
            if (this.clientHandler != null) {
                this.clientHandler.disconnect();
            }
            this.mc.displayGuiScreen(new GuiSelectServer(new GuiMainMenu()));
        }
    }

    @Override
    public void drawScreen(int mouseX, int mouseY, float partialTick) {
        this.drawDefaultBackground();
        I18n stringtranslate = I18n.getInstance();
        if (this.clientHandler == null) {
            this.drawStringCentered(this.fontRenderer, stringtranslate.translateKey("gui.connecting.label.connecting"), this.width / 2, this.height / 2 - 50, 0xFFFFFF);
            this.drawStringCentered(this.fontRenderer, "", this.width / 2, this.height / 2 - 10, 0xFFFFFF);
        } else {
            this.drawStringCentered(this.fontRenderer, stringtranslate.translateKey("gui.connecting.label.logging_in"), this.width / 2, this.height / 2 - 50, 0xFFFFFF);
            this.drawStringCentered(this.fontRenderer, this.clientHandler.field_1209_a, this.width / 2, this.height / 2 - 10, 0xFFFFFF);
        }
        super.drawScreen(mouseX, mouseY, partialTick);
    }

    public static NetClientHandler setNetClientHandler(GuiConnecting guiconnecting, NetClientHandler netclienthandler) {
        guiconnecting.clientHandler = netclienthandler;
        return guiconnecting.clientHandler;
    }

    public static boolean isCancelled(GuiConnecting guiconnecting) {
        return guiconnecting.cancelled;
    }

    public static NetClientHandler getNetClientHandler(GuiConnecting guiconnecting) {
        return guiconnecting.clientHandler;
    }
}

