/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.player.controller;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.EntityClientPlayerMP;
import net.minecraft.client.net.handler.NetClientHandler;
import net.minecraft.client.player.controller.PlayerController;
import net.minecraft.core.InventoryAction;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.enums.ArtType;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.net.packet.Packet102WindowClick;
import net.minecraft.core.net.packet.Packet139SetPaintingMotive;
import net.minecraft.core.net.packet.Packet14BlockDig;
import net.minecraft.core.net.packet.Packet15Place;
import net.minecraft.core.net.packet.Packet16BlockItemSwitch;
import net.minecraft.core.net.packet.Packet7UseEntity;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;

public class PlayerControllerMP
extends PlayerController {
    protected NetClientHandler netHandler;
    protected int currentItem;

    public PlayerControllerMP(Minecraft minecraft, NetClientHandler netHandler) {
        super(minecraft);
        this.netHandler = netHandler;
    }

    @Override
    public boolean destroyBlock(int x, int y, int z, Side side, EntityPlayer player) {
        int id = this.mc.theWorld.getBlockId(x, y, z);
        boolean removed = super.destroyBlock(x, y, z, side, player);
        ItemStack item = this.mc.thePlayer.getCurrentEquippedItem();
        if (item != null) {
            item.onDestroyBlock(this.mc.theWorld, id, x, y, z, this.mc.thePlayer);
            if (item.stackSize <= 0) {
                this.mc.thePlayer.destroyCurrentEquippedItem();
            }
        }
        return removed;
    }

    @Override
    protected void hitBlock(int x, int y, int z, Side side) {
        super.hitBlock(x, y, z, side);
        this.netHandler.addToSendQueue(new Packet14BlockDig(1, x, y, z, side));
    }

    @Override
    public void sendStartDigPacket(int x, int y, int z, Side side) {
        this.netHandler.addToSendQueue(new Packet14BlockDig(0, x, y, z, side));
    }

    @Override
    public void sendDestroyBlockPacket(int x, int y, int z, Side side) {
        this.netHandler.addToSendQueue(new Packet14BlockDig(2, x, y, z, side));
    }

    @Override
    protected void syncCurrentPlayItem() {
        int i = this.mc.thePlayer.inventory.currentItem;
        if (i != this.currentItem) {
            this.currentItem = i;
            this.netHandler.addToSendQueue(new Packet16BlockItemSwitch(this.currentItem));
        }
    }

    @Override
    public boolean useItemOn(EntityPlayer entityplayer, World world, ItemStack itemstack, int blockX, int blockY, int blockZ, Side side, double xPlaced, double yPlaced) {
        this.syncCurrentPlayItem();
        this.netHandler.addToSendQueue(new Packet15Place(blockX, blockY, blockZ, side.getDirection(), entityplayer.inventory.getCurrentItem(), xPlaced, yPlaced));
        boolean flag = super.useItemOn(entityplayer, world, itemstack, blockX, blockY, blockZ, side, xPlaced, yPlaced);
        return flag;
    }

    @Override
    public boolean useItem(EntityPlayer entityplayer, World world, ItemStack itemstack) {
        this.syncCurrentPlayItem();
        this.netHandler.addToSendQueue(new Packet15Place(-1, -1, -1, Direction.NONE, entityplayer.inventory.getCurrentItem(), 0.0, 0.0));
        boolean flag = super.useItem(entityplayer, world, itemstack);
        return flag;
    }

    @Override
    public EntityPlayer createPlayer(World world) {
        return new EntityClientPlayerMP(this.mc, world, this.mc.session, this.netHandler);
    }

    @Override
    public void attack(EntityPlayer entityplayer, Entity entity) {
        this.syncCurrentPlayItem();
        this.netHandler.addToSendQueue(new Packet7UseEntity(entityplayer.id, entity.id, 1));
        entityplayer.attackTargetEntityWithCurrentItem(entity);
    }

    @Override
    public boolean interact(EntityPlayer entityplayer, Entity entity) {
        this.syncCurrentPlayItem();
        this.netHandler.addToSendQueue(new Packet7UseEntity(entityplayer.id, entity.id, 0));
        return entityplayer.useCurrentItemOnEntity(entity);
    }

    @Override
    public ItemStack handleInventoryMouseClick(int windowId, InventoryAction action, int[] args, EntityPlayer entityplayer) {
        short actionId = entityplayer.craftingInventory.getActionId(entityplayer.inventory);
        ItemStack itemstack = super.handleInventoryMouseClick(windowId, action, args, entityplayer);
        this.netHandler.addToSendQueue(new Packet102WindowClick(windowId, action, args, itemstack, actionId));
        return itemstack;
    }

    @Override
    public void handleCloseInventory(int i, EntityPlayer entityplayer) {
        if (i == -9999) {
            // empty if block
        }
    }

    @Override
    public void setPaintingType(ArtType art) {
        this.netHandler.addToSendQueue(new Packet139SetPaintingMotive(art));
    }
}

