/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render;

import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.fx.EntityRainFX;
import net.minecraft.client.entity.fx.EntitySmokeFX;
import net.minecraft.client.entity.player.EntityPlayerSP;
import net.minecraft.client.gui.GuiPhotoMode;
import net.minecraft.client.gui.modelviewer.GuiModelViewer;
import net.minecraft.client.input.InputType;
import net.minecraft.client.input.MouseFilter;
import net.minecraft.client.input.PlayerInput;
import net.minecraft.client.option.enums.RenderDistance;
import net.minecraft.client.render.EffectRenderer;
import net.minecraft.client.render.FogManager;
import net.minecraft.client.render.ItemRenderer;
import net.minecraft.client.render.Lighting;
import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.RenderGlobal;
import net.minecraft.client.render.camera.CameraUtil;
import net.minecraft.client.render.camera.EntityCamera;
import net.minecraft.client.render.camera.EntityCameraFirstPerson;
import net.minecraft.client.render.camera.EntityCameraIsometric;
import net.minecraft.client.render.camera.EntityCameraSleeping;
import net.minecraft.client.render.camera.EntityCameraThirdPersonFront;
import net.minecraft.client.render.camera.EntityCameraThirdPersonRear;
import net.minecraft.client.render.colorizer.Colorizers;
import net.minecraft.client.render.culling.Frustum;
import net.minecraft.client.render.stitcher.TextureRegistry;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.window.GameWindowLWJGL2;
import net.minecraft.client.util.debug.Debug;
import net.minecraft.client.world.chunk.provider.ChunkProviderStatic;
import net.minecraft.core.HitResult;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityLiving;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.sound.SoundCategory;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.helper.Time;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.util.phys.Vec3d;
import net.minecraft.core.world.World;
import net.minecraft.core.world.biome.Biome;
import net.minecraft.core.world.chunk.provider.IChunkProvider;
import net.minecraft.core.world.weather.Weather;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.GLU;

public class WorldRenderer {
    public static final long nsPerSecond = 1000000000L;
    public final LightmapHelper lightmapHelper;
    public Minecraft mc;
    private float farPlaneDistance;
    public ItemRenderer itemRenderer;
    public FogManager fogManager;
    private int rendererUpdateCount;
    private Entity pointedEntity;
    private MouseFilter mouseFilterXAxis;
    private MouseFilter mouseFilterYAxis;
    private float fovModifier;
    private float fovModifierLast;
    private long systemTime;
    private Random random;
    private int rainSoundCounter;
    public boolean zooming = false;
    private float zoomProgress;
    private float b = 1.0f;
    private float a = 1.0f;
    private float currentFovModifier = 1.0f;

    public WorldRenderer(Minecraft minecraft) {
        this.mc = minecraft;
        this.lightmapHelper = new LightmapHelper(minecraft, this);
        this.farPlaneDistance = 0.0f;
        this.pointedEntity = null;
        this.mouseFilterXAxis = new MouseFilter();
        this.mouseFilterYAxis = new MouseFilter();
        this.fovModifier = 0.0f;
        this.fovModifierLast = 0.0f;
        this.systemTime = 0L;
        this.random = new Random();
        this.rainSoundCounter = 0;
        this.itemRenderer = new ItemRenderer(minecraft);
        this.fogManager = new FogManager(this.mc);
    }

    public void updateRenderer() {
        this.updateSpeedFov();
        this.fovModifierLast = this.fovModifier;
        if (this.mc.activeCamera == null) {
            this.mc.activeCamera = new EntityCameraFirstPerson(this.mc, this.mc.thePlayer);
        }
        this.mc.activeCamera.tick();
        this.fogManager.updateBrightness();
        ++this.rendererUpdateCount;
        this.itemRenderer.updateEquippedItem();
        this.addRainParticles();
        this.lightmapHelper.tick();
    }

    private void updateSpeedFov() {
        EntityPlayerSP player = this.mc.thePlayer;
        this.currentFovModifier = player.getFovModifier();
        this.a = this.b;
        this.b += (this.currentFovModifier - this.b) * 0.5f;
    }

    public void getMouseOver(float partialTicks) {
        if (this.mc.activeCamera == null) {
            return;
        }
        if (this.mc.theWorld == null) {
            return;
        }
        double blockReach = this.mc.playerController.getBlockReachDistance();
        double entityReach = this.mc.playerController.getEntityReachDistance();
        Vec3d pos1 = this.mc.thePlayer.getPosition(partialTicks);
        Vec3d look = this.mc.thePlayer.getViewVector(partialTicks);
        Vec3d pos2 = pos1.addVector(look.xCoord * blockReach, look.yCoord * blockReach, look.zCoord * blockReach);
        this.mc.objectMouseOver = this.mc.theWorld.checkBlockCollisionBetweenPoints(pos1, pos2);
        pos1 = this.mc.thePlayer.getPosition(partialTicks);
        look = this.mc.thePlayer.getViewVector(partialTicks);
        pos2 = pos1.addVector(look.xCoord * entityReach, look.yCoord * entityReach, look.zCoord * entityReach);
        double hitBlockDistance = 1000.0;
        if (this.mc.objectMouseOver != null) {
            hitBlockDistance = pos1.distanceTo(this.mc.objectMouseOver.location);
        }
        this.pointedEntity = null;
        float expand = 1.0f;
        AABB entitySearchBox = this.mc.thePlayer.bb.addCoord(look.xCoord * entityReach, look.yCoord * entityReach, look.zCoord * entityReach).expand(expand, expand, expand);
        List<Entity> entities = this.mc.theWorld.getEntitiesWithinAABBExcludingEntity(this.mc.thePlayer, entitySearchBox);
        double pointedEntityDistance = 0.0;
        for (int i = 0; i < entities.size(); ++i) {
            Entity entity = entities.get(i);
            if (!entity.isSelectable()) continue;
            float hitRadius = entity.getPickRadius();
            AABB hitBox = entity.bb.expand(hitRadius, hitRadius, hitRadius);
            if (hitBox.isVecInside(pos1)) {
                this.pointedEntity = entity;
                pointedEntityDistance = 0.0;
                continue;
            }
            HitResult hitResult = hitBox.func_1169_a(pos1, pos2);
            if (hitResult == null) continue;
            double entityDistance = pos1.distanceTo(hitResult.location);
            if (this.pointedEntity != null && !(entityDistance < pointedEntityDistance)) continue;
            this.pointedEntity = entity;
            pointedEntityDistance = entityDistance;
        }
        if (pointedEntityDistance > hitBlockDistance || pointedEntityDistance > entityReach) {
            this.pointedEntity = null;
        }
        if (this.pointedEntity != null) {
            this.mc.objectMouseOver = new HitResult(this.pointedEntity);
        }
    }

    private float getFOVModifier(float partialTick, boolean isModifiedByFOV) {
        EntityLiving entityliving = null;
        if (this.mc.activeCamera instanceof EntityCamera) {
            entityliving = ((EntityCamera)this.mc.activeCamera).entity;
        }
        float f1 = 70.0f;
        if (isModifiedByFOV) {
            f1 = (int)(this.mc.activeCamera.getFov() * 100.0 + 30.0);
            f1 *= this.a + (this.b - this.a) * partialTick;
        }
        if (CameraUtil.isUnderLiquid(this.mc.activeCamera, this.mc.theWorld, Material.water, partialTick)) {
            f1 -= 10.0f;
        }
        if (entityliving != null && entityliving.getHealth() <= 0) {
            float f2 = (float)entityliving.deathTime + partialTick;
            f1 /= (1.0f - 500.0f / (f2 + 500.0f)) * 2.0f + 1.0f;
        }
        return f1 + this.fovModifierLast + (this.fovModifier - this.fovModifierLast) * partialTick;
    }

    private void hurtCameraEffect(float partialTick) {
        if (!(this.mc.activeCamera instanceof EntityCamera)) {
            return;
        }
        EntityLiving entityliving = ((EntityCamera)this.mc.activeCamera).entity;
        float f1 = (float)entityliving.hurtTime - partialTick;
        if (entityliving.getHealth() <= 0) {
            float f2 = (float)entityliving.deathTime + partialTick;
            GL11.glRotatef((float)(40.0f - 8000.0f / (f2 + 200.0f)), (float)0.0f, (float)0.0f, (float)1.0f);
        }
        if (f1 < 0.0f) {
            return;
        }
        f1 /= (float)entityliving.maxHurtTime;
        f1 = MathHelper.sin(f1 * f1 * f1 * f1 * 3.141593f);
        float f3 = entityliving.attackedAtYaw;
        GL11.glRotatef((float)(-f3), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(-f1 * 14.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glRotatef((float)f3, (float)0.0f, (float)1.0f, (float)0.0f);
    }

    private void setupViewBobbing(float partialTick) {
        if (this.mc.activeCamera instanceof EntityCamera && ((EntityCamera)this.mc.activeCamera).entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)((EntityCamera)this.mc.activeCamera).entity;
            float walkDist = -MathHelper.lerp(player.walkDistO, player.walkDist, partialTick);
            float cameraVel = MathHelper.lerp(player.cameraVelocityOld, player.cameraVelocity, partialTick);
            float cameraPitch = MathHelper.lerp(player.prevCameraPitch, player.cameraPitch, partialTick);
            if (player.isSkating) {
                walkDist *= 0.25f;
                cameraPitch *= 0.25f;
            }
            GL11.glTranslatef((float)(MathHelper.sin(walkDist * (float)Math.PI) * cameraVel * 0.5f), (float)(-Math.abs(MathHelper.cos(walkDist * (float)Math.PI) * cameraVel)), (float)0.0f);
            GL11.glRotatef((float)(MathHelper.sin(walkDist * (float)Math.PI) * cameraVel * 3.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)(Math.abs(MathHelper.cos(walkDist * (float)Math.PI - 0.2f) * cameraVel) * 5.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)cameraPitch, (float)1.0f, (float)0.0f, (float)0.0f);
        }
    }

    private void setupCamera(float partialTick) {
        if (this.mc.activeCamera instanceof EntityCamera) {
            EntityLiving entityliving = ((EntityCamera)this.mc.activeCamera).entity;
            if (this.mc.currentScreen instanceof GuiPhotoMode) {
                this.mc.activeCamera = new EntityCameraIsometric(this.mc, entityliving);
            } else if (entityliving.isPlayerSleeping()) {
                if (!(this.mc.activeCamera instanceof EntityCameraSleeping)) {
                    this.mc.activeCamera = new EntityCameraSleeping(this.mc, entityliving, MathHelper.floor_double(entityliving.x), MathHelper.floor_double(entityliving.y), MathHelper.floor_double(entityliving.z), this.mc.activeCamera.getX(partialTick), this.mc.activeCamera.getY(partialTick), this.mc.activeCamera.getZ(partialTick), this.mc.activeCamera.getYRot(partialTick), this.mc.activeCamera.getXRot(partialTick));
                }
            } else if ((Integer)this.mc.gameSettings.thirdPersonView.value == 0 && !(this.mc.activeCamera instanceof EntityCameraFirstPerson)) {
                this.mc.activeCamera = new EntityCameraFirstPerson(this.mc, entityliving);
            } else if ((Integer)this.mc.gameSettings.thirdPersonView.value == 1 && !(this.mc.activeCamera instanceof EntityCameraThirdPersonRear)) {
                this.mc.activeCamera = new EntityCameraThirdPersonRear(this.mc, entityliving);
            } else if ((Integer)this.mc.gameSettings.thirdPersonView.value == 2 && !(this.mc.activeCamera instanceof EntityCameraThirdPersonFront)) {
                this.mc.activeCamera = new EntityCameraThirdPersonFront(this.mc, entityliving);
            }
        }
    }

    private void orientCamera(float partialTick) {
        this.setupCamera(partialTick);
        this.mc.activeCamera.applyGlTransformations();
        if (!(this.mc.currentScreen instanceof GuiPhotoMode) && !((Boolean)this.mc.gameSettings.lockCamera.value).booleanValue()) {
            GL11.glRotatef((float)((float)this.mc.activeCamera.getXRot(partialTick)), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)((float)(this.mc.activeCamera.getYRot(partialTick) + 180.0)), (float)0.0f, (float)1.0f, (float)0.0f);
        }
        if (this.mc.currentScreen instanceof GuiPhotoMode) {
            GL11.glRotatef((float)((GuiPhotoMode)this.mc.currentScreen).getTilt(partialTick), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)(45.0f + 45.0f * ((GuiPhotoMode)this.mc.currentScreen).getRotation(partialTick)), (float)0.0f, (float)1.0f, (float)0.0f);
        }
    }

    private void setupCameraTransform(float partialTick) {
        float f2;
        this.farPlaneDistance = ((RenderDistance)((Object)this.mc.gameSettings.renderDistance.value)).chunks * 16;
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        float fov = this.getFOVModifier(partialTick, true);
        if (this.zooming) {
            fov = this.getZoomedFOV(fov, partialTick);
        } else {
            this.zoomProgress = 0.0f;
        }
        if (this.mc.currentScreen instanceof GuiPhotoMode) {
            double div = Math.pow(2.0, ((GuiPhotoMode)this.mc.currentScreen).getZoom(partialTick));
            GL11.glTranslatef((float)1.0f, (float)1.0f, (float)0.0f);
            GL11.glOrtho((double)0.0, (double)((double)this.mc.resolution.width / div), (double)0.0, (double)((double)this.mc.resolution.height / div), (double)(this.farPlaneDistance * -2.0f), (double)(this.farPlaneDistance * 2.0f));
            GL11.glTranslatef((float)((GuiPhotoMode)this.mc.currentScreen).getPanX(partialTick), (float)(-((GuiPhotoMode)this.mc.currentScreen).getPanY(partialTick)), (float)0.0f);
        } else {
            GLU.gluPerspective((float)fov, (float)((float)this.mc.resolution.width / (float)this.mc.resolution.height), (float)0.05f, (float)(this.farPlaneDistance * 2.0f));
        }
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        this.hurtCameraEffect(partialTick);
        if (((Boolean)this.mc.gameSettings.viewBobbing.value).booleanValue() && !(this.mc.currentScreen instanceof GuiPhotoMode)) {
            this.setupViewBobbing(partialTick);
        }
        if ((f2 = this.mc.thePlayer.prevTimeInPortal + (this.mc.thePlayer.timeInPortal - this.mc.thePlayer.prevTimeInPortal) * partialTick) > 0.0f) {
            float f3 = 5.0f / (f2 * f2 + 5.0f) - f2 * 0.04f;
            f3 *= f3;
            GL11.glRotatef((float)(((float)this.rendererUpdateCount + partialTick) * 20.0f), (float)0.0f, (float)1.0f, (float)1.0f);
            GL11.glScalef((float)(1.0f / f3), (float)1.0f, (float)1.0f);
            GL11.glRotatef((float)(-((float)this.rendererUpdateCount + partialTick) * 20.0f), (float)0.0f, (float)1.0f, (float)1.0f);
        }
        this.orientCamera(partialTick);
    }

    private void renderHand(float partialTick) {
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        float fov = this.getFOVModifier(partialTick, false);
        if (this.zooming) {
            fov = this.getZoomedFOV(fov, partialTick);
        } else {
            this.zoomProgress = 0.0f;
        }
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-1.0f);
        GL11.glScalef((float)1.0f, (float)1.0f, (float)0.1f);
        GLU.gluPerspective((float)fov, (float)((float)this.mc.resolution.width / (float)this.mc.resolution.height), (float)0.05f, (float)(this.farPlaneDistance * 2.0f));
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glPushMatrix();
        this.hurtCameraEffect(partialTick);
        if (((Boolean)this.mc.gameSettings.viewBobbing.value).booleanValue()) {
            this.setupViewBobbing(partialTick);
        }
        if ((Integer)this.mc.gameSettings.thirdPersonView.value == 0 && !(this.mc.currentScreen instanceof GuiPhotoMode) && this.mc.activeCamera instanceof EntityCamera && !((EntityCamera)this.mc.activeCamera).entity.isPlayerSleeping() && this.mc.gameSettings.immersiveMode.drawHand()) {
            this.lightmapHelper.enableLightmapRendering();
            if (!this.zooming) {
                this.itemRenderer.renderItemInFirstPerson(partialTick);
            }
            this.lightmapHelper.disableLightmapRendering();
        }
        GL11.glPopMatrix();
        Debug.change("post");
        this.mc.renderer.endRenderWorld(partialTick);
        if ((Integer)this.mc.gameSettings.thirdPersonView.value == 0 && this.mc.activeCamera instanceof EntityCamera && !((EntityCamera)this.mc.activeCamera).entity.isPlayerSleeping()) {
            this.itemRenderer.renderOverlays(partialTick);
            this.hurtCameraEffect(partialTick);
        }
        if (((Boolean)this.mc.gameSettings.viewBobbing.value).booleanValue()) {
            this.setupViewBobbing(partialTick);
        }
    }

    private float getZoomedFOV(float currentFov, float partialTick) {
        currentFov *= 0.45f;
        float prevZoomProgress = this.zoomProgress;
        this.zoomProgress -= (float)Mouse.getDWheel() / 256.0f;
        this.zoomProgress = MathHelper.clamp(this.zoomProgress, -7.5f, 7.5f);
        float maxFOV = 160.0f;
        float minFOV = 5.0f;
        float _zoom = prevZoomProgress + (this.zoomProgress - prevZoomProgress) * partialTick;
        if (this.zoomProgress > 0.0f) {
            return currentFov + 2.0f * (160.0f - currentFov) * (this.logisticFunc(_zoom) - 0.5f);
        }
        return 5.0f + 2.0f * (currentFov - 5.0f) * this.logisticFunc(_zoom);
    }

    private float logisticFunc(float val) {
        float L = 1.0f;
        float k = 1.1f;
        float xo = 0.0f;
        return (float)(1.0 / (1.0 + Math.pow(Math.E, -1.1f * (val - 0.0f))));
    }

    public void updateCameraAndRender(float partialTick) {
        this.lightmapHelper.update(partialTick);
        if (this.mc.inGameHasFocus) {
            if (Mouse.isGrabbed()) {
                float sensitivity = ((Float)this.mc.gameSettings.mouseSensitivity.value).floatValue() * 0.6f + 0.2f;
                sensitivity = sensitivity * sensitivity * sensitivity * 8.0f;
                if (this.zooming) {
                    sensitivity *= 0.25f;
                }
                float deltaX = (float)this.mc.mouseInput.deltaX * sensitivity;
                float deltaY = (float)this.mc.mouseInput.deltaY * sensitivity;
                int l = 1;
                if (((Boolean)this.mc.gameSettings.invertMouse.value).booleanValue()) {
                    l = -1;
                }
                if (((Boolean)this.mc.gameSettings.smoothCamera.value).booleanValue()) {
                    deltaX = this.mouseFilterXAxis.func_22386_a(deltaX, 0.05f * sensitivity);
                    deltaY = this.mouseFilterYAxis.func_22386_a(deltaY, 0.05f * sensitivity);
                } else {
                    this.mouseFilterXAxis.reset();
                    this.mouseFilterYAxis.reset();
                }
                this.mc.thePlayer.interpolateTurn(deltaX, deltaY * (float)l);
            }
            if (this.mc.controllerInput != null) {
                double speed = Time.delta * 2000.0 * (double)(((Float)this.mc.gameSettings.controllerSensitivity.value).floatValue() + 0.5f);
                if (this.zooming) {
                    speed *= 0.25;
                }
                double x = (double)this.mc.controllerInput.joyRight.getX() * speed;
                double y = (double)(-this.mc.controllerInput.joyRight.getY()) * speed;
                this.mc.thePlayer.interpolateTurn((float)x, (float)y);
            }
            if (!((Boolean)this.mc.gameSettings.showFrameTimes.value).booleanValue()) {
                PlayerInput playerInput = this.mc.thePlayer.input;
                float x = 0.0f;
                float y = 0.0f;
                playerInput.pressedLookUp = this.mc.gameSettings.keyLookUp.isPressed();
                playerInput.pressedLookDown = this.mc.gameSettings.keyLookDown.isPressed();
                playerInput.pressedLookLeft = this.mc.gameSettings.keyLookLeft.isPressed();
                playerInput.pressedLookRight = this.mc.gameSettings.keyLookRight.isPressed();
                if (playerInput.pressedLookUp) {
                    y += 1.0f;
                }
                if (playerInput.pressedLookDown) {
                    y -= 1.0f;
                }
                if (playerInput.pressedLookLeft) {
                    x -= 1.0f;
                }
                if (playerInput.pressedLookRight) {
                    x += 1.0f;
                }
                float sensitivity = (float)(Time.delta * 1000.0 * (double)(((Float)this.mc.gameSettings.mouseSensitivity.value).floatValue() + 0.5f));
                if (this.mc.thePlayer.isSneaking()) {
                    sensitivity *= 0.5f;
                }
                if (this.zooming) {
                    sensitivity *= 0.25f;
                }
                this.mc.thePlayer.interpolateTurn(x *= sensitivity, y *= sensitivity);
            }
        }
        if (this.mc.skipRenderWorld) {
            return;
        }
        int width = this.mc.resolution.scaledWidth;
        int height = this.mc.resolution.scaledHeight;
        int mouseX = Mouse.getX() * width / this.mc.resolution.width;
        int mouseY = height - Mouse.getY() * height / this.mc.resolution.height - 1;
        int c = 200;
        if (((Boolean)this.mc.gameSettings.enableVsync.value).booleanValue()) {
            if (this.mc.gameWindow instanceof GameWindowLWJGL2) {
                c = ((GameWindowLWJGL2)this.mc.gameWindow).defaultDisplayMode.getFrequency() + 20;
            }
        } else {
            c = (Integer)this.mc.gameSettings.customFpsLimit.value;
        }
        GL11.glViewport((int)0, (int)0, (int)this.mc.resolution.width, (int)this.mc.resolution.height);
        if (this.mc.theWorld != null) {
            Debug.change("world");
            if (!((Boolean)this.mc.gameSettings.enableVsync.value).booleanValue() && (Integer)this.mc.gameSettings.customFpsLimit.value == 0) {
                this.renderWorld(partialTick, 0L);
            } else {
                this.renderWorld(partialTick, this.systemTime + 1000000000L / (long)c);
            }
            Debug.change("misc");
            if (((Boolean)this.mc.gameSettings.enableVsync.value).booleanValue() || (Integer)this.mc.gameSettings.customFpsLimit.value > 0) {
                Debug.change("sleep");
                long l1 = (this.systemTime + 1000000000L / (long)c - System.nanoTime()) / 1000000L;
                if (l1 > 0L && l1 < 500L) {
                    try {
                        Thread.sleep(l1);
                    }
                    catch (InterruptedException interruptedexception) {
                        interruptedexception.printStackTrace();
                    }
                }
                Debug.change("misc");
            }
            this.systemTime = System.nanoTime();
            Debug.change("hud");
            this.mc.ingameGUI.renderGameOverlay(partialTick, this.mc.currentScreen != null, mouseX, mouseY);
            Debug.change("misc");
        } else {
            GL11.glMatrixMode((int)5889);
            GL11.glLoadIdentity();
            GL11.glMatrixMode((int)5888);
            GL11.glLoadIdentity();
            this.setupScaledResolution();
            if (((Boolean)this.mc.gameSettings.enableVsync.value).booleanValue() || (Integer)this.mc.gameSettings.customFpsLimit.value > 0) {
                Debug.change("sleep");
                long l2 = (this.systemTime + (long)(1000000000 / c) - System.nanoTime()) / 1000000L;
                if (l2 < 0L) {
                    l2 += 10L;
                }
                if (l2 > 0L && l2 < 500L) {
                    try {
                        Thread.sleep(l2);
                    }
                    catch (InterruptedException interruptedexception1) {
                        interruptedexception1.printStackTrace();
                    }
                }
                Debug.change("misc");
            }
            this.systemTime = System.nanoTime();
        }
        if (this.mc.currentScreen != null) {
            Debug.change("gui");
            GL11.glClear((int)256);
            if (this.mc.inputType == InputType.CONTROLLER) {
                mouseX = (int)this.mc.controllerInput.cursorX;
                mouseY = (int)this.mc.controllerInput.cursorY;
            }
            this.mc.currentScreen.drawScreen(mouseX, mouseY, partialTick);
            if (this.mc.inputType == InputType.CONTROLLER && this.mc.currentScreen != null) {
                this.mc.currentScreen.drawControllerCursor();
            }
            Debug.change("misc");
        }
    }

    public void renderWorld(float partialTick, long updateRenderersUntil) {
        long l1;
        Debug.push("misc");
        Colorizers.update(false);
        RenderGlobal renderGlobal = this.mc.renderGlobal;
        EffectRenderer effectRenderer = this.mc.effectRenderer;
        GL11.glEnable((int)2884);
        GL11.glEnable((int)2929);
        if (this.mc.activeCamera == null) {
            this.mc.activeCamera = new EntityCameraFirstPerson(this.mc, this.mc.thePlayer);
        }
        this.getMouseOver(partialTick);
        EntityLiving activeEntity = null;
        if (this.mc.activeCamera instanceof EntityCamera) {
            activeEntity = ((EntityCamera)this.mc.activeCamera).entity;
        }
        if (activeEntity != null) {
            double viewEntityX = activeEntity.xo + (activeEntity.x - activeEntity.xo) * (double)partialTick;
            double viewEntityZ = activeEntity.zo + (activeEntity.z - activeEntity.zo) * (double)partialTick;
            IChunkProvider iChunkProvider = this.mc.theWorld.getChunkProvider();
            if (iChunkProvider instanceof ChunkProviderStatic) {
                ChunkProviderStatic chunkProviderStatic = (ChunkProviderStatic)iChunkProvider;
                int chunkX = MathHelper.floor_float((int)viewEntityX) >> 4;
                int chunkZ = MathHelper.floor_float((int)viewEntityZ) >> 4;
                chunkProviderStatic.setCurrentChunkOver(chunkX, chunkZ);
            }
        }
        this.fogManager.updateFogColor(partialTick);
        Debug.change("post");
        this.mc.renderer.beginRenderWorld(partialTick);
        GL11.glClear((int)16640);
        GL11.glEnable((int)2884);
        this.setupCameraTransform(partialTick);
        Frustum.getFrustum();
        Debug.change("sky");
        if (((RenderDistance)((Object)this.mc.gameSettings.renderDistance.value)).renderSky && !(this.mc.currentScreen instanceof GuiModelViewer)) {
            this.fogManager.setupFog(-1, this.farPlaneDistance, partialTick);
            GL11.glDisable((int)2912);
            renderGlobal.drawSky(partialTick);
        }
        Debug.change("misc");
        GL11.glEnable((int)2912);
        this.fogManager.setupFog(0, this.farPlaneDistance, partialTick);
        if (((Boolean)this.mc.gameSettings.ambientOcclusion.value).booleanValue()) {
            GL11.glShadeModel((int)7425);
        }
        this.mc.renderGlobal.clipRenderersByFrustum(this.mc.activeCamera.getFrustum(), partialTick);
        Debug.change("aurora");
        if (((Boolean)this.mc.gameSettings.aurora.value).booleanValue() && this.mc.theWorld.getWorldType().hasAurora()) {
            renderGlobal.renderAurora(this.mc.activeCamera, partialTick);
        }
        Debug.change("update");
        while (!this.mc.renderGlobal.updateRenderers(this.mc.activeCamera) && updateRenderersUntil != 0L && (l1 = updateRenderersUntil - System.nanoTime()) >= 0L && l1 <= 1000000000L) {
        }
        this.fogManager.setupFog(0, this.farPlaneDistance, partialTick);
        GL11.glEnable((int)2912);
        TextureRegistry.blockAtlas.bindTexture();
        Lighting.disable();
        Debug.change("terrain");
        this.lightmapHelper.enableLightmapRendering();
        renderGlobal.sortAndRender(this.mc.activeCamera, 0, partialTick);
        Debug.change("entities");
        GL11.glShadeModel((int)7424);
        GL11.glBlendFunc((int)770, (int)771);
        Lighting.enableLight();
        if (!((Boolean)this.mc.gameSettings.fog.value).booleanValue()) {
            GL11.glDisable((int)2912);
        }
        renderGlobal.renderEntities(this.mc.activeCamera, partialTick);
        if (!((Boolean)this.mc.gameSettings.fog.value).booleanValue()) {
            GL11.glEnable((int)2912);
        }
        Debug.change("particles");
        effectRenderer.renderParticlesAtOrigin(partialTick);
        Lighting.disable();
        this.fogManager.setupFog(0, this.farPlaneDistance, partialTick);
        effectRenderer.renderParticles(this.mc.activeCamera, partialTick);
        this.lightmapHelper.disableLightmapRendering();
        Debug.change("outline");
        if (this.mc.objectMouseOver != null) {
            GL11.glDisable((int)3008);
            renderGlobal.drawBlockBreaking(this.mc.activeCamera, this.mc.objectMouseOver, partialTick);
            renderGlobal.drawSelectionBox(this.mc.activeCamera, this.mc.objectMouseOver, partialTick);
            GL11.glEnable((int)3008);
        }
        Debug.change("debugoverlays");
        if (((Boolean)this.mc.gameSettings.showCollisionBoxes.value).booleanValue()) {
            renderGlobal.drawDebugEntityOutlines(this.mc.activeCamera, partialTick);
        }
        if (((Boolean)this.mc.gameSettings.showChunkBorders.value).booleanValue()) {
            renderGlobal.drawDebugChunkBorders(this.mc.activeCamera, partialTick);
        }
        GL11.glBlendFunc((int)770, (int)771);
        this.fogManager.setupFog(0, this.farPlaneDistance, partialTick);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)2884);
        TextureRegistry.blockAtlas.bindTexture();
        Debug.change("water");
        if (((Boolean)this.mc.gameSettings.ambientOcclusion.value).booleanValue()) {
            GL11.glShadeModel((int)7425);
        }
        if ((Integer)this.mc.gameSettings.fancyGraphics.value == 1) {
            GL11.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
            int i1 = renderGlobal.sortAndRender(this.mc.activeCamera, 1, partialTick);
            GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            if (i1 > 0) {
                this.lightmapHelper.enableLightmapRendering();
                if (!((Boolean)this.mc.gameSettings.fog.value).booleanValue()) {
                    GL11.glDisable((int)2912);
                }
                renderGlobal.callAllDisplayLists(1, partialTick);
                if (!((Boolean)this.mc.gameSettings.fog.value).booleanValue()) {
                    GL11.glEnable((int)2912);
                }
                this.lightmapHelper.disableLightmapRendering();
            }
        } else {
            this.lightmapHelper.enableLightmapRendering();
            renderGlobal.sortAndRender(this.mc.activeCamera, 1, partialTick);
            this.lightmapHelper.disableLightmapRendering();
        }
        GL11.glShadeModel((int)7424);
        Debug.change("weather");
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2884);
        GL11.glDisable((int)3042);
        this.renderRainSnow(partialTick);
        GL11.glDisable((int)2912);
        if (((Boolean)this.mc.gameSettings.clouds.value).booleanValue()) {
            Debug.change("clouds");
            this.fogManager.setupFog(0, this.farPlaneDistance, partialTick);
            GL11.glEnable((int)2912);
            renderGlobal.renderClouds(partialTick);
            GL11.glDisable((int)2912);
        }
        Debug.change("misc");
        this.fogManager.setupFog(1, this.farPlaneDistance, partialTick);
        this.renderHand(partialTick);
        GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        Debug.pop();
    }

    private void addRainParticles() {
        Weather weather = this.mc.theWorld.getCurrentWeather();
        if (weather == null || !weather.spawnRainParticles) {
            return;
        }
        float f = this.mc.theWorld.weatherManager.getWeatherIntensity() * this.mc.theWorld.weatherManager.getWeatherPower();
        if ((Integer)this.mc.gameSettings.fancyGraphics.value != 1) {
            f /= 2.0f;
        }
        if (f == 0.0f) {
            return;
        }
        this.random.setSeed((long)this.rendererUpdateCount * 312987231L);
        World world = this.mc.theWorld;
        int cameraX = MathHelper.floor_double(this.mc.activeCamera.getX());
        int cameraY = MathHelper.floor_double(this.mc.activeCamera.getY());
        int cameraZ = MathHelper.floor_double(this.mc.activeCamera.getZ());
        int byte0 = 10;
        double d = 0.0;
        double d1 = 0.0;
        double d2 = 0.0;
        int l = 0;
        block0: for (int i1 = 0; i1 < (int)(100.0f * f * f); ++i1) {
            int randX = cameraX + this.random.nextInt(byte0) - this.random.nextInt(byte0);
            int randZ = cameraZ + this.random.nextInt(byte0) - this.random.nextInt(byte0);
            int y = world.findTopSolidBlock(randX, randZ);
            int i2 = world.getBlockId(randX, y - 1, randZ);
            Biome biome = world.getBlockBiome(randX, y, randZ);
            for (int q = 0; q < biome.blockedWeathers.length; ++q) {
                if (biome.blockedWeathers[q] == weather) continue block0;
            }
            if (y > cameraY + byte0 || y < cameraY - byte0) continue;
            float f1 = this.random.nextFloat();
            float f2 = this.random.nextFloat();
            if (i2 <= 0) continue;
            if (Block.blocksList[i2].blockMaterial == Material.lava) {
                this.mc.effectRenderer.addEffect(new EntitySmokeFX(world, (float)randX + f1, (double)((float)y + 0.1f) - Block.blocksList[i2].minY, (float)randZ + f2, 0.0, 0.0, 0.0));
                continue;
            }
            if (this.random.nextInt(++l) == 0) {
                d = (float)randX + f1;
                d1 = (double)((float)y + 0.1f) - Block.blocksList[i2].minY;
                d2 = (float)randZ + f2;
            }
            this.mc.effectRenderer.addEffect(new EntityRainFX(world, (float)randX + f1, (double)((float)y + 0.1f) - Block.blocksList[i2].minY, (float)randZ + f2));
        }
        if (l > 0 && this.random.nextInt(3) < this.rainSoundCounter++) {
            this.rainSoundCounter = 0;
            if (d1 > this.mc.activeCamera.getY() + 1.0 && world.getHeightValue(MathHelper.floor_double(this.mc.activeCamera.getX()), MathHelper.floor_double(this.mc.activeCamera.getZ())) > MathHelper.floor_double(this.mc.activeCamera.getY())) {
                this.mc.theWorld.playSoundEffect(null, SoundCategory.WEATHER_SOUNDS, d, d1, d2, "ambient.weather.rain", 0.1f * this.mc.theWorld.weatherManager.getWeatherIntensity() * this.mc.theWorld.weatherManager.getWeatherPower() * 0.5f, 0.5f);
            } else {
                this.mc.theWorld.playSoundEffect(null, SoundCategory.WEATHER_SOUNDS, d, d1, d2, "ambient.weather.rain", 0.2f * this.mc.theWorld.weatherManager.getWeatherIntensity() * this.mc.theWorld.weatherManager.getWeatherPower() * 0.5f, 1.0f);
            }
        }
    }

    protected void renderRainSnow(float partialTick) {
        Weather weather = this.mc.theWorld.getCurrentWeather();
        if (weather == null || !weather.isPrecipitation) {
            return;
        }
        World world = this.mc.theWorld;
        int posX = MathHelper.floor_double(this.mc.activeCamera.getX());
        int posY = MathHelper.floor_double(this.mc.activeCamera.getY());
        int posZ = MathHelper.floor_double(this.mc.activeCamera.getZ());
        Tessellator tessellator = Tessellator.instance;
        GL11.glDisable((int)2884);
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glAlphaFunc((int)516, (float)0.01f);
        GL11.glBindTexture((int)3553, (int)this.mc.renderEngine.getTexture(weather.texturePath));
        double nextPosX = this.mc.activeCamera.getX(partialTick);
        double nextPosY = this.mc.activeCamera.getY(partialTick);
        double nextPosZ = this.mc.activeCamera.getZ(partialTick);
        int floorPosY = MathHelper.floor_double(nextPosY);
        int radiusEffect = 10;
        if (weather.precipitationType == 1) {
            for (int x = posX - radiusEffect; x <= posX + radiusEffect; ++x) {
                block1: for (int z = posZ - radiusEffect; z <= posZ + radiusEffect; ++z) {
                    int i3;
                    int y = world.findTopSolidBlock(x, z);
                    Biome biomegenbase = world.getBlockBiome(x, y, z);
                    for (int q = 0; q < biomegenbase.blockedWeathers.length; ++q) {
                        if (biomegenbase.blockedWeathers[q] == weather) continue block1;
                    }
                    if (y < 0) {
                        y = 0;
                    }
                    if ((i3 = y) < floorPosY) {
                        i3 = floorPosY;
                    }
                    int k3 = posY - radiusEffect;
                    int i4 = posY + radiusEffect;
                    if (k3 < y) {
                        k3 = y;
                    }
                    if (i4 < y) {
                        i4 = y;
                    }
                    float f3 = 1.0f;
                    if (k3 == i4) continue;
                    this.random.setSeed(x * x * 3121 + x * 45238971 + z * z * 418711 + z * 13761);
                    float f5 = (float)this.rendererUpdateCount + partialTick;
                    float f6 = ((float)(this.rendererUpdateCount & 0x1FF) + partialTick) / 512.0f;
                    float f7 = this.random.nextFloat() + f5 * 0.01f * (float)this.random.nextGaussian();
                    float f8 = this.random.nextFloat() + f5 * (float)this.random.nextGaussian() * 0.001f;
                    double d5 = (double)((float)x + 0.5f) - this.mc.activeCamera.getX();
                    double d6 = (double)((float)z + 0.5f) - this.mc.activeCamera.getZ();
                    float f11 = MathHelper.sqrt_double(d5 * d5 + d6 * d6) / (float)radiusEffect;
                    tessellator.startDrawingQuads();
                    float f12 = world.getLightBrightness(x, i3, z);
                    if (this.mc.fullbright) {
                        f12 = 1.0f;
                    }
                    GL11.glColor4f((float)f12, (float)f12, (float)f12, (float)(((1.0f - f11 * f11) * 0.3f + 0.5f) * world.weatherManager.getWeatherIntensity() * world.weatherManager.getWeatherPower()));
                    tessellator.setTranslation(-nextPosX * 1.0, -nextPosY * 1.0, -nextPosZ * 1.0);
                    tessellator.addVertexWithUV(x + 0, k3, (double)z + 0.5, 0.0f * f3 + f7, (float)k3 * f3 / 4.0f + f6 * f3 + f8);
                    tessellator.addVertexWithUV(x + 1, k3, (double)z + 0.5, 1.0f * f3 + f7, (float)k3 * f3 / 4.0f + f6 * f3 + f8);
                    tessellator.addVertexWithUV(x + 1, i4, (double)z + 0.5, 1.0f * f3 + f7, (float)i4 * f3 / 4.0f + f6 * f3 + f8);
                    tessellator.addVertexWithUV(x + 0, i4, (double)z + 0.5, 0.0f * f3 + f7, (float)i4 * f3 / 4.0f + f6 * f3 + f8);
                    tessellator.addVertexWithUV((double)x + 0.5, k3, z + 0, 0.0f * f3 + f7, (float)k3 * f3 / 4.0f + f6 * f3 + f8);
                    tessellator.addVertexWithUV((double)x + 0.5, k3, z + 1, 1.0f * f3 + f7, (float)k3 * f3 / 4.0f + f6 * f3 + f8);
                    tessellator.addVertexWithUV((double)x + 0.5, i4, z + 1, 1.0f * f3 + f7, (float)i4 * f3 / 4.0f + f6 * f3 + f8);
                    tessellator.addVertexWithUV((double)x + 0.5, i4, z + 0, 0.0f * f3 + f7, (float)i4 * f3 / 4.0f + f6 * f3 + f8);
                    tessellator.setTranslation(0.0, 0.0, 0.0);
                    tessellator.draw();
                }
            }
        } else if (weather.precipitationType == 0) {
            for (int x = posX - radiusEffect; x <= posX + radiusEffect; ++x) {
                block4: for (int z = posZ - radiusEffect; z <= posZ + radiusEffect; ++z) {
                    int y = world.findTopSolidBlock(x, z);
                    Biome biomegenbase1 = world.getBlockBiome(x, y, z);
                    for (int q = 0; q < biomegenbase1.blockedWeathers.length; ++q) {
                        if (biomegenbase1.blockedWeathers[q] == weather) continue block4;
                    }
                    int j3 = posY - radiusEffect;
                    int l3 = posY + radiusEffect;
                    if (j3 < y) {
                        j3 = y;
                    }
                    if (l3 < y) {
                        l3 = y;
                    }
                    float f2 = 1.0f;
                    if (j3 == l3) continue;
                    this.random.setSeed(x * x * 3121 + x * 45238971 + z * z * 418711 + z * 13761);
                    float f4 = ((float)(this.rendererUpdateCount + x * x * 3121 + x * 45238971 + z * z * 418711 + z * 13761 & 0x1F) + partialTick) / 32.0f * (3.0f + this.random.nextFloat());
                    double d3 = (double)((float)x + 0.5f) - this.mc.activeCamera.getX();
                    double d4 = (double)((float)z + 0.5f) - this.mc.activeCamera.getZ();
                    float f9 = MathHelper.sqrt_double(d3 * d3 + d4 * d4) / (float)radiusEffect;
                    tessellator.startDrawingQuads();
                    float f10 = world.getLightBrightness(x, world.getHeightBlocks(), z) * 0.85f + 0.15f;
                    if (this.mc.fullbright) {
                        f10 = 1.0f;
                    }
                    GL11.glColor4f((float)f10, (float)f10, (float)f10, (float)(((1.0f - f9 * f9) * 0.5f + 0.5f) * (world.weatherManager.getWeatherIntensity() - 0.1f) * world.weatherManager.getWeatherPower()));
                    tessellator.setTranslation(-nextPosX * 1.0, -nextPosY * 1.0, -nextPosZ * 1.0);
                    tessellator.addVertexWithUV(x + 0, j3, (double)z + 0.5, 0.0f * f2, (float)j3 * f2 / 4.0f + f4 * f2);
                    tessellator.addVertexWithUV(x + 1, j3, (double)z + 0.5, 1.0f * f2, (float)j3 * f2 / 4.0f + f4 * f2);
                    tessellator.addVertexWithUV(x + 1, l3, (double)z + 0.5, 1.0f * f2, (float)l3 * f2 / 4.0f + f4 * f2);
                    tessellator.addVertexWithUV(x + 0, l3, (double)z + 0.5, 0.0f * f2, (float)l3 * f2 / 4.0f + f4 * f2);
                    tessellator.addVertexWithUV((double)x + 0.5, j3, z + 0, 0.0f * f2, (float)j3 * f2 / 4.0f + f4 * f2);
                    tessellator.addVertexWithUV((double)x + 0.5, j3, z + 1, 1.0f * f2, (float)j3 * f2 / 4.0f + f4 * f2);
                    tessellator.addVertexWithUV((double)x + 0.5, l3, z + 1, 1.0f * f2, (float)l3 * f2 / 4.0f + f4 * f2);
                    tessellator.addVertexWithUV((double)x + 0.5, l3, z + 0, 0.0f * f2, (float)l3 * f2 / 4.0f + f4 * f2);
                    tessellator.setTranslation(0.0, 0.0, 0.0);
                    tessellator.draw();
                }
            }
        } else if (weather.precipitationType == 2) {
            for (int x = posX - radiusEffect; x <= posX + radiusEffect; ++x) {
                block7: for (int z = posZ - radiusEffect; z <= posZ + radiusEffect; ++z) {
                    int topSolidY = world.findTopSolidBlock(x, z);
                    Biome biome = world.getBlockBiome(x, topSolidY, z);
                    for (int i = 0; i < biome.blockedWeathers.length; ++i) {
                        if (biome.blockedWeathers[i] == weather) continue block7;
                    }
                    int j3 = posY - radiusEffect;
                    int l3 = posY + radiusEffect;
                    if (j3 < topSolidY) {
                        j3 = topSolidY;
                    }
                    if (l3 < topSolidY) {
                        l3 = topSolidY;
                    }
                    float f2 = 1.0f;
                    if (j3 == l3) continue;
                    this.random.setSeed(x * x * 3121 + x * 45238971 + z * z * 418711 + z * 13761);
                    float vOffset = ((float)(this.rendererUpdateCount + x * x * 3121 + x * 45238971 + z * z * 418711 + z * 13761 & 0x1F) + partialTick) / 32.0f * (3.0f + this.random.nextFloat());
                    double d3 = (double)((float)x + 0.5f) - this.mc.activeCamera.getX();
                    double d4 = (double)((float)z + 0.5f) - this.mc.activeCamera.getZ();
                    float f9 = MathHelper.sqrt_double(d3 * d3 + d4 * d4) / (float)radiusEffect;
                    tessellator.startDrawingQuads();
                    float f10 = world.getLightBrightness(x, world.getHeightBlocks(), z) * 0.85f + 0.15f;
                    if (this.mc.fullbright) {
                        f10 = 1.0f;
                    }
                    GL11.glColor4f((float)f10, (float)f10, (float)f10, (float)(((1.0f - f9 * f9) * 0.5f + 0.5f) * (world.weatherManager.getWeatherIntensity() - 0.1f) * world.weatherManager.getWeatherPower()));
                    tessellator.setTranslation(-nextPosX * 1.0, -nextPosY * 1.0, -nextPosZ * 1.0);
                    tessellator.addVertexWithUV(x + 0, j3, (double)z + 0.5, 0.0f * f2, (float)j3 * f2 / 4.0f - vOffset * f2);
                    tessellator.addVertexWithUV(x + 1, j3, (double)z + 0.5, 1.0f * f2, (float)j3 * f2 / 4.0f - vOffset * f2);
                    tessellator.addVertexWithUV(x + 1, l3, (double)z + 0.5, 1.0f * f2, (float)l3 * f2 / 4.0f - vOffset * f2);
                    tessellator.addVertexWithUV(x + 0, l3, (double)z + 0.5, 0.0f * f2, (float)l3 * f2 / 4.0f - vOffset * f2);
                    tessellator.addVertexWithUV((double)x + 0.5, j3, z + 0, 0.0f * f2, (float)j3 * f2 / 4.0f - vOffset * f2);
                    tessellator.addVertexWithUV((double)x + 0.5, j3, z + 1, 1.0f * f2, (float)j3 * f2 / 4.0f - vOffset * f2);
                    tessellator.addVertexWithUV((double)x + 0.5, l3, z + 1, 1.0f * f2, (float)l3 * f2 / 4.0f - vOffset * f2);
                    tessellator.addVertexWithUV((double)x + 0.5, l3, z + 0, 0.0f * f2, (float)l3 * f2 / 4.0f - vOffset * f2);
                    tessellator.setTranslation(0.0, 0.0, 0.0);
                    tessellator.draw();
                }
            }
        }
        GL11.glEnable((int)2884);
        GL11.glDisable((int)3042);
        GL11.glAlphaFunc((int)516, (float)0.1f);
    }

    public void setupScaledResolution() {
        GL11.glClear((int)256);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)this.mc.resolution.scaledWidthExact, (double)this.mc.resolution.scaledHeightExact, (double)0.0, (double)1000.0, (double)3000.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-2000.0f);
    }
}

