/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.block.color.BlockColor;
import net.minecraft.client.render.block.color.BlockColorDispatcher;
import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.stitcher.IconCoordinate;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.core.block.Block;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.WorldSource;

public class BlockModelAlgae<T extends Block>
extends BlockModelStandard<T> {
    public BlockModelAlgae(Block block) {
        super(block);
    }

    @Override
    public boolean render(Tessellator tessellator, int x, int y, int z) {
        this.block.setBlockBoundsBasedOnState(BlockModelAlgae.renderBlocks.blockAccess, x, y, z);
        float brightness = 1.0f;
        if (!LightmapHelper.isLightmapEnabled()) {
            brightness = this.getBlockBrightness(BlockModelAlgae.renderBlocks.blockAccess, x, y, z);
        } else {
            tessellator.setLightmapCoord(this.block.getLightmapCoord(BlockModelAlgae.renderBlocks.blockAccess, x, y, z));
        }
        int color = ((BlockColor)BlockColorDispatcher.getInstance().getDispatch(this.block)).getWorldColor(BlockModelAlgae.renderBlocks.blockAccess, x, y, z);
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        tessellator.setColorOpaque_F(red * brightness, green * brightness, blue * brightness);
        IconCoordinate tex = this.getBlockTextureFromSideAndMetadata(Side.TOP, BlockModelAlgae.renderBlocks.blockAccess.getBlockMetadata(x, y, z));
        this.renderTopFace(tessellator, this.block, x, (double)y - 0.1125, z, tex);
        this.renderBottomFace(tessellator, this.block, x, (double)y + 0.0125, z, tex);
        return true;
    }

    @Override
    public boolean shouldItemRender3d() {
        return false;
    }

    @Override
    public boolean shouldSideBeRendered(WorldSource blockAccess, int x, int y, int z, int side) {
        if (side == 1) {
            return true;
        }
        return super.shouldSideBeRendered(blockAccess, x, y, z, side);
    }
}

