/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.stitcher.IconCoordinate;
import net.minecraft.client.render.stitcher.TextureRegistry;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockBed;
import net.minecraft.core.block.logic.BedDirections;
import net.minecraft.core.util.helper.Side;

public class BlockModelBed<T extends Block>
extends BlockModelStandard<T> {
    protected IconCoordinate underTexture = TextureRegistry.getTexture("minecraft:block/planks_oak");

    public BlockModelBed(Block block) {
        super(block);
        this.atlasIndices[0] = TextureRegistry.getTexture("minecraft:block/bed_foot_front");
        this.atlasIndices[1] = TextureRegistry.getTexture("minecraft:block/bed_foot_side");
        this.atlasIndices[2] = TextureRegistry.getTexture("minecraft:block/bed_foot_top");
        this.atlasIndices[3] = TextureRegistry.getTexture("minecraft:block/bed_head_front");
        this.atlasIndices[4] = TextureRegistry.getTexture("minecraft:block/bed_head_side");
        this.atlasIndices[5] = TextureRegistry.getTexture("minecraft:block/bed_head_top");
    }

    @Override
    public boolean render(Tessellator tessellator, int x, int y, int z) {
        int f17;
        this.block.setBlockBoundsBasedOnState(BlockModelBed.renderBlocks.blockAccess, x, y, z);
        BlockModelBed.renderBlocks.enableAO = true;
        BlockModelBed.renderBlocks.cache.setupCache(this.block, BlockModelBed.renderBlocks.blockAccess, x, y, z);
        int meta = BlockModelBed.renderBlocks.blockAccess.getBlockMetadata(x, y, z);
        int direction = BlockBed.getDirectionFromMetadata(meta);
        boolean isFootOfBed = BlockBed.isBlockFootOfBed(meta);
        double minY = this.block.minY;
        this.block.minY += 0.1875;
        this.renderSide(tessellator, this.block, x, y, z, 1.0f, 1.0f, 1.0f, Side.BOTTOM, meta);
        this.block.minY = minY;
        if (direction == 0) {
            BlockModelBed.renderBlocks.uvRotateTop = 1;
        } else if (direction == 2) {
            BlockModelBed.renderBlocks.uvRotateTop = 2;
        } else if (direction == 1) {
            BlockModelBed.renderBlocks.uvRotateTop = 3;
        }
        this.renderSide(tessellator, this.block, x, y, z, Side.TOP, meta);
        BlockModelBed.renderBlocks.uvRotateTop = 0;
        int n = f17 = isFootOfBed ? BedDirections.headOfBedMap[BedDirections.footToHeadMap[direction]] : BedDirections.headOfBedMap[direction];
        if (f17 != 2 && (BlockModelBed.renderBlocks.renderAllFaces || this.shouldSideBeRendered(BlockModelBed.renderBlocks.blockAccess, x, y, z - 1, 2))) {
            BlockModelBed.renderBlocks.flipTexture = direction == 3;
            this.renderSide(tessellator, this.block, x, y, z, Side.NORTH, meta);
        }
        if (f17 != 3 && (BlockModelBed.renderBlocks.renderAllFaces || this.shouldSideBeRendered(BlockModelBed.renderBlocks.blockAccess, x, y, z + 1, 3))) {
            BlockModelBed.renderBlocks.flipTexture = direction == 1;
            this.renderSide(tessellator, this.block, x, y, z, Side.SOUTH, meta);
        }
        if (f17 != 4 && (BlockModelBed.renderBlocks.renderAllFaces || this.shouldSideBeRendered(BlockModelBed.renderBlocks.blockAccess, x - 1, y, z, 4))) {
            BlockModelBed.renderBlocks.flipTexture = direction == 2;
            this.renderSide(tessellator, this.block, x, y, z, Side.WEST, meta);
        }
        if (f17 != 5 && (BlockModelBed.renderBlocks.renderAllFaces || this.shouldSideBeRendered(BlockModelBed.renderBlocks.blockAccess, x + 1, y, z, 5))) {
            BlockModelBed.renderBlocks.flipTexture = direction == 0;
            this.renderSide(tessellator, this.block, x, y, z, Side.EAST, meta);
        }
        this.resetRenderBlocks();
        return true;
    }

    @Override
    public boolean shouldItemRender3d() {
        return false;
    }

    @Override
    public IconCoordinate getBlockTextureFromSideAndMetadata(Side side, int data) {
        if (side == Side.BOTTOM) {
            return this.underTexture;
        }
        int k = BlockBed.getDirectionFromMetadata(data);
        int l = BedDirections.bedDirection[k][side.getId()];
        if (BlockBed.isBlockFootOfBed(data)) {
            if (l == 2) {
                return this.atlasIndices[3];
            }
            if (l == 5 || l == 4) {
                return this.atlasIndices[4];
            }
            return this.atlasIndices[5];
        }
        if (l == 3) {
            return this.atlasIndices[0];
        }
        if (l == 5 || l == 4) {
            return this.atlasIndices[1];
        }
        return this.atlasIndices[2];
    }
}

