/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.sound;

import java.lang.reflect.Field;
import java.util.HashMap;
import net.minecraft.client.option.GameSettings;
import net.minecraft.client.option.VolumeOption;
import net.minecraft.core.sound.SoundCategory;

public class SoundCategoryHelper {
    private static final HashMap<SoundCategory, Field> VOLUME_FIELDS = new HashMap();

    public static boolean isAnyEnabled(GameSettings gameSettings) {
        for (SoundCategory category : SoundCategory.values()) {
            if (!(SoundCategoryHelper.getEffectiveVolume(category, gameSettings) > 0.0f)) continue;
            return true;
        }
        return false;
    }

    public static float getVolume(SoundCategory category, GameSettings gameSettings) {
        Field field = VOLUME_FIELDS.get((Object)category);
        if (field == null) {
            return 0.0f;
        }
        try {
            return ((Float)((VolumeOption)field.get((Object)gameSettings)).value).floatValue();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0.0f;
        }
    }

    public static float getEffectiveVolume(SoundCategory category, GameSettings gameSettings) {
        Field field = VOLUME_FIELDS.get((Object)category);
        if (field == null) {
            return 0.0f;
        }
        try {
            float value = ((Float)((VolumeOption)field.get((Object)gameSettings)).value).floatValue();
            return value * ((Float)gameSettings.masterVolume.value).floatValue();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0.0f;
        }
    }

    public static void setVolume(SoundCategory category, GameSettings gameSettings, float value) {
        Field field = VOLUME_FIELDS.get((Object)category);
        if (field == null) {
            return;
        }
        try {
            VolumeOption option = (VolumeOption)field.get(gameSettings);
            option.value = Float.valueOf(value);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        try {
            VOLUME_FIELDS.put(SoundCategory.MUSIC, GameSettings.class.getDeclaredField("musicVolume"));
            VOLUME_FIELDS.put(SoundCategory.WORLD_SOUNDS, GameSettings.class.getDeclaredField("worldSoundsVolume"));
            VOLUME_FIELDS.put(SoundCategory.WEATHER_SOUNDS, GameSettings.class.getDeclaredField("weatherSoundsVolume"));
            VOLUME_FIELDS.put(SoundCategory.ENTITY_SOUNDS, GameSettings.class.getDeclaredField("entitySoundsVolume"));
            VOLUME_FIELDS.put(SoundCategory.CAVE_SOUNDS, GameSettings.class.getDeclaredField("caveSoundsVolume"));
            VOLUME_FIELDS.put(SoundCategory.GUI_SOUNDS, GameSettings.class.getDeclaredField("guiSoundsVolume"));
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }
}

