/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.EntityLiving;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.tag.ItemTags;
import net.minecraft.core.sound.SoundCategory;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;

public class BlockFenceGate
extends Block {
    public BlockFenceGate(String key, int id) {
        super(key, id, Material.wood);
    }

    @Override
    public AABB getCollisionBoundingBoxFromPool(WorldSource world, int x, int y, int z) {
        int l = world.getBlockMetadata(x, y, z);
        if (BlockFenceGate.func_35291_d(l)) {
            return null;
        }
        return this.getAABBFromMeta(l).expand(0.0, 0.25, 0.0).offset(x, (float)y + 0.25f, z);
    }

    private AABB getAABBFromMeta(int meta) {
        if (BlockFenceGate.func_35290_f(meta) == 3 || BlockFenceGate.func_35290_f(meta) == 1) {
            return AABB.getBoundingBoxFromPool(0.375, 0.0, 0.0, 0.625, 1.0, 1.0);
        }
        return AABB.getBoundingBoxFromPool(0.0, 0.0, 0.375, 1.0, 1.0, 0.625);
    }

    @Override
    public AABB getSelectedBoundingBoxFromPool(WorldSource world, int x, int y, int z) {
        return this.getAABBFromMeta(world.getBlockMetadata(x, y, z)).offset(x, y, z);
    }

    @Override
    public void setBlockBoundsBasedOnState(WorldSource world, int x, int y, int z) {
        AABB aabb = this.getAABBFromMeta(world.getBlockMetadata(x, y, z));
        this.minX = aabb.minX;
        this.minY = aabb.minY;
        this.minZ = aabb.minZ;
        this.maxX = aabb.maxX;
        this.maxY = aabb.maxY;
        this.maxZ = aabb.maxZ;
    }

    @Override
    public boolean isSolidRender() {
        return false;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public void onBlockPlaced(World world, int x, int y, int z, Side side, EntityLiving entity, double sideHeight) {
        int directionmeta = entity.getHorizontalPlacementDirection(side).getHorizontalIndex();
        int colormeta = world.getBlockMetadata(x, y, z);
        world.setBlockMetadataWithNotify(x, y, z, directionmeta | colormeta & 0xF0);
    }

    @Override
    public void onBlockClicked(World world, int x, int y, int z, EntityPlayer player) {
        if (!Item.hasTag(player.getCurrentEquippedItem(), ItemTags.PREVENT_LEFT_CLICK_INTERACTIONS)) {
            this.blockActivated(world, x, y, z, player);
        }
    }

    @Override
    public boolean blockActivated(World world, int x, int y, int z, EntityPlayer player) {
        int l = world.getBlockMetadata(x, y, z);
        if (BlockFenceGate.func_35291_d(l)) {
            world.setBlockMetadataWithNotify(x, y, z, l & 0xFFFFFFFB);
        } else {
            int i1 = (MathHelper.floor_double((double)(player.yRot * 4.0f / 360.0f) + 0.5) & 3) % 4;
            int j1 = BlockFenceGate.func_35290_f(l);
            if (j1 == (i1 + 2) % 4) {
                l = l & 0xF0 | i1;
            }
            world.setBlockMetadataWithNotify(x, y, z, l | 4);
        }
        if (Math.random() < 0.5) {
            world.playSoundEffect(player, SoundCategory.WORLD_SOUNDS, x, y, z, "random.door_open", 1.0f, 1.0f);
        } else {
            world.playSoundEffect(player, SoundCategory.WORLD_SOUNDS, x, y, z, "random.door_close", 1.0f, 1.0f);
        }
        return true;
    }

    public static boolean func_35291_d(int i) {
        return (i & 4) != 0;
    }

    public static int func_35290_f(int i) {
        return i & 3;
    }
}

