/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.item;

import java.util.Random;
import net.minecraft.core.HitResult;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityDispatcher;
import net.minecraft.core.entity.EntityLiving;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.item.IDispensable;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.player.gamemode.Gamemode;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.phys.Vec3d;
import net.minecraft.core.world.World;
import net.minecraft.server.entity.player.EntityPlayerMP;

public class ItemWandSpawner
extends Item
implements IDispensable {
    public ItemWandSpawner(String name, int id) {
        super(name, id);
    }

    @Override
    public ItemStack onItemRightClick(ItemStack itemstack, World world, EntityPlayer player) {
        if (player.gamemode != Gamemode.creative) {
            player.sendTranslatedChatMessage("wand.wrongmode");
            return itemstack;
        }
        if (!player.isSneaking()) {
            float f = 1.0f;
            float f1 = player.xRotO + (player.xRot - player.xRotO) * f;
            float f2 = player.yRotO + (player.yRot - player.yRotO) * f;
            double posX = player.xo + (player.x - player.xo) * (double)f;
            float yOff = player instanceof EntityPlayerMP ? player.getHeightOffset() : 0.0f;
            double posY = player.yo + (player.y - player.yo) + (double)yOff;
            double posZ = player.zo + (player.z - player.zo) * (double)f;
            Vec3d vec3d = Vec3d.createVector(posX, posY, posZ);
            float f3 = MathHelper.cos(-f2 * 0.01745329f - (float)Math.PI);
            float f4 = MathHelper.sin(-f2 * 0.01745329f - (float)Math.PI);
            float f5 = -MathHelper.cos(-f1 * 0.01745329f);
            float f6 = MathHelper.sin(-f1 * 0.01745329f);
            float f7 = f4 * f5;
            float f8 = f6;
            float f9 = f3 * f5;
            double reachDistance = player.getGamemode().getBlockReachDistance();
            Vec3d vec3d1 = vec3d.addVector((double)f7 * reachDistance, (double)f8 * reachDistance, (double)f9 * reachDistance);
            HitResult rayTraceResult = world.checkBlockCollisionBetweenPoints(vec3d, vec3d1, false);
            if (rayTraceResult != null) {
                if (!world.isClientSide) {
                    this.spawnEntity(itemstack, world, rayTraceResult.location.xCoord, rayTraceResult.location.yCoord, rayTraceResult.location.zCoord);
                }
                return itemstack;
            }
        }
        player.displayGUIWandMonsterPicker(itemstack);
        return itemstack;
    }

    private String getEntityId(ItemStack itemStack) {
        String id = itemStack.getData().getString("monster");
        if (id == null || id.isEmpty()) {
            id = "Pig";
        }
        return id;
    }

    public void spawnEntity(ItemStack itemStack, World world, double x, double y, double z) {
        Entity entity = EntityDispatcher.createEntityInWorld(this.getEntityId(itemStack), world);
        if (entity != null) {
            entity.setPos(x, y, z);
            entity.spawnInit();
            if (itemStack.hasCustomName() && entity instanceof EntityLiving) {
                ((EntityLiving)entity).setNickname(itemStack.getCustomName());
            }
            world.entityJoinedWorld(entity);
        }
    }

    @Override
    public void onDispensed(ItemStack itemStack, World world, double x, double y, double z, int xOffset, int zOffset, Random random) {
        this.spawnEntity(itemStack, world, x + (double)xOffset * 0.5, y, z + (double)zOffset * 0.5);
    }

    @Override
    public boolean isRemovedOnDispense() {
        return false;
    }
}

