/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.command.commands;

import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.net.command.Command;
import net.minecraft.core.net.command.CommandError;
import net.minecraft.core.net.command.CommandHandler;
import net.minecraft.core.net.command.CommandSender;
import net.minecraft.core.net.command.PlayerCommandSender;
import net.minecraft.core.world.World;
import net.minecraft.core.world.chunk.ChunkCoordinates;
import net.minecraft.server.entity.player.EntityPlayerMP;

public class SpawnCommand
extends Command {
    public SpawnCommand() {
        super("spawn", new String[0]);
    }

    @Override
    public boolean execute(CommandHandler handler, CommandSender sender, String[] args) {
        if (sender instanceof PlayerCommandSender) {
            EntityPlayer player = sender.getPlayer();
            World world = handler.getWorld(player);
            ChunkCoordinates pos = world.getSpawnPoint();
            sender.sendMessage("Teleporting to spawn...");
            if (player instanceof EntityPlayerMP) {
                EntityPlayerMP playerMP = (EntityPlayerMP)player;
                if (playerMP.dimension != 0) {
                    playerMP.mcServer.playerList.sendPlayerToOtherDimension(playerMP, 0);
                }
                playerMP.playerNetServerHandler.teleportAndRotate((double)pos.x + 0.5, (double)pos.y + 0.5, (double)pos.z + 0.5, 0.0f, 0.0f);
            }
            player.absMoveTo((double)pos.x + 0.5, (double)pos.y + 0.5, (double)pos.z + 0.5, 0.0f, 0.0f);
            return true;
        }
        throw new CommandError("Must be used by a player!");
    }

    @Override
    public boolean opRequired(String[] args) {
        return true;
    }

    @Override
    public void sendCommandSyntax(CommandHandler handler, CommandSender sender) {
        sender.sendMessage("/spawn");
    }
}

