/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.util.collection;

import java.util.Comparator;

public final class NamespaceID
implements Comparator<NamespaceID> {
    public final String namespace;
    public final String value;

    public NamespaceID(String namespace, String value) {
        if (namespace.contains(":")) {
            throw new IllegalArgumentException(namespace + " cannot contain the ':' character!");
        }
        if (value.contains(":")) {
            throw new IllegalArgumentException(value + " cannot contain the ':' character!");
        }
        this.namespace = namespace;
        this.value = value;
    }

    public NamespaceID(String formattedString) {
        if (!formattedString.contains(":")) {
            throw new IllegalArgumentException("Formatted String '" + formattedString + "' missing ':' character all namespace ids must follow the format <namespace>:<value>!");
        }
        String[] split = formattedString.split(":");
        if (split.length != 2) {
            throw new IllegalArgumentException("Formatted String '" + formattedString + "' has more then 1 ':' character! all namespace ids must follow the format <namespace>:<value>!");
        }
        this.namespace = split[0];
        this.value = split[1];
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        return super.equals(other) | other.toString().equals(this.toString());
    }

    public String toString() {
        return this.namespace + ":" + this.value;
    }

    @Override
    public int compare(NamespaceID o1, NamespaceID o2) {
        return o1.toString().compareTo(o2.toString());
    }
}

