/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.entity.player;

import com.mojang.nbt.CompoundTag;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.minecraft.core.achievement.stat.Stat;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockPortal;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.entity.TileEntityBlastFurnace;
import net.minecraft.core.block.entity.TileEntityDispenser;
import net.minecraft.core.block.entity.TileEntityFlag;
import net.minecraft.core.block.entity.TileEntityFurnace;
import net.minecraft.core.block.entity.TileEntityTrommel;
import net.minecraft.core.crafting.ICrafting;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityItem;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.entity.projectile.EntityArrow;
import net.minecraft.core.enums.EnumSleepStatus;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemComplex;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.net.command.TextFormatting;
import net.minecraft.core.net.packet.Packet;
import net.minecraft.core.net.packet.Packet100OpenWindow;
import net.minecraft.core.net.packet.Packet101CloseWindow;
import net.minecraft.core.net.packet.Packet103SetSlot;
import net.minecraft.core.net.packet.Packet104WindowItems;
import net.minecraft.core.net.packet.Packet105UpdateProgressbar;
import net.minecraft.core.net.packet.Packet142OpenFlagWindow;
import net.minecraft.core.net.packet.Packet16BlockItemSwitch;
import net.minecraft.core.net.packet.Packet17Sleep;
import net.minecraft.core.net.packet.Packet18Animation;
import net.minecraft.core.net.packet.Packet200Statistic;
import net.minecraft.core.net.packet.Packet22Collect;
import net.minecraft.core.net.packet.Packet39AttachEntity;
import net.minecraft.core.net.packet.Packet3Chat;
import net.minecraft.core.net.packet.Packet41EntityPlayerGamemode;
import net.minecraft.core.net.packet.Packet51MapChunk;
import net.minecraft.core.net.packet.Packet5PlayerInventory;
import net.minecraft.core.net.packet.Packet72UpdatePlayerProfile;
import net.minecraft.core.net.packet.Packet8UpdateHealth;
import net.minecraft.core.player.gamemode.Gamemode;
import net.minecraft.core.player.inventory.Container;
import net.minecraft.core.player.inventory.ContainerChest;
import net.minecraft.core.player.inventory.ContainerDispenser;
import net.minecraft.core.player.inventory.ContainerFlag;
import net.minecraft.core.player.inventory.ContainerFurnace;
import net.minecraft.core.player.inventory.ContainerGuidebook;
import net.minecraft.core.player.inventory.ContainerPlayer;
import net.minecraft.core.player.inventory.ContainerTrommel;
import net.minecraft.core.player.inventory.ContainerWorkbench;
import net.minecraft.core.player.inventory.IInventory;
import net.minecraft.core.player.inventory.slot.SlotCrafting;
import net.minecraft.core.util.helper.AES;
import net.minecraft.core.util.helper.DamageType;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.Dimension;
import net.minecraft.core.world.IVehicle;
import net.minecraft.core.world.World;
import net.minecraft.core.world.chunk.ChunkCoordinate;
import net.minecraft.core.world.chunk.ChunkCoordinates;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.entity.EntityTracker;
import net.minecraft.server.net.handler.NetServerHandler;
import net.minecraft.server.world.ServerPlayerController;
import net.minecraft.server.world.WorldServer;

public class EntityPlayerMP
extends EntityPlayer
implements ICrafting {
    public NetServerHandler playerNetServerHandler;
    public MinecraftServer mcServer;
    public ServerPlayerController playerController;
    public double field_9155_d;
    public double field_9154_e;
    public List loadedChunks;
    public Set field_420_ah;
    private int lastHealth = -99999999;
    private int lastScore = -99999999;
    private int ticksOfInvuln = 60;
    private ItemStack[] playerInventory = new ItemStack[]{null, null, null, null, null};
    private int currentWindowId = 0;
    public boolean isChangingQuantityOnly;

    public EntityPlayerMP(MinecraftServer minecraftserver, World world, String s, ServerPlayerController iteminworldmanager) {
        super(world);
        this.loadedChunks = new LinkedList();
        this.field_420_ah = new HashSet();
        iteminworldmanager.player = this;
        this.playerController = iteminworldmanager;
        ChunkCoordinates chunkcoordinates = world.getSpawnPoint();
        int i = chunkcoordinates.x;
        int j = chunkcoordinates.z;
        int k = chunkcoordinates.y;
        if (!world.worldType.hasCeiling()) {
            k = world.findTopSolidBlock(i += this.random.nextInt(20) - 10, j);
            j += this.random.nextInt(20) - 10;
        }
        this.moveTo((double)i + 0.5, k, (double)j + 0.5, 0.0f, 0.0f);
        this.mcServer = minecraftserver;
        this.footSize = 0.0f;
        this.username = s;
        this.heightOffset = 0.0f;
        this.gamemode = minecraftserver.defaultGamemode;
    }

    @Override
    public void moveEntityWithHeading(float moveStrafing, float moveForward) {
        super.moveEntityWithHeading(moveStrafing, moveForward);
        if (this.noPhysics) {
            this.yd = 0.0;
            this.onGround = true;
            this.fallDistance = 0.0f;
            if (this.isSneaking()) {
                this.yd = -0.4;
            }
        }
    }

    @Override
    public void setGamemode(Gamemode gamemode) {
        this.mcServer.playerList.sendPacketToAllPlayers(new Packet41EntityPlayerGamemode(this.id, gamemode.getId()));
        this.gamemode = gamemode;
        ContainerPlayer newContainer = gamemode.getContainer(this.inventory, !this.world.isClientSide);
        if (this.craftingInventory == this.inventorySlots) {
            this.craftingInventory = newContainer;
        }
        this.inventorySlots = newContainer;
        this.inventorySlots.onContainerInit(this);
        if (!gamemode.canPlayerFly()) {
            this.noPhysics = false;
        }
        this.fireImmune = gamemode.isImmuneToFire();
    }

    @Override
    public AABB getBb() {
        if (this.noPhysics) {
            return null;
        }
        return super.getBb();
    }

    @Override
    public void awardKillScore(Entity entity, int i) {
        super.awardKillScore(entity, i);
        this.mcServer.playerList.sendPacketToAllPlayers(new Packet72UpdatePlayerProfile(this.username, this.nickname, this.score, this.chatColor, true, this.isOperator()));
    }

    public boolean isOperator() {
        return this.mcServer.playerList.isOp(this.username);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("Score", this.score);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.score = tag.getInteger("Score");
    }

    @Override
    public void setWorld(World world) {
        super.setWorld(world);
        this.playerController = new ServerPlayerController((WorldServer)world);
        this.playerController.player = this;
    }

    @Override
    public void func_6420_o() {
    }

    public void func_20057_k() {
        this.craftingInventory.onContainerInit(this);
    }

    @Override
    public ItemStack[] getInventory() {
        return this.playerInventory;
    }

    @Override
    protected void resetHeight() {
        this.heightOffset = 0.0f;
    }

    @Override
    public float getHeadHeight() {
        return 1.62f;
    }

    @Override
    public void tick() {
        this.playerController.tick();
        --this.ticksOfInvuln;
        this.craftingInventory.updateInventory();
        for (int i = 0; i < 5; ++i) {
            ItemStack itemstack = this.getEquipmentInSlot(i);
            if (itemstack == this.playerInventory[i]) continue;
            this.mcServer.getEntityTracker(this.dimension).sendPacketToTrackedPlayers(this, new Packet5PlayerInventory(this.id, i, itemstack));
            this.playerInventory[i] = itemstack;
        }
    }

    @Override
    public String getDisplayName() {
        String name = this.nickname;
        if (name.isEmpty()) {
            name = this.username;
        } else {
            EntityPlayer player;
            ArrayList<EntityPlayerMP> players = new ArrayList<EntityPlayerMP>(MinecraftServer.getInstance().playerList.playerEntities);
            players.sort(new EntityPlayer.SortByUsername());
            int nickNum = 0;
            Iterator iterator = players.iterator();
            while (iterator.hasNext() && (player = (EntityPlayer)iterator.next()) != this) {
                if (!player.nickname.equals(this.nickname)) continue;
                ++nickNum;
            }
            name = TextFormatting.ITALIC + name;
            if (nickNum > 0) {
                name = name + " (" + nickNum + ")";
            }
        }
        return TextFormatting.get(this.chatColor) + name;
    }

    public ItemStack getEquipmentInSlot(int i) {
        if (i == 0) {
            return this.inventory.getCurrentItem();
        }
        return this.inventory.armorInventory[i - 1];
    }

    @Override
    public boolean hurt(Entity attacker, int i, DamageType type) {
        if (this.ticksOfInvuln > 0) {
            return false;
        }
        if (!this.mcServer.pvpOn) {
            if (attacker instanceof EntityPlayer) {
                return false;
            }
            if (attacker instanceof EntityArrow) {
                EntityArrow entityarrow = (EntityArrow)attacker;
                if (entityarrow.owner instanceof EntityPlayer) {
                    return false;
                }
            }
        }
        return super.hurt(attacker, i, type);
    }

    protected boolean isPVPEnabled() {
        return this.mcServer.pvpOn;
    }

    @Override
    public void heal(int i) {
        super.heal(i);
    }

    public void onUpdateEntity() {
        super.tick();
        for (int i = 0; i < this.inventory.getSizeInventory(); ++i) {
            Packet packet;
            ItemStack itemstack = this.inventory.getStackInSlot(i);
            if (itemstack == null || !Item.itemsList[itemstack.itemID].isComplex() || this.playerNetServerHandler.getNumChunkDataPackets() > 2 || (packet = ((ItemComplex)Item.itemsList[itemstack.itemID]).sendPacketData(itemstack, this.world, this)) == null) continue;
            this.playerNetServerHandler.sendPacket(packet);
        }
        if (this.inPortal) {
            int targetDim = ((BlockPortal)Block.blocksList[this.portalID]).targetDimension;
            boolean netherAllowed = this.mcServer.propertyManager.getBooleanProperty("allow-nether", true);
            boolean paradiseAllowed = this.mcServer.propertyManager.getBooleanProperty("allow-paradise", false);
            if (netherAllowed && targetDim == Dimension.nether.id || paradiseAllowed && targetDim == Dimension.paradise.id || targetDim != Dimension.nether.id && targetDim != Dimension.paradise.id) {
                if (this.craftingInventory != this.inventorySlots) {
                    this.usePersonalCraftingInventory();
                }
                if (this.vehicle != null) {
                    this.startRiding(this.vehicle);
                } else {
                    this.timeInPortal += 0.0125f;
                    if (this.timeInPortal >= 1.0f || this.getGamemode().instantPortalTravel()) {
                        this.timeInPortal = 1.0f;
                        this.timeUntilPortal = 10;
                        if (this.dimension == targetDim) {
                            this.mcServer.playerList.sendPlayerToOtherDimension(this, 0);
                        } else {
                            this.mcServer.playerList.sendPlayerToOtherDimension(this, targetDim);
                        }
                    }
                }
                this.inPortal = false;
            }
        } else {
            if (this.timeInPortal > 0.0f) {
                this.timeInPortal -= 0.05f;
            }
            if (this.timeInPortal < 0.0f) {
                this.timeInPortal = 0.0f;
            }
        }
        if (this.timeUntilPortal > 0) {
            --this.timeUntilPortal;
        }
        if (this.getHealth() != this.lastHealth) {
            this.playerNetServerHandler.sendPacket(new Packet8UpdateHealth(this.getHealth()));
            this.lastHealth = this.getHealth();
        }
        if (this.score != this.lastScore) {
            this.playerNetServerHandler.sendPacket(new Packet72UpdatePlayerProfile(this.username, this.nickname, this.score, this.chatColor, true, this.isOperator()));
            this.lastScore = this.score;
        }
    }

    public void tickSendChunks() {
        ChunkCoordinate chunkCoord;
        if (!this.loadedChunks.isEmpty() && (chunkCoord = (ChunkCoordinate)this.loadedChunks.get(0)) != null) {
            boolean canSendMoreDataPackets;
            boolean bl = canSendMoreDataPackets = this.playerNetServerHandler.getNumChunkDataPackets() < 8;
            if (canSendMoreDataPackets) {
                WorldServer worldserver = this.mcServer.getDimensionWorld(this.dimension);
                this.loadedChunks.remove(chunkCoord);
                this.playerNetServerHandler.sendPacket(new Packet51MapChunk(chunkCoord.x * 16, 0, chunkCoord.z * 16, 16, 256, 16, worldserver));
                List<TileEntity> list = worldserver.getTileEntityList(chunkCoord.x * 16, 0, chunkCoord.z * 16, chunkCoord.x * 16 + 16, 256, chunkCoord.z * 16 + 16);
                for (int j = 0; j < list.size(); ++j) {
                    this.getTileEntityInfo(list.get(j));
                }
            }
        }
    }

    private void getTileEntityInfo(TileEntity tileentity) {
        Packet packet;
        if (tileentity != null && (packet = tileentity.getDescriptionPacket()) != null) {
            this.playerNetServerHandler.sendPacket(packet);
        }
    }

    @Override
    public void onLivingUpdate() {
        super.onLivingUpdate();
        if (this.tickCount % 10 == 0) {
            Item arrow = this.getNextArrow();
            this.entityData.set(18, arrow == null ? -1 : arrow.id);
        }
    }

    @Override
    public void onItemPickup(Entity entity, int i) {
        if (!entity.removed) {
            EntityTracker entitytracker = this.mcServer.getEntityTracker(this.dimension);
            if (entity instanceof EntityItem) {
                entitytracker.sendPacketToTrackedPlayers(entity, new Packet22Collect(entity.id, this.id));
            }
            if (entity instanceof EntityArrow) {
                entitytracker.sendPacketToTrackedPlayers(entity, new Packet22Collect(entity.id, this.id));
            }
        }
        super.onItemPickup(entity, i);
        this.craftingInventory.updateInventory();
    }

    @Override
    public void swingItem() {
        if (!this.isSwinging) {
            this.swingProgressInt = -1;
            this.isSwinging = true;
            EntityTracker entitytracker = this.mcServer.getEntityTracker(this.dimension);
            entitytracker.sendPacketToTrackedPlayers(this, new Packet18Animation(this, 1));
        }
    }

    public void func_22068_s() {
    }

    @Override
    public EnumSleepStatus sleepInBedAt(int i, int j, int k) {
        EnumSleepStatus enumstatus = super.sleepInBedAt(i, j, k);
        if (enumstatus == EnumSleepStatus.OK) {
            EntityTracker entitytracker = this.mcServer.getEntityTracker(this.dimension);
            Packet17Sleep packet17sleep = new Packet17Sleep(this, 0, i, j, k);
            entitytracker.sendPacketToTrackedPlayers(this, packet17sleep);
            this.playerNetServerHandler.teleportAndRotate(this.x, this.y, this.z, this.yRot, this.xRot);
            this.playerNetServerHandler.sendPacket(packet17sleep);
        }
        return enumstatus;
    }

    @Override
    public void wakeUpPlayer(boolean flag, boolean flag1) {
        if (this.isPlayerSleeping()) {
            EntityTracker entitytracker = this.mcServer.getEntityTracker(this.dimension);
            entitytracker.sendPacketToTrackedPlayersAndTrackedEntity(this, new Packet18Animation(this, 3));
            super.wakeUpPlayer(flag, flag1);
        }
        if (this.playerNetServerHandler != null) {
            this.playerNetServerHandler.teleportAndRotate(this.x, this.y, this.z, this.yRot, this.xRot);
        }
    }

    @Override
    public void startRiding(IVehicle vehicle) {
        if (!this.canRide()) {
            return;
        }
        if (this.vehicle == vehicle) {
            return;
        }
        super.startRiding(vehicle);
        if (vehicle instanceof Entity) {
            this.playerNetServerHandler.sendPacket(new Packet39AttachEntity(this, (Entity)this.vehicle));
        } else if (vehicle instanceof TileEntity) {
            TileEntity tileEntity = (TileEntity)((Object)vehicle);
            this.playerNetServerHandler.sendPacket(new Packet39AttachEntity(this, tileEntity.x, tileEntity.y, tileEntity.z));
        }
        this.playerNetServerHandler.teleport(this.x, this.y, this.z);
    }

    @Override
    protected void checkFallDamage(double d, boolean flag) {
    }

    public void handleFalling(double d, boolean flag) {
        super.checkFallDamage(d, flag);
    }

    private void getNextWindowId() {
        this.currentWindowId = this.currentWindowId % 100 + 1;
    }

    @Override
    public void displayGUIWorkbench(int i, int j, int k) {
        this.getNextWindowId();
        this.playerNetServerHandler.sendPacket(new Packet100OpenWindow(this.currentWindowId, 1, "Crafting", 9));
        this.craftingInventory = new ContainerWorkbench(this.inventory, this.world, i, j, k);
        this.craftingInventory.windowId = this.currentWindowId;
        this.craftingInventory.onContainerInit(this);
    }

    @Override
    public void displayGUIPaintingPicker() {
        this.playerNetServerHandler.sendPacket(new Packet100OpenWindow(this.currentWindowId, 7, "Painting", 0));
    }

    @Override
    public void displayGUIChest(IInventory iinventory) {
        this.getNextWindowId();
        NetServerHandler.logger.info(this.username + " interacted with chest at (" + this.x + ", " + this.y + ", " + this.z + ")");
        this.playerNetServerHandler.sendPacket(new Packet100OpenWindow(this.currentWindowId, 0, iinventory.getInvName(), iinventory.getSizeInventory()));
        this.craftingInventory = new ContainerChest(this.inventory, iinventory);
        this.craftingInventory.windowId = this.currentWindowId;
        this.craftingInventory.onContainerInit(this);
    }

    @Override
    public void displayGUIFurnace(TileEntityFurnace tileentityfurnace) {
        this.getNextWindowId();
        if (tileentityfurnace instanceof TileEntityBlastFurnace) {
            this.playerNetServerHandler.sendPacket(new Packet100OpenWindow(this.currentWindowId, 4, tileentityfurnace.getInvName(), tileentityfurnace.getSizeInventory()));
        } else {
            this.playerNetServerHandler.sendPacket(new Packet100OpenWindow(this.currentWindowId, 2, tileentityfurnace.getInvName(), tileentityfurnace.getSizeInventory()));
        }
        this.craftingInventory = new ContainerFurnace(this.inventory, tileentityfurnace);
        this.craftingInventory.windowId = this.currentWindowId;
        this.craftingInventory.onContainerInit(this);
    }

    @Override
    public void displayGUIDispenser(TileEntityDispenser tileentitydispenser) {
        this.getNextWindowId();
        this.playerNetServerHandler.sendPacket(new Packet100OpenWindow(this.currentWindowId, 3, tileentitydispenser.getInvName(), tileentitydispenser.getSizeInventory()));
        this.craftingInventory = new ContainerDispenser(this.inventory, tileentitydispenser);
        this.craftingInventory.windowId = this.currentWindowId;
        this.craftingInventory.onContainerInit(this);
    }

    @Override
    public void displayGUITrommel(TileEntityTrommel tileentitytrommel) {
        this.getNextWindowId();
        this.playerNetServerHandler.sendPacket(new Packet100OpenWindow(this.currentWindowId, 5, tileentitytrommel.getInvName(), tileentitytrommel.getSizeInventory()));
        this.craftingInventory = new ContainerTrommel(this.inventory, tileentitytrommel);
        this.craftingInventory.windowId = this.currentWindowId;
        this.craftingInventory.onContainerInit(this);
    }

    @Override
    public void displayGUIEditFlag(TileEntityFlag tileEntityFlag) {
        this.getNextWindowId();
        this.playerNetServerHandler.sendPacket(new Packet142OpenFlagWindow(this.currentWindowId, tileEntityFlag.x, tileEntityFlag.y, tileEntityFlag.z));
        this.craftingInventory = new ContainerFlag(this.inventory, tileEntityFlag);
        this.craftingInventory.windowId = this.currentWindowId;
        this.craftingInventory.onContainerInit(this);
    }

    public void displayGUIGuidebook() {
        this.getNextWindowId();
        this.craftingInventory = new ContainerGuidebook();
        this.craftingInventory.windowId = this.currentWindowId;
        this.craftingInventory.onContainerInit(this);
    }

    @Override
    public void updateInventorySlot(Container container, int i, ItemStack itemstack) {
        if (container.getSlot(i) instanceof SlotCrafting) {
            return;
        }
        if (this.isChangingQuantityOnly) {
            return;
        }
        if (this.playerNetServerHandler != null) {
            this.playerNetServerHandler.sendPacket(new Packet103SetSlot(container.windowId, i, itemstack));
        }
    }

    public void func_28017_a(Container container) {
        this.updateCraftingInventory(container, container.func_28127_b());
    }

    @Override
    public void updateCraftingInventory(Container container, List<ItemStack> list) {
        if (this.playerNetServerHandler != null) {
            this.playerNetServerHandler.sendPacket(new Packet104WindowItems(container.windowId, list));
        }
    }

    @Override
    public void updateCraftingInventoryInfo(Container container, int id, int value) {
        this.playerNetServerHandler.sendPacket(new Packet105UpdateProgressbar(container.windowId, id, value));
    }

    @Override
    public void onItemStackChanged(ItemStack itemstack) {
    }

    public void usePersonalCraftingInventory() {
        this.playerNetServerHandler.sendPacket(new Packet101CloseWindow(this.craftingInventory.windowId));
        this.closeCraftingGui();
    }

    public void updateHeldItem() {
        if (this.isChangingQuantityOnly) {
            return;
        }
        this.playerNetServerHandler.sendPacket(new Packet103SetSlot(-1, -1, this.inventory.getHeldItemStack()));
    }

    public void closeCraftingGui() {
        this.craftingInventory.onCraftGuiClosed(this);
        this.craftingInventory = this.inventorySlots;
    }

    public void setMovementType(float f, float f1, boolean flag, boolean flag1, float f2, float f3) {
        this.moveStrafing = f;
        this.moveForward = f1;
        this.isJumping = flag;
        this.setSneaking(flag1);
        this.xRot = f2;
        this.yRot = f3;
    }

    @Override
    public void addStat(Stat statbase, int i) {
        if (statbase == null) {
            return;
        }
        if (!statbase.clientside) {
            while (i > 100) {
                this.playerNetServerHandler.sendPacket(new Packet200Statistic(statbase.statId, 100));
                i -= 100;
            }
            this.playerNetServerHandler.sendPacket(new Packet200Statistic(statbase.statId, i));
        }
    }

    public void func_30002_A() {
        if (this.vehicle != null) {
            this.startRiding(this.vehicle);
        }
        if (this.passenger != null) {
            this.passenger.startRiding(this);
        }
        if (this.sleeping) {
            this.wakeUpPlayer(true, false);
        }
    }

    public void func_30001_B() {
        this.lastHealth = -99999999;
        this.lastScore = -99999999;
    }

    public void func_22061_a(String s) {
        I18n stringtranslate = I18n.getInstance();
        String s1 = stringtranslate.translateKey(s);
        this.playerNetServerHandler.sendPacket(new Packet3Chat(s1));
    }

    @Override
    public void setCurrentItem(int i) {
        super.setCurrentItem(i);
        this.playerNetServerHandler.sendPacket(new Packet16BlockItemSwitch(i));
    }

    @Override
    public void sendMessage(String message) {
        this.playerNetServerHandler.sendPacket(new Packet3Chat(message, 0, AES.keyChain.get(this.username)));
    }

    @Override
    public void sendStatusMessage(String message) {
        this.playerNetServerHandler.sendPacket(new Packet3Chat(message, 1, AES.keyChain.get(this.username)));
    }
}

