/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.net.handler;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.HitResult;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.entity.TileEntityFlag;
import net.minecraft.core.block.entity.TileEntityMobSpawner;
import net.minecraft.core.block.entity.TileEntitySign;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.vehicle.EntityBoat;
import net.minecraft.core.enums.ArtType;
import net.minecraft.core.enums.EnumSignPicture;
import net.minecraft.core.enums.PlacementMode;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.net.ChatEmotes;
import net.minecraft.core.net.ICommandListener;
import net.minecraft.core.net.NetworkManager;
import net.minecraft.core.net.command.Command;
import net.minecraft.core.net.command.CommandError;
import net.minecraft.core.net.command.Commands;
import net.minecraft.core.net.command.PlayerCommandSender;
import net.minecraft.core.net.command.ServerCommandHandler;
import net.minecraft.core.net.command.ServerPlayerCommandSender;
import net.minecraft.core.net.command.TextFormatting;
import net.minecraft.core.net.handler.NetHandler;
import net.minecraft.core.net.packet.Packet;
import net.minecraft.core.net.packet.Packet0KeepAlive;
import net.minecraft.core.net.packet.Packet101CloseWindow;
import net.minecraft.core.net.packet.Packet102WindowClick;
import net.minecraft.core.net.packet.Packet103SetSlot;
import net.minecraft.core.net.packet.Packet106Transaction;
import net.minecraft.core.net.packet.Packet107UpdateCreativeInventory;
import net.minecraft.core.net.packet.Packet108SetHotbarOffset;
import net.minecraft.core.net.packet.Packet10Flying;
import net.minecraft.core.net.packet.Packet11PlayerPosition;
import net.minecraft.core.net.packet.Packet130UpdateSign;
import net.minecraft.core.net.packet.Packet132SetMobSpawner;
import net.minecraft.core.net.packet.Packet133OpenGuidebook;
import net.minecraft.core.net.packet.Packet137SetItemName;
import net.minecraft.core.net.packet.Packet139SetPaintingMotive;
import net.minecraft.core.net.packet.Packet13PlayerLookMove;
import net.minecraft.core.net.packet.Packet14BlockDig;
import net.minecraft.core.net.packet.Packet15Place;
import net.minecraft.core.net.packet.Packet16BlockItemSwitch;
import net.minecraft.core.net.packet.Packet18Animation;
import net.minecraft.core.net.packet.Packet19EntityAction;
import net.minecraft.core.net.packet.Packet250CustomPayload;
import net.minecraft.core.net.packet.Packet255KickDisconnect;
import net.minecraft.core.net.packet.Packet26BoatControl;
import net.minecraft.core.net.packet.Packet27Position;
import net.minecraft.core.net.packet.Packet3Chat;
import net.minecraft.core.net.packet.Packet53BlockChange;
import net.minecraft.core.net.packet.Packet72UpdatePlayerProfile;
import net.minecraft.core.net.packet.Packet7UseEntity;
import net.minecraft.core.net.packet.Packet9Respawn;
import net.minecraft.core.player.gamemode.Gamemode;
import net.minecraft.core.player.inventory.ContainerFlag;
import net.minecraft.core.player.inventory.ContainerPlayerCreative;
import net.minecraft.core.player.inventory.InventoryPlayer;
import net.minecraft.core.player.inventory.slot.Slot;
import net.minecraft.core.util.helper.AES;
import net.minecraft.core.util.helper.ChatAllowedCharacters;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.helper.RestHandler;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.util.phys.Vec3d;
import net.minecraft.core.world.chunk.ChunkCoordinates;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.entity.player.EntityPlayerMP;
import net.minecraft.server.util.helper.PlayerList;
import net.minecraft.server.world.WorldServer;
import org.apache.log4j.Logger;

public class NetServerHandler
extends NetHandler
implements ICommandListener {
    public static Logger logger = Logger.getLogger("Minecraft");
    public NetworkManager netManager;
    public boolean connectionClosed = false;
    private MinecraftServer mcServer;
    private EntityPlayerMP playerEntity;
    private int field_15_f;
    private int field_22004_g;
    private int playerInAirTime;
    private boolean field_22003_h;
    private double lastPosX;
    private double lastPosY;
    private double lastPosZ;
    private boolean hasMoved = true;
    private final Map<Integer, Short> field_10_k = new HashMap<Integer, Short>();

    public NetServerHandler(MinecraftServer minecraftserver, NetworkManager networkManager, EntityPlayerMP player) {
        this.mcServer = minecraftserver;
        this.netManager = networkManager;
        networkManager.setNetHandler(this);
        this.playerEntity = player;
        player.playerNetServerHandler = this;
    }

    public void handlePackets() {
        this.field_22003_h = false;
        this.netManager.processReadPackets();
        if (this.field_15_f - this.field_22004_g > 20) {
            this.sendPacket(new Packet0KeepAlive());
        }
    }

    public void kickPlayer(String s) {
        this.playerEntity.func_30002_A();
        this.sendPacket(new Packet255KickDisconnect(s));
        this.netManager.serverShutdown();
        this.mcServer.playerList.sendPacketToAllPlayers(new Packet3Chat(this.playerEntity.getDisplayName() + TextFormatting.YELLOW + " was kicked from the game."));
        this.mcServer.playerList.sendPacketToAllPlayers(new Packet72UpdatePlayerProfile(this.playerEntity.username, this.playerEntity.nickname, this.playerEntity.score, this.playerEntity.chatColor, false, this.playerEntity.isOperator()));
        this.mcServer.playerList.playerLoggedOut(this.playerEntity);
        this.connectionClosed = true;
        if (MinecraftServer.statsStatus) {
            RestHandler.post("https://api.betterthanadventure.net/stats?serverToken=" + MinecraftServer.statsToken + "&count=" + this.mcServer.playerList.playerEntities.size());
        }
        PlayerList.updateList();
    }

    public void handleMovementTypePacket(Packet27Position packet) {
        this.playerEntity.setMovementType(packet.func_22031_c(), packet.func_22028_e(), packet.func_22032_g(), packet.func_22030_h(), packet.func_22029_d(), packet.func_22033_f());
    }

    @Override
    public void handleSetMobSpawner(Packet132SetMobSpawner packet) {
        TileEntity tileentity;
        WorldServer world = this.mcServer.getDimensionWorld(this.playerEntity.dimension);
        if (this.playerEntity.getGamemode() == Gamemode.creative && world.isBlockLoaded(packet.xPosition, packet.yPosition, packet.zPosition) && (tileentity = world.getBlockTileEntity(packet.xPosition, packet.yPosition, packet.zPosition)) instanceof TileEntityMobSpawner) {
            TileEntityMobSpawner tileEntityMobSpawner = (TileEntityMobSpawner)tileentity;
            tileEntityMobSpawner.setMobId(packet.spawnType);
            tileEntityMobSpawner.onInventoryChanged();
            world.markBlockNeedsUpdate(packet.xPosition, packet.yPosition, packet.zPosition);
        }
    }

    @Override
    public void handleFlying(Packet10Flying packet) {
        WorldServer worldserver = this.mcServer.getDimensionWorld(this.playerEntity.dimension);
        this.field_22003_h = true;
        if (!this.hasMoved) {
            double d = packet.yPosition - this.lastPosY;
            if (packet.xPosition == this.lastPosX && d * d < 0.01 && packet.zPosition == this.lastPosZ) {
                this.hasMoved = true;
            }
        }
        if (this.hasMoved) {
            boolean flag2;
            if (this.playerEntity.vehicle != null) {
                float f = this.playerEntity.yRot;
                float f1 = this.playerEntity.xRot;
                this.playerEntity.vehicle.positionRider();
                double d2 = this.playerEntity.x;
                double d4 = this.playerEntity.y;
                double d6 = this.playerEntity.z;
                double d8 = 0.0;
                double d9 = 0.0;
                if (packet.rotating) {
                    f = packet.yaw;
                    f1 = packet.pitch;
                }
                if (packet.moving && packet.yPosition == -999.0 && packet.stance == -999.0) {
                    d8 = packet.xPosition;
                    d9 = packet.zPosition;
                }
                this.playerEntity.onGround = packet.onGround;
                this.playerEntity.onUpdateEntity();
                this.playerEntity.move(d8, 0.0, d9);
                this.playerEntity.absMoveTo(d2, d4, d6, f, f1);
                this.playerEntity.xd = d8;
                this.playerEntity.zd = d9;
                if (this.playerEntity.vehicle != null && this.playerEntity.vehicle instanceof Entity) {
                    worldserver.func_12017_b((Entity)this.playerEntity.vehicle, true);
                }
                if (this.playerEntity.vehicle != null) {
                    this.playerEntity.vehicle.positionRider();
                }
                this.mcServer.playerList.func_613_b(this.playerEntity);
                this.lastPosX = this.playerEntity.x;
                this.lastPosY = this.playerEntity.y;
                this.lastPosZ = this.playerEntity.z;
                worldserver.updateEntity(this.playerEntity);
                return;
            }
            if (this.playerEntity.isPlayerSleeping()) {
                this.playerEntity.onUpdateEntity();
                this.playerEntity.absMoveTo(this.lastPosX, this.lastPosY, this.lastPosZ, this.playerEntity.yRot, this.playerEntity.xRot);
                worldserver.updateEntity(this.playerEntity);
                return;
            }
            double d1 = this.playerEntity.y;
            this.lastPosX = this.playerEntity.x;
            this.lastPosY = this.playerEntity.y;
            this.lastPosZ = this.playerEntity.z;
            double newPosX = this.playerEntity.x;
            double newPosY = this.playerEntity.y;
            double newPosZ = this.playerEntity.z;
            float f2 = this.playerEntity.yRot;
            float f3 = this.playerEntity.xRot;
            if (packet.moving && packet.yPosition == -999.0 && packet.stance == -999.0) {
                packet.moving = false;
            }
            if (packet.moving && packet.yPosition == -999.0 && packet.stance == -999.0) {
                packet.moving = false;
            }
            if (packet.moving) {
                newPosX = packet.xPosition;
                newPosY = packet.yPosition;
                newPosZ = packet.zPosition;
                if (Math.abs(packet.xPosition) > 3.2E7 || Math.abs(packet.zPosition) > 3.2E7) {
                    logger.warn(this.playerEntity.username + " tried to move to an illegal position");
                    this.teleportAndRotate(this.lastPosX, this.lastPosY, this.lastPosZ, f2, f3);
                    return;
                }
            }
            if (packet.rotating) {
                f2 = packet.yaw;
                f3 = packet.pitch;
            }
            this.playerEntity.onUpdateEntity();
            this.playerEntity.ySlideOffset = 0.0f;
            this.playerEntity.absMoveTo(this.lastPosX, this.lastPosY, this.lastPosZ, f2, f3);
            if (!this.hasMoved) {
                return;
            }
            double dx = newPosX - this.playerEntity.x;
            double dy = newPosY - this.playerEntity.y;
            double dz = newPosZ - this.playerEntity.z;
            double velSquared = dx * dx + dy * dy + dz * dz;
            if (velSquared > 100.0) {
                logger.warn(this.playerEntity.username + " moved too quickly!");
                this.teleportAndRotate(this.lastPosX, this.lastPosY, this.lastPosZ, f2, f3);
                return;
            }
            float f4 = 0.0625f;
            boolean flag = worldserver.getCubes(this.playerEntity, this.playerEntity.bb.copy().getInsetBoundingBox(f4, f4, f4)).size() == 0;
            this.playerEntity.move(dx, dy, dz);
            dx = newPosX - this.playerEntity.x;
            dy = newPosY - this.playerEntity.y;
            if (dy > -0.5 || dy < 0.5) {
                dy = 0.0;
            }
            dz = newPosZ - this.playerEntity.z;
            velSquared = dx * dx + dy * dy + dz * dz;
            boolean flag1 = false;
            if (!this.playerEntity.getGamemode().canPlayerFly() && velSquared > 0.0625 && !this.playerEntity.isPlayerSleeping()) {
                flag1 = true;
                logger.warn(this.playerEntity.username + " moved wrongly!");
                System.out.println("Got position " + newPosX + ", " + newPosY + ", " + newPosZ);
                System.out.println("Expected " + this.playerEntity.x + ", " + this.playerEntity.y + ", " + this.playerEntity.z);
            }
            this.playerEntity.absMoveTo(newPosX, newPosY, newPosZ, f2, f3);
            boolean bl = flag2 = worldserver.getCubes(this.playerEntity, this.playerEntity.bb.copy().getInsetBoundingBox(f4, f4, f4)).size() == 0;
            if (!(this.playerEntity.getGamemode().canPlayerFly() || !flag || !flag1 && flag2 || this.playerEntity.isPlayerSleeping())) {
                this.teleportAndRotate(this.lastPosX, this.lastPosY, this.lastPosZ, f2, f3);
                return;
            }
            AABB axisalignedbb = this.playerEntity.bb.copy().expand(f4, f4, f4).addCoord(0.0, -0.55, 0.0);
            if (!(this.playerEntity.getGamemode().canPlayerFly() || this.mcServer.allowFlight || worldserver.getIsAnySolidGround(axisalignedbb))) {
                if (dy > -0.03125) {
                    ++this.playerInAirTime;
                    if (this.playerInAirTime > 100) {
                        logger.warn(this.playerEntity.username + " was kicked for floating too long!");
                        this.kickPlayer("Flying is not enabled on this server");
                        return;
                    }
                    if (this.playerInAirTime > 80) {
                        this.teleportAndRotate(this.lastPosX, this.lastPosY, this.lastPosZ, f2, f3);
                    }
                }
            } else {
                this.playerInAirTime = 0;
            }
            this.playerEntity.onGround = packet.onGround;
            this.mcServer.playerList.func_613_b(this.playerEntity);
            this.playerEntity.handleFalling(this.playerEntity.y - d1, packet.onGround);
        }
    }

    public void teleport(double x, double y, double z) {
        this.hasMoved = false;
        this.lastPosX = x;
        this.lastPosY = y;
        this.lastPosZ = z;
        this.playerEntity.absMoveTo(x, y, z, this.playerEntity.yRot, this.playerEntity.xRot);
        this.playerEntity.playerNetServerHandler.sendPacket(new Packet11PlayerPosition(x, y + 1.625, y, z, false));
    }

    public void teleportAndRotate(double x, double y, double z, float yaw, float pitch) {
        this.hasMoved = false;
        this.lastPosX = x;
        this.lastPosY = y;
        this.lastPosZ = z;
        this.playerEntity.absMoveTo(x, y, z, yaw, pitch);
        this.playerEntity.playerNetServerHandler.sendPacket(new Packet13PlayerLookMove(x, y + 1.625, y, z, yaw, pitch, false));
    }

    @Override
    public void handleBlockDig(Packet14BlockDig packet) {
        int spawnDistZ;
        int x = packet.xPosition;
        int y = packet.yPosition;
        int z = packet.zPosition;
        WorldServer world = this.mcServer.getDimensionWorld(this.playerEntity.dimension);
        if (packet.status == 4) {
            this.playerEntity.dropCurrentItem(false);
            return;
        }
        if (packet.status == 5) {
            this.playerEntity.dropCurrentItem(true);
            return;
        }
        if (packet.status == 6) {
            this.playerEntity.pickBlock(x, y, z);
            return;
        }
        double playerDistX = this.playerEntity.x - ((double)x + 0.5);
        double playerDistY = this.playerEntity.y - ((double)y + 0.5);
        double playerDistZ = this.playerEntity.z - ((double)z + 0.5);
        double playerDist = playerDistX * playerDistX + playerDistY * playerDistY + playerDistZ * playerDistZ;
        if (playerDist > 44.0) {
            return;
        }
        world.field_819_z = this.mcServer.spawnProtectionRange <= 0 || world.dimension.id != 0 || this.mcServer.playerList.isOp(this.playerEntity.username);
        boolean ignoreSpawnProtection = world.field_819_z;
        ChunkCoordinates spawnPos = world.getSpawnPoint();
        int spawnDistX = (int)MathHelper.abs(x - spawnPos.x);
        int distanceFromSpawn = Math.max(spawnDistX, spawnDistZ = (int)MathHelper.abs(z - spawnPos.z));
        if (distanceFromSpawn <= this.mcServer.spawnProtectionRange && !ignoreSpawnProtection) {
            this.playerEntity.playerNetServerHandler.sendPacket(new Packet53BlockChange(x, y, z, world));
            world.field_819_z = false;
            return;
        }
        if (packet.status == 0) {
            this.playerEntity.playerController.startMining(x, y, z, packet.side);
        } else if (packet.status == 1) {
            this.playerEntity.playerController.hitBlock(x, y, z, packet.side);
        } else if (packet.status == 2 && !this.playerEntity.playerController.destroyBlock(x, y, z)) {
            this.playerEntity.playerNetServerHandler.sendPacket(new Packet53BlockChange(x, y, z, world));
        }
        world.field_819_z = false;
    }

    public void handleSendInitialPlayerList() {
        for (EntityPlayerMP entityPlayerMP : this.mcServer.playerList.playerEntities) {
            this.sendPacket(new Packet72UpdatePlayerProfile(entityPlayerMP.username, entityPlayerMP.nickname, entityPlayerMP.score, entityPlayerMP.chatColor, true, entityPlayerMP.isOperator()));
        }
    }

    @Override
    public void handlePlace(Packet15Place packet) {
        WorldServer worldserver = this.mcServer.getDimensionWorld(this.playerEntity.dimension);
        ItemStack itemstack = this.playerEntity.inventory.getCurrentItem();
        worldserver.field_819_z = worldserver.dimension.id != 0 || this.mcServer.playerList.isOp(this.playerEntity.username);
        boolean flag = worldserver.field_819_z;
        if (packet.direction == Direction.NONE) {
            if (itemstack == null) {
                return;
            }
            this.playerEntity.playerController.func_6154_a(this.playerEntity, worldserver, itemstack);
        } else {
            int j1;
            int x = packet.xPosition;
            int y = packet.yPosition;
            int z = packet.zPosition;
            Direction direction = packet.direction;
            double xPlaced = packet.xPlaced;
            double yPlaced = packet.yPlaced;
            ChunkCoordinates chunkcoordinates = worldserver.getSpawnPoint();
            int i1 = (int)MathHelper.abs(x - chunkcoordinates.x);
            if (i1 > (j1 = (int)MathHelper.abs(z - chunkcoordinates.z))) {
                j1 = i1;
            }
            if (this.hasMoved && this.playerEntity.distanceToSqr((double)x + 0.5, (double)y + 0.5, (double)z + 0.5) < 64.0 && (j1 > this.mcServer.spawnProtectionRange || flag)) {
                this.playerEntity.playerController.activateBlockOrUseItem(this.playerEntity, worldserver, itemstack, x, y, z, direction.getSide(), xPlaced, yPlaced);
            }
            this.playerEntity.playerNetServerHandler.sendPacket(new Packet53BlockChange(x, y, z, worldserver));
            this.playerEntity.playerNetServerHandler.sendPacket(new Packet53BlockChange(x += direction.getOffsetX(), y += direction.getOffsetY(), z += direction.getOffsetZ(), worldserver));
        }
        itemstack = this.playerEntity.inventory.getCurrentItem();
        if (itemstack != null && itemstack.stackSize <= 0) {
            this.playerEntity.inventory.mainInventory[this.playerEntity.inventory.currentItem] = null;
        }
        this.playerEntity.isChangingQuantityOnly = true;
        this.playerEntity.inventory.mainInventory[this.playerEntity.inventory.currentItem] = ItemStack.copyItemStack(this.playerEntity.inventory.mainInventory[this.playerEntity.inventory.currentItem]);
        Slot slot = this.playerEntity.craftingInventory.func_20127_a(this.playerEntity.inventory, this.playerEntity.inventory.currentItem);
        this.playerEntity.craftingInventory.updateInventory();
        this.playerEntity.isChangingQuantityOnly = false;
        if (!ItemStack.areItemStacksEqual(this.playerEntity.inventory.getCurrentItem(), packet.itemStack)) {
            this.sendPacket(new Packet103SetSlot(this.playerEntity.craftingInventory.windowId, slot.id, this.playerEntity.inventory.getCurrentItem()));
        }
        worldserver.field_819_z = false;
    }

    @Override
    public void handleErrorMessage(String s, Object[] aobj) {
        logger.info(this.playerEntity.username + " lost connection: " + s);
        this.mcServer.playerList.sendPacketToAllPlayers(new Packet3Chat(this.playerEntity.getDisplayName() + TextFormatting.YELLOW + " left the game."));
        this.mcServer.playerList.sendPacketToAllPlayers(new Packet72UpdatePlayerProfile(this.playerEntity.username, this.playerEntity.nickname, this.playerEntity.score, this.playerEntity.chatColor, false, this.playerEntity.isOperator()));
        this.mcServer.playerList.playerLoggedOut(this.playerEntity);
        this.connectionClosed = true;
        if (MinecraftServer.statsStatus) {
            RestHandler.post("https://api.betterthanadventure.net/stats?serverToken=" + MinecraftServer.statsToken + "&count=" + this.mcServer.playerList.playerEntities.size());
        }
        PlayerList.updateList();
    }

    @Override
    public void handleInvalidPacket(Packet packet) {
        logger.warn(this.getClass() + " wasn't prepared to deal with a " + packet.getClass());
        this.kickPlayer("Protocol error, unexpected packet");
    }

    public void sendPacket(Packet packet) {
        this.netManager.addToSendQueue(packet);
        this.field_22004_g = this.field_15_f;
    }

    @Override
    public void handleBlockItemSwitch(Packet16BlockItemSwitch packet) {
        if (packet.id < 0 || packet.id > InventoryPlayer.func_25054_e()) {
            logger.warn(this.playerEntity.username + " tried to set an invalid carried item");
            return;
        }
        this.playerEntity.inventory.currentItem = packet.id;
    }

    @Override
    public void handleChat(Packet3Chat packet) {
        String message;
        if (packet.encrypted) {
            try {
                message = AES.decrypt(packet.message, AES.keyChain.get(this.playerEntity.username));
            }
            catch (Exception e) {
                throw new RuntimeException("This crash is caused by outdated Java, please update to 8u161 or newer! If your Java version is out of date due to a technical requirement, please add the JCE Unlimited Strength Jurisdiction Policy Files to your installation. https://www.oracle.com/java/technologies/javase-jce-all-downloads.html", e);
            }
        } else {
            message = packet.message;
        }
        if (message.length() > 256) {
            message = message.substring(0, 255);
        }
        message = message.trim();
        for (int i = 0; i < message.length(); ++i) {
            char c = message.charAt(i);
            if (ChatAllowedCharacters.ALLOWED_CHARACTERS.indexOf(c) >= 0) continue;
            this.sendPacket(new Packet3Chat(String.valueOf(TextFormatting.GRAY) + TextFormatting.ITALIC + "[SERVER] Illegal characters in chat message."));
            return;
        }
        if (message.startsWith("/")) {
            this.handleSlashCommand(message);
        } else {
            message = ChatEmotes.process(message);
            message = "<" + this.playerEntity.getDisplayName() + TextFormatting.RESET + "> " + TextFormatting.WHITE + message;
            logger.info(message);
            this.mcServer.playerList.sendEncryptedChatToAllPlayers(message);
        }
    }

    private void handleSlashCommand(String s) {
        ServerPlayerCommandSender sender = new ServerPlayerCommandSender(this.mcServer, this.playerEntity);
        ServerCommandHandler handler = new ServerCommandHandler(this.mcServer);
        String[] args = s.substring(1).split(" ");
        String[] args1 = new String[args.length - 1];
        System.arraycopy(args, 1, args1, 0, args.length - 1);
        for (Command command : Commands.commands) {
            if (!command.isName(args[0])) continue;
            if (!sender.isAdmin() && command.opRequired(args1)) {
                logger.info("Player " + ((PlayerCommandSender)sender).getPlayer().username + " tried command: " + s);
                sender.sendMessage(TextFormatting.RED + "You don't have permission to use this command!");
                return;
            }
            logger.info("Player " + ((PlayerCommandSender)sender).getPlayer().username + " used command: " + s);
            try {
                boolean success = command.execute(handler, sender, args1);
                if (!success) {
                    command.sendCommandSyntax(handler, sender);
                }
            }
            catch (CommandError e) {
                sender.sendMessage(TextFormatting.RED + e.getMessage());
            }
            catch (Throwable e) {
                e.printStackTrace();
                sender.sendMessage(TextFormatting.RED + "Error!");
            }
            return;
        }
        if (s.toLowerCase().startsWith("/kill")) {
            this.playerEntity.hurt(null, 1000, null);
        } else if (s.equalsIgnoreCase("/online")) {
            StringBuilder playerList = new StringBuilder();
            for (int i = 0; i < this.mcServer.playerList.playerEntities.size(); ++i) {
                if (i > 0) {
                    playerList.append(",");
                }
                EntityPlayerMP entityplayermp = this.mcServer.playerList.playerEntities.get(i);
                playerList.append(entityplayermp.getDisplayName()).append(": ").append(TextFormatting.YELLOW).append(entityplayermp.score).append("pts").append(TextFormatting.WHITE);
            }
            logger.info(s);
            this.sendPacket(new Packet3Chat(playerList.toString()));
        } else if (this.mcServer.playerList.isOp(this.playerEntity.username)) {
            String s1 = s.substring(1);
            logger.info(this.playerEntity.username + " issued server command: " + s1);
            this.mcServer.addCommand(s1, this);
        } else {
            String s2 = s.substring(1);
            logger.info(this.playerEntity.username + " tried command: " + s2);
        }
    }

    @Override
    public void handleAnimation(Packet18Animation packet) {
        if (packet.animate == 1) {
            this.playerEntity.swingItem();
        }
    }

    @Override
    public void handleEntityAction(Packet19EntityAction packet) {
        if (packet.state == 1) {
            this.playerEntity.setSneaking(true);
        } else if (packet.state == 2) {
            this.playerEntity.setSneaking(false);
        } else if (packet.state == 3) {
            this.playerEntity.wakeUpPlayer(false, true);
            this.hasMoved = false;
        }
    }

    @Override
    public void handleBoatControl(Packet26BoatControl packet26BoatControl) {
        if (this.playerEntity.vehicle != null && this.playerEntity.vehicle instanceof EntityBoat) {
            EntityBoat boat = (EntityBoat)this.playerEntity.vehicle;
            boat.handleControlDirect(packet26BoatControl.targetXD, packet26BoatControl.targetZD, packet26BoatControl.targetYRot);
            packet26BoatControl.entityId = boat.id;
            this.mcServer.playerList.sendPacketToOtherPlayersAroundPoint(this.playerEntity, boat.x, boat.y, boat.z, 128.0, boat.world.dimension.id, packet26BoatControl);
        }
    }

    @Override
    public void handleKickDisconnect(Packet255KickDisconnect packet) {
        this.netManager.networkShutdown("disconnect.quitting", new Object[0]);
    }

    public int getNumChunkDataPackets() {
        return this.netManager.getNumChunkDataPackets();
    }

    @Override
    public void log(String s) {
        this.sendPacket(new Packet3Chat("\u00a77" + s));
    }

    @Override
    public String getUsername() {
        return this.playerEntity.username;
    }

    @Override
    public void handleUseEntity(Packet7UseEntity packet) {
        WorldServer worldserver = this.mcServer.getDimensionWorld(this.playerEntity.dimension);
        Entity targetEntity = worldserver.getEntityFromId(packet.targetEntity);
        if (targetEntity != null && this.playerEntity.distanceToSqr(targetEntity) < 36.0) {
            boolean canAttack = this.playerEntity.canEntityBeSeen(targetEntity);
            if (!canAttack) {
                float f1 = MathHelper.cos(-this.playerEntity.yRot * 0.01745329f - 3.141593f);
                float f2 = MathHelper.sin(-this.playerEntity.yRot * 0.01745329f - 3.141593f);
                float f3 = -MathHelper.cos(-this.playerEntity.xRot * 0.01745329f);
                float f4 = MathHelper.sin(-this.playerEntity.xRot * 0.01745329f);
                Vec3d viewVector = Vec3d.createVector(f2 * f3, f4, f1 * f3);
                viewVector.xCoord *= 8.0;
                viewVector.yCoord *= 8.0;
                viewVector.zCoord *= 8.0;
                viewVector.xCoord += this.playerEntity.x;
                viewVector.yCoord += this.playerEntity.y;
                viewVector.zCoord += this.playerEntity.z;
                Vec3d playerViewPos = Vec3d.createVector(this.playerEntity.x, this.playerEntity.y + (double)this.playerEntity.getHeadHeight(), this.playerEntity.z);
                HitResult movingObjectPosition = targetEntity.bb.func_1169_a(playerViewPos, viewVector);
                boolean bl = canAttack = movingObjectPosition != null && worldserver.checkBlockCollisionBetweenPoints(playerViewPos, movingObjectPosition.location) == null;
            }
            if (canAttack) {
                if (packet.isLeftClick == 0) {
                    this.playerEntity.useCurrentItemOnEntity(targetEntity);
                } else if (packet.isLeftClick == 1) {
                    this.playerEntity.attackTargetEntityWithCurrentItem(targetEntity);
                }
            }
        }
    }

    @Override
    public void handleOpenGuidebook(Packet133OpenGuidebook packet) {
        this.playerEntity.displayGUIGuidebook();
    }

    @Override
    public void handleRespawn(Packet9Respawn packet) {
        if (this.playerEntity.getHealth() <= 0) {
            this.playerEntity = this.mcServer.playerList.recreatePlayerEntity(this.playerEntity, 0);
        }
    }

    @Override
    public void handleCloseWindow(Packet101CloseWindow packet) {
        this.playerEntity.closeCraftingGui();
    }

    @Override
    public void handleWindowClick(Packet102WindowClick packet) {
        if (this.playerEntity.craftingInventory.windowId == packet.window_Id && this.playerEntity.craftingInventory.getCanCraft(this.playerEntity)) {
            ItemStack itemstack = this.playerEntity.craftingInventory.clickInventorySlot(packet.action, packet.args, this.playerEntity);
            if (ItemStack.areItemStacksEqual(packet.itemStack, itemstack)) {
                this.playerEntity.playerNetServerHandler.sendPacket(new Packet106Transaction(packet.window_Id, packet.actionId, true));
                this.playerEntity.isChangingQuantityOnly = true;
                this.playerEntity.craftingInventory.updateInventory();
                this.playerEntity.updateHeldItem();
                this.playerEntity.isChangingQuantityOnly = false;
            } else {
                this.field_10_k.put(this.playerEntity.craftingInventory.windowId, packet.actionId);
                this.playerEntity.playerNetServerHandler.sendPacket(new Packet106Transaction(packet.window_Id, packet.actionId, false));
                this.playerEntity.craftingInventory.setCanCraft(this.playerEntity, false);
                ArrayList<ItemStack> arraylist = new ArrayList<ItemStack>();
                for (int i = 0; i < this.playerEntity.craftingInventory.inventorySlots.size(); ++i) {
                    arraylist.add(this.playerEntity.craftingInventory.inventorySlots.get(i).getStack());
                }
                this.playerEntity.updateCraftingInventory(this.playerEntity.craftingInventory, arraylist);
            }
        }
    }

    @Override
    public void handleTransaction(Packet106Transaction packet) {
        Short short1 = this.field_10_k.get(this.playerEntity.craftingInventory.windowId);
        if (short1 != null && packet.shortWindowId == short1 && this.playerEntity.craftingInventory.windowId == packet.windowId && !this.playerEntity.craftingInventory.getCanCraft(this.playerEntity)) {
            this.playerEntity.craftingInventory.setCanCraft(this.playerEntity, true);
        }
    }

    @Override
    public void handleUpdateSign(Packet130UpdateSign packet) {
        WorldServer worldserver = this.mcServer.getDimensionWorld(this.playerEntity.dimension);
        if (worldserver.isBlockLoaded(packet.xPosition, packet.yPosition, packet.zPosition)) {
            TileEntitySign tileentitysign;
            TileEntity tileentity = worldserver.getBlockTileEntity(packet.xPosition, packet.yPosition, packet.zPosition);
            if (tileentity instanceof TileEntitySign && !(tileentitysign = (TileEntitySign)tileentity).getIsEditable(this.playerEntity)) {
                this.mcServer.logWarning("Player " + this.playerEntity.username + " just tried to change non-editable sign");
                return;
            }
            for (int i = 0; i < 4; ++i) {
                boolean isLineValid = true;
                if (packet.signLines[i].length() > 15) {
                    isLineValid = false;
                } else {
                    packet.signLines[i] = packet.signLines[i].replaceAll("\u00a7", "$");
                    for (int l = 0; l < packet.signLines[i].length(); ++l) {
                        if (ChatAllowedCharacters.ALLOWED_CHARACTERS.indexOf(packet.signLines[i].charAt(l)) >= 0) continue;
                        isLineValid = false;
                        break;
                    }
                }
                if (isLineValid) continue;
                packet.signLines[i] = "!?";
            }
            if (tileentity instanceof TileEntitySign) {
                int x = packet.xPosition;
                int y = packet.yPosition;
                int z = packet.zPosition;
                TileEntitySign tileEntity = (TileEntitySign)tileentity;
                for (int j1 = 0; j1 < 4; ++j1) {
                    tileEntity.signText[j1] = packet.signLines[j1];
                }
                tileEntity.setColor(TextFormatting.FORMATTINGS[packet.color]);
                tileEntity.setPicture(EnumSignPicture.values()[packet.picture]);
                tileEntity.onInventoryChanged();
                worldserver.markBlockNeedsUpdate(x, y, z);
            }
        }
    }

    @Override
    public void handleUpdateCreativeInventory(Packet107UpdateCreativeInventory packet) {
        if (this.playerEntity.craftingInventory.windowId == packet.windowId && this.playerEntity.craftingInventory instanceof ContainerPlayerCreative) {
            ((ContainerPlayerCreative)this.playerEntity.craftingInventory).setInventoryStatus(packet.page, packet.searchText);
        }
    }

    @Override
    public void handleSetHotbarOffset(Packet108SetHotbarOffset packet) {
        this.playerEntity.inventory.hotbarOffset = packet.hotbarOffset;
    }

    @Override
    public void handleItemName(Packet137SetItemName packet) {
        this.playerEntity.inventory.getStackInSlot(packet.slot).setCustomName(packet.name);
    }

    @Override
    public void handleSetPaintingMotive(Packet139SetPaintingMotive packet) {
        this.playerEntity.setSelectedArt(ArtType.values.get(packet.motive));
    }

    @Override
    public void handleCustomPayload(Packet250CustomPayload packet) {
        if ("BTA|RotationLock".equals(packet.channel)) {
            if (packet.data.length == 4) {
                this.playerEntity.rotationLock = Direction.getDirectionById(packet.data[0]);
                this.playerEntity.rotationLockHorizontal = Direction.getDirectionById(packet.data[1]);
                this.playerEntity.rotationLockVertical = Direction.getDirectionById(packet.data[2]);
                this.playerEntity.placementModeOverride = PlacementMode.get(packet.data[3]);
            }
        } else if ("BTA|Flag".equals(packet.channel)) {
            if (packet.data.length == 384 && this.playerEntity.craftingInventory instanceof ContainerFlag) {
                ContainerFlag containerFlag = (ContainerFlag)this.playerEntity.craftingInventory;
                TileEntityFlag tileEntity = containerFlag.tileEntity;
                if (tileEntity.owner == null || tileEntity.owner.isEmpty() || tileEntity.owner.equals(this.playerEntity.username)) {
                    tileEntity.owner = this.playerEntity.username;
                    System.arraycopy(packet.data, 0, tileEntity.flagColors, 0, 384);
                    this.playerEntity.world.markBlockNeedsUpdate(tileEntity.x, tileEntity.y, tileEntity.z);
                } else {
                    System.out.println("Player '" + this.playerEntity.username + "' tried editing a flag that belongs to '" + tileEntity.owner + "'!");
                    this.playerEntity.world.markBlockNeedsUpdate(tileEntity.x, tileEntity.y, tileEntity.z);
                }
            }
        } else if ("BTA|WandMonster".equals(packet.channel) && this.playerEntity.getHeldItem() != null && this.playerEntity.getHeldItem().getItem() == Item.wandMonsterSpawner) {
            String id = new String(packet.data, StandardCharsets.UTF_8);
            this.playerEntity.getHeldItem().getData().putString("monster", id);
        }
    }

    @Override
    public boolean isServerHandler() {
        return true;
    }
}

