/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.world;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.net.packet.Packet53BlockChange;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.server.entity.player.EntityPlayerMP;
import net.minecraft.server.world.WorldServer;

public class ServerPlayerController {
    private WorldServer thisWorld;
    public EntityPlayer player;
    private int blockHitTicks;
    private int currentlyMiningX;
    private int currentlyMiningY;
    private int currentlyMiningZ;
    private int ticksRan;
    private boolean destroyBlock;
    private int destroyX;
    private int destroyY;
    private int destroyZ;
    private int destroyBlockTicks;

    public ServerPlayerController(WorldServer worldserver) {
        this.thisWorld = worldserver;
    }

    public void tick() {
        ++this.ticksRan;
        if (this.destroyBlock) {
            int i = this.ticksRan - this.destroyBlockTicks;
            int j = this.thisWorld.getBlockId(this.destroyX, this.destroyY, this.destroyZ);
            if (j != 0) {
                Block block = Block.blocksList[j];
                float f = block.blockStrength(this.player) * (float)(i + 1);
                if (f >= 1.0f) {
                    this.destroyBlock = false;
                    this.mineBlock(this.destroyX, this.destroyY, this.destroyZ);
                }
            } else {
                this.destroyBlock = false;
            }
        }
    }

    public void startMining(int x, int y, int z, Side side) {
        if (!this.player.getGamemode().doBlockBreakingAnim()) {
            this.mineBlock(x, y, z);
            return;
        }
        this.blockHitTicks = this.ticksRan;
        Block block = this.thisWorld.getBlock(x, y, z);
        if (block != null && block.blockStrength(this.player) >= 1.0f) {
            this.mineBlock(x, y, z);
        } else {
            this.currentlyMiningX = x;
            this.currentlyMiningY = y;
            this.currentlyMiningZ = z;
        }
    }

    public void hitBlock(int x, int y, int z, Side side) {
        this.thisWorld.onBlockHit(this.player, x, y, z, side);
        Block block = this.thisWorld.getBlock(x, y, z);
        if (block != null) {
            block.onBlockClicked(this.thisWorld, x, y, z, this.player);
        }
    }

    public boolean destroyBlock(int x, int y, int z) {
        if (x == this.currentlyMiningX && y == this.currentlyMiningY && z == this.currentlyMiningZ) {
            int l = this.ticksRan - this.blockHitTicks;
            int i1 = this.thisWorld.getBlockId(x, y, z);
            if (i1 != 0) {
                Block block = Block.blocksList[i1];
                float f = block.blockStrength(this.player) * (float)(l + 1);
                if (f >= 0.7f) {
                    return this.mineBlock(x, y, z);
                }
                if (!this.destroyBlock) {
                    this.destroyBlock = true;
                    this.destroyX = x;
                    this.destroyY = y;
                    this.destroyZ = z;
                    this.destroyBlockTicks = this.blockHitTicks;
                }
            }
        }
        return false;
    }

    public boolean removeBlock(int i, int j, int k) {
        Block block = Block.blocksList[this.thisWorld.getBlockId(i, j, k)];
        int l = this.thisWorld.getBlockMetadata(i, j, k);
        return this.thisWorld.setBlockWithNotify(i, j, k, 0);
    }

    public boolean mineBlock(int x, int y, int z) {
        ItemStack itemstack;
        ItemStack heldItemStack = this.player.getHeldItem();
        Item heldItem = null;
        if (heldItemStack != null) {
            heldItem = heldItemStack.getItem();
            if (!heldItemStack.beforeDestroyBlock(this.thisWorld, x, y, z, this.player)) {
                return false;
            }
        }
        int id = this.thisWorld.getBlockId(x, y, z);
        int meta = this.thisWorld.getBlockMetadata(x, y, z);
        Block block = Block.getBlock(id);
        TileEntity tileEntity = this.thisWorld.getBlockTileEntity(x, y, z);
        this.thisWorld.playSoundEffect(this.player, 2001, x, y, z, id);
        boolean flag = this.removeBlock(x, y, z);
        if (flag && block != null) {
            block.onBlockDestroyedByPlayer(this.thisWorld, x, y, z, meta, this.player, heldItem);
        }
        if (flag && this.player.canHarvestBlock(Block.blocksList[id]) && this.player.getGamemode().dropBlockOnBreak()) {
            Block.blocksList[id].harvestBlock(this.thisWorld, this.player, x, y, z, meta, tileEntity);
            ((EntityPlayerMP)this.player).playerNetServerHandler.sendPacket(new Packet53BlockChange(x, y, z, this.thisWorld));
        }
        if ((itemstack = this.player.getCurrentEquippedItem()) != null) {
            itemstack.onDestroyBlock(this.thisWorld, id, x, y, z, this.player);
            if (itemstack.stackSize <= 0) {
                this.player.destroyCurrentEquippedItem();
            }
        }
        return flag;
    }

    public boolean func_6154_a(EntityPlayer entityplayer, World world, ItemStack itemstack) {
        if (!entityplayer.getGamemode().canInteract()) {
            return false;
        }
        int i = itemstack.stackSize;
        ItemStack itemstack1 = itemstack.useItemRightClick(world, entityplayer);
        if (itemstack1 != itemstack || itemstack1 != null && itemstack1.stackSize != i) {
            entityplayer.inventory.mainInventory[entityplayer.inventory.currentItem] = itemstack1;
            if (itemstack1.stackSize <= 0) {
                entityplayer.inventory.mainInventory[entityplayer.inventory.currentItem] = null;
            }
            return true;
        }
        return false;
    }

    public boolean activateBlockOrUseItem(EntityPlayer entityplayer, World world, ItemStack itemstack, int i, int j, int k, Side side, double xPlaced, double yPlaced) {
        if (!entityplayer.getGamemode().canInteract()) {
            return false;
        }
        int i1 = world.getBlockId(i, j, k);
        if ((entityplayer.isSneaking() && entityplayer.getCurrentEquippedItem() == null || !entityplayer.isSneaking()) && i1 > 0 && Block.blocksList[i1].blockActivated(world, i, j, k, entityplayer)) {
            return true;
        }
        if (itemstack == null) {
            return false;
        }
        return itemstack.useItem(entityplayer, world, i, j, k, side, xPlaced, yPlaced);
    }
}

