/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.modelviewer.categories.entries.particle;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.modelviewer.categories.entries.particle.ParticleEntry;
import net.minecraft.client.gui.modelviewer.elements.GuiListenerTextField;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.world.World;
import org.lwjgl.input.Keyboard;

public class GenericFXEntry
extends ParticleEntry {
    public final String particleID;
    protected final String overrideName;
    protected double motionX;
    protected double motionY;
    protected double motionZ;
    protected int data;

    public GenericFXEntry(String particleID) {
        this(particleID, null);
    }

    public GenericFXEntry(String particleID, String overrideName) {
        this.particleID = Objects.requireNonNull(particleID);
        this.overrideName = overrideName;
    }

    @Override
    public String getParticleName(I18n translator) {
        if (this.overrideName != null) {
            return this.overrideName;
        }
        return this.particleID;
    }

    @Override
    public List<GuiButton> getEntryButtons(Minecraft mc, GuiScreen parentScreen) {
        ArrayList<GuiButton> buttons = new ArrayList<GuiButton>();
        GuiListenerTextField mxField = new GuiListenerTextField(parentScreen, mc.fontRenderer, -120, 0, 120, 20, String.valueOf(this.motionX), "Motion X");
        mxField.setPrefaceText("Motion X: ");
        mxField.setOnValueChanged(() -> {
            try {
                this.motionX = Double.parseDouble(mxField.getText());
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        GuiListenerTextField myField = new GuiListenerTextField(parentScreen, mc.fontRenderer, -120, mxField.yPosition + 21, 120, 20, String.valueOf(this.motionY), "Motion Y");
        myField.setPrefaceText("Motion Y: ");
        myField.setOnValueChanged(() -> {
            try {
                this.motionY = Double.parseDouble(myField.getText());
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        GuiListenerTextField mzField = new GuiListenerTextField(parentScreen, mc.fontRenderer, -120, myField.yPosition + 21, 120, 20, String.valueOf(this.motionZ), "Motion Z");
        mzField.setPrefaceText("Motion Z: ");
        mzField.setOnValueChanged(() -> {
            try {
                this.motionZ = Double.parseDouble(mzField.getText());
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        GuiListenerTextField dataField = new GuiListenerTextField(parentScreen, mc.fontRenderer, -120, mzField.yPosition + 21, 120, 20, String.valueOf(this.data), "Data");
        dataField.setPrefaceText("Data: ");
        dataField.setKeyListener(key -> {
            try {
                this.data = Integer.parseInt(dataField.getText());
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        dataField.setActionListener(() -> {
            if (Keyboard.isKeyDown((int)29)) {
                dataField.setText(String.valueOf(0));
                this.data = 0;
            }
        });
        buttons.add(mxField);
        buttons.add(myField);
        buttons.add(mzField);
        return buttons;
    }

    @Override
    public void spawnParticle(Minecraft mc, World world, double x, double y, double z) {
        world.spawnParticle(this.particleID, x, y, z, this.motionX, this.motionY, this.motionZ, this.data);
    }

    @Override
    public void onOpen() {
        this.motionX = 0.0;
        this.motionY = 0.0;
        this.motionZ = 0.0;
    }

    @Override
    public void onClose() {
    }
}

