/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.block.model.BlockModelDispatcher;
import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.block.model.BlockModelTorch;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockRedstoneRepeater;
import net.minecraft.core.world.WorldSource;

public class BlockModelRepeater
extends BlockModelStandard<BlockRedstoneRepeater> {
    private static final BlockModelTorch<Block> modelTorchActive = (BlockModelTorch)BlockModelDispatcher.getInstance().getDispatch(Block.torchRedstoneActive);
    private static final BlockModelTorch<Block> modelTorchIdle = (BlockModelTorch)BlockModelDispatcher.getInstance().getDispatch(Block.torchRedstoneIdle);

    public BlockModelRepeater(Block block) {
        super(block);
    }

    @Override
    public boolean render(Tessellator tessellator, int x, int y, int z) {
        ((BlockRedstoneRepeater)this.block).setBlockBoundsBasedOnState(BlockModelRepeater.renderBlocks.blockAccess, x, y, z);
        int meta = BlockModelRepeater.renderBlocks.blockAccess.getBlockMetadata(x, y, z);
        int i1 = meta & 3;
        switch (i1) {
            case 0: {
                BlockModelRepeater.renderBlocks.uvRotateTop = 0;
                break;
            }
            case 2: {
                BlockModelRepeater.renderBlocks.uvRotateTop = 3;
                break;
            }
            case 3: {
                BlockModelRepeater.renderBlocks.uvRotateTop = 2;
                break;
            }
            case 1: {
                BlockModelRepeater.renderBlocks.uvRotateTop = 1;
            }
        }
        int j1 = (meta & 0xC) >> 2;
        this.renderStandardBlock(tessellator, this.block, x, y, z);
        this.resetRenderBlocks();
        float brightness = 1.0f;
        if (LightmapHelper.isLightmapEnabled()) {
            int lmc = ((BlockRedstoneRepeater)this.block).getLightmapCoord(BlockModelRepeater.renderBlocks.blockAccess, x, y, z);
            if (Block.lightEmission[((BlockRedstoneRepeater)this.block).id] > 0) {
                lmc = LightmapHelper.setBlocklightValue(lmc, 15);
            }
            tessellator.setLightmapCoord(lmc);
        } else {
            brightness = this.getBlockBrightness(BlockModelRepeater.renderBlocks.blockAccess, x, y, z);
            if (Block.lightEmission[((BlockRedstoneRepeater)this.block).id] > 0) {
                brightness = 1.0f;
            }
        }
        tessellator.setColorOpaque_F(brightness, brightness, brightness);
        double d = -0.1875;
        double d1 = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        switch (i1) {
            case 0: {
                d4 = -0.3125;
                d2 = BlockRedstoneRepeater.field_22024_a[j1];
                break;
            }
            case 2: {
                d4 = 0.3125;
                d2 = -BlockRedstoneRepeater.field_22024_a[j1];
                break;
            }
            case 3: {
                d3 = -0.3125;
                d1 = BlockRedstoneRepeater.field_22024_a[j1];
                break;
            }
            case 1: {
                d3 = 0.3125;
                d1 = -BlockRedstoneRepeater.field_22024_a[j1];
            }
        }
        BlockModelTorch<Block> modelTorch = ((BlockRedstoneRepeater)this.block).isRepeaterPowered ? modelTorchActive : modelTorchIdle;
        modelTorch.renderTorchAtAngle(tessellator, (double)x + d1, (double)y + d, (double)z + d2, 0.0, 0.0);
        modelTorch.renderTorchAtAngle(tessellator, (double)x + d3, (double)y + d, (double)z + d4, 0.0, 0.0);
        return true;
    }

    @Override
    public boolean shouldItemRender3d() {
        return false;
    }

    @Override
    public boolean shouldSideBeRendered(WorldSource blockAccess, int x, int y, int z, int side) {
        return true;
    }
}

