/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.entity;

import net.minecraft.client.render.block.model.BlockModel;
import net.minecraft.client.render.block.model.BlockModelDispatcher;
import net.minecraft.client.render.entity.LivingRenderer;
import net.minecraft.client.render.item.model.ItemModelDispatcher;
import net.minecraft.client.render.model.ModelWolf;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.core.block.Block;
import net.minecraft.core.entity.animal.EntityWolf;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.material.ArmorMaterial;
import org.lwjgl.opengl.GL11;

public class WolfRenderer
extends LivingRenderer<EntityWolf> {
    private final ModelWolf modelArmor;
    protected ModelWolf modelWolfMain;

    public WolfRenderer(ModelWolf modelWolf, float shadowSize) {
        super(modelWolf, shadowSize);
        this.modelWolfMain = modelWolf;
        this.modelArmor = new ModelWolf(0.25f);
    }

    protected boolean setArmorModel(EntityWolf wolf, int renderPass, float renderPartialTicks) {
        ArmorMaterial material = wolf.getArmorMaterial();
        if (material == null) {
            return false;
        }
        this.loadTexture(String.format("/assets/%s/textures/armor/wolf/%s.png", material.identifier.namespace, material.identifier.value));
        this.setRenderPassModel(this.modelArmor);
        return true;
    }

    @Override
    protected boolean shouldRenderPass(EntityWolf entity, int renderPass, float renderPartialTicks) {
        return this.setArmorModel(entity, renderPass, renderPartialTicks);
    }

    public void renderWolf(EntityWolf wolf, double x, double y, double z, float yaw, float partialTicks) {
        super.render(wolf, x, y, z, yaw, partialTicks);
    }

    protected float getTailRotation(EntityWolf wolf, float partialTicks) {
        return wolf.getTailRotation();
    }

    @Override
    protected float ticksExisted(EntityWolf entity, float partialTick) {
        return this.getTailRotation(entity, partialTick);
    }

    @Override
    public void render(EntityWolf entity, double x, double y, double z, float yaw, float partialTick) {
        this.renderWolf(entity, x, y, z, yaw, partialTick);
    }

    @Override
    public void doRender(Tessellator tessellator, EntityWolf entity, double x, double y, double z, float yaw, float partialTick) {
        this.renderWolf(entity, x, y, z, yaw, partialTick);
    }

    @Override
    protected void renderEquippedItems(EntityWolf entity, float f) {
        ItemStack itemstack = entity.getWolfHeldItem();
        if (itemstack != null && itemstack.getItem() != null) {
            GL11.glPushMatrix();
            this.modelWolfMain.wolfHeadMain.postRender(0.0625f);
            GL11.glTranslatef((float)-0.0625f, (float)0.4375f, (float)0.0625f);
            if (itemstack.itemID > 0 && itemstack.itemID < Block.blocksList.length && ((BlockModel)BlockModelDispatcher.getInstance().getDispatch(Block.blocksList[itemstack.itemID])).shouldItemRender3d()) {
                float scale = 0.35f;
                GL11.glTranslatef((float)0.075f, (float)-0.3f, (float)-0.35f);
                GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glScalef((float)(scale *= 0.75f), (float)(-scale), (float)scale);
            } else {
                float scale = 0.375f;
                GL11.glTranslatef((float)0.25f, (float)-0.25f, (float)-0.35f);
                GL11.glScalef((float)scale, (float)scale, (float)scale);
                GL11.glRotatef((float)50.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)70.0f, (float)1.0f, (float)0.0f, (float)1.0f);
            }
            ItemModelDispatcher.getInstance().getDispatch(itemstack).renderItem(Tessellator.instance, this.renderDispatcher.itemRenderer, entity, itemstack);
            GL11.glPopMatrix();
        }
    }
}

