/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.texturepack;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.render.texturepack.Manifest;
import net.minecraft.client.render.texturepack.TexturePack;
import org.lwjgl.opengl.GL11;

public class TexturePackDefault
extends TexturePack {
    private int texturePackThumbnailTexture = -1;
    private BufferedImage texturePackThumbnail;

    public TexturePackDefault() {
        this.fileName = "Default";
        this.manifest = new Manifest(null, TexturePackDefault.class.getResourceAsStream("/manifest.json"));
        try {
            this.texturePackThumbnail = ImageIO.read(TexturePackDefault.class.getResource("/pack.png"));
        }
        catch (IOException ioexception) {
            ioexception.printStackTrace();
        }
    }

    @Override
    public void disposeOfTexturePack(Minecraft minecraft) {
        if (this.texturePackThumbnail != null) {
            minecraft.renderEngine.deleteTexture(this.texturePackThumbnailTexture);
        }
    }

    @Override
    public void bindThumbnailTexture(Minecraft minecraft) {
        if (this.texturePackThumbnail != null && this.texturePackThumbnailTexture < 0) {
            this.texturePackThumbnailTexture = minecraft.renderEngine.allocateAndSetupTexture(this.texturePackThumbnail);
        }
        if (this.texturePackThumbnail != null) {
            minecraft.renderEngine.bindTexture(this.texturePackThumbnailTexture);
        } else {
            GL11.glBindTexture((int)3553, (int)minecraft.renderEngine.getTexture("/assets/minecraft/textures/gui/unknown_pack.png"));
        }
    }

    @Override
    public boolean hasFile(String file) {
        try {
            boolean a;
            InputStream stream = TexturePackDefault.class.getResourceAsStream(file);
            boolean bl = a = stream != null;
            if (stream != null) {
                stream.close();
            }
            return a;
        }
        catch (Exception e) {
            return false;
        }
    }
}

