/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net;

import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.net.handler.NetHandler;
import net.minecraft.core.net.packet.Packet;

public class NetworkManager {
    private final boolean silent;
    public static int PACKET_DELAY = 100;
    public static final Object threadSyncObject = new Object();
    public static int numReadThreads;
    public static int numWriteThreads;
    private final Object sendQueueLock;
    private Socket networkSocket;
    private final SocketAddress remoteSocketAddress;
    private DataInputStream socketInputStream;
    private DataOutputStream socketOutputStream;
    private boolean isRunning;
    private final List<Packet> readPackets;
    private final List<Packet> dataPackets;
    private final List<Packet> chunkDataPackets;
    private NetHandler netHandler;
    private boolean isServerTerminating;
    private final Thread writeThread;
    private final Thread readThread;
    private boolean isTerminating;
    private String terminationReason;
    private Object[] field_20101_t;
    private int timeSinceLastRead;
    private int sendQueueByteLength;
    public int packetSendDelay;
    private int initialChunkDataDelay;

    public NetworkManager(Socket socket, String s, NetHandler nethandler) throws IOException {
        this(socket, s, nethandler, false);
    }

    public NetworkManager(Socket socket, String s, NetHandler nethandler, boolean silent) throws IOException {
        block2: {
            this.silent = silent;
            this.sendQueueLock = new Object();
            this.isRunning = true;
            this.readPackets = Collections.synchronizedList(new ArrayList());
            this.dataPackets = Collections.synchronizedList(new ArrayList());
            this.chunkDataPackets = Collections.synchronizedList(new ArrayList());
            this.isServerTerminating = false;
            this.isTerminating = false;
            this.terminationReason = "";
            this.timeSinceLastRead = 0;
            this.sendQueueByteLength = 0;
            this.packetSendDelay = 0;
            this.initialChunkDataDelay = 0;
            this.networkSocket = socket;
            this.remoteSocketAddress = socket.getRemoteSocketAddress();
            this.netHandler = nethandler;
            try {
                socket.setSoTimeout(30000);
                socket.setTrafficClass(24);
            }
            catch (SocketException socketexception) {
                if (silent) break block2;
                System.err.println(socketexception.getMessage());
            }
        }
        this.socketInputStream = new DataInputStream(socket.getInputStream());
        this.socketOutputStream = new DataOutputStream(new BufferedOutputStream(socket.getOutputStream(), 65536));
        this.readThread = new Thread(s + " read thread"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = threadSyncObject;
                synchronized (object) {
                    ++numReadThreads;
                }
                try {
                    while (NetworkManager.this.isRunning && !NetworkManager.this.isServerTerminating) {
                        while (NetworkManager.this.readPacket()) {
                        }
                        try {
                            1.sleep(PACKET_DELAY);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                finally {
                    object = threadSyncObject;
                    synchronized (object) {
                        --numReadThreads;
                    }
                }
            }
        };
        this.writeThread = new Thread(s + " write thread"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                Object object = threadSyncObject;
                synchronized (object) {
                    ++numWriteThreads;
                }
                try {
                    while (NetworkManager.this.isRunning) {
                        while (NetworkManager.this.sendPacket()) {
                        }
                        try {
                            2.sleep(PACKET_DELAY);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        try {
                            if (NetworkManager.this.socketOutputStream == null) continue;
                            NetworkManager.this.socketOutputStream.flush();
                        }
                        catch (IOException e) {
                            if (!NetworkManager.this.isTerminating) {
                                NetworkManager.this.onNetworkError(e);
                            }
                            e.printStackTrace();
                        }
                    }
                    return;
                }
                finally {
                    object = threadSyncObject;
                    synchronized (object) {
                        --numWriteThreads;
                    }
                }
            }
        };
        this.readThread.start();
        this.writeThread.start();
    }

    public void setNetHandler(NetHandler nethandler) {
        this.netHandler = nethandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToSendQueue(Packet packet) {
        if (this.isServerTerminating) {
            return;
        }
        Object object = this.sendQueueLock;
        synchronized (object) {
            this.sendQueueByteLength += packet.getPacketSize() + 1;
            if (packet.isChunkDataPacket) {
                this.chunkDataPackets.add(packet);
            } else {
                this.dataPackets.add(packet);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sendPacket() {
        boolean hasWrittenPacket;
        block10: {
            hasWrittenPacket = false;
            try {
                Packet packet;
                Object object;
                if (!(this.dataPackets.isEmpty() || this.packetSendDelay != 0 && System.currentTimeMillis() - this.dataPackets.get((int)0).creationTimeMillis < (long)this.packetSendDelay)) {
                    object = this.sendQueueLock;
                    synchronized (object) {
                        packet = this.dataPackets.remove(0);
                        this.sendQueueByteLength -= packet.getPacketSize() + 1;
                    }
                    Packet.writePacket(packet, this.socketOutputStream);
                    hasWrittenPacket = true;
                }
                if (this.initialChunkDataDelay-- > 0 || this.chunkDataPackets.isEmpty() || this.packetSendDelay != 0 && System.currentTimeMillis() - this.chunkDataPackets.get((int)0).creationTimeMillis < (long)this.packetSendDelay) break block10;
                object = this.sendQueueLock;
                synchronized (object) {
                    packet = this.chunkDataPackets.remove(0);
                    this.sendQueueByteLength -= packet.getPacketSize() + 1;
                }
                Packet.writePacket(packet, this.socketOutputStream);
                this.initialChunkDataDelay = 0;
                hasWrittenPacket = true;
            }
            catch (Exception exception) {
                if (!this.isTerminating) {
                    this.onNetworkError(exception);
                }
                return false;
            }
        }
        return hasWrittenPacket;
    }

    public void wakeThreads() {
        this.readThread.interrupt();
        this.writeThread.interrupt();
    }

    private boolean readPacket() {
        boolean hasReadPacket = false;
        try {
            Packet packet = Packet.readPacket(this.socketInputStream, this.netHandler.isServerHandler());
            if (packet != null) {
                this.readPackets.add(packet);
                hasReadPacket = true;
            } else {
                this.networkShutdown("disconnect.endOfStream", new Object[0]);
            }
        }
        catch (Exception exception) {
            if (!this.isTerminating) {
                this.onNetworkError(exception);
            }
            return false;
        }
        return hasReadPacket;
    }

    private void onNetworkError(Exception exception) {
        if (!this.silent) {
            exception.printStackTrace();
        }
        this.networkShutdown("disconnect.genericReason", new Object[]{"Internal exception: " + exception.toString()});
    }

    public void networkShutdown(String s, Object[] aobj) {
        if (!this.isRunning) {
            return;
        }
        this.isTerminating = true;
        this.terminationReason = s;
        this.field_20101_t = aobj;
        new Thread(() -> {
            try {
                Thread.sleep(5000L);
                if (this.readThread.isAlive()) {
                    try {
                        this.readThread.stop();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                if (this.writeThread.isAlive()) {
                    try {
                        this.writeThread.stop();
                    }
                    catch (Throwable throwable) {}
                }
            }
            catch (InterruptedException interruptedexception) {
                interruptedexception.printStackTrace();
            }
        }).start();
        this.isRunning = false;
        try {
            this.socketInputStream.close();
            this.socketInputStream = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.socketOutputStream.close();
            this.socketOutputStream = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.networkSocket.close();
            this.networkSocket = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void processReadPackets() {
        if (this.sendQueueByteLength > 0x100000) {
            this.networkShutdown("disconnect.overflow", new Object[0]);
        }
        if (this.readPackets.isEmpty()) {
            if (this.timeSinceLastRead++ == 1200) {
                this.networkShutdown("disconnect.timeout", new Object[0]);
            }
        } else {
            this.timeSinceLastRead = 0;
        }
        for (int i = 100; !this.readPackets.isEmpty() && i >= 0; --i) {
            Packet packet = this.readPackets.remove(0);
            packet.processPacket(this.netHandler);
        }
        this.wakeThreads();
        if (this.isTerminating && this.readPackets.isEmpty()) {
            this.netHandler.handleErrorMessage(this.terminationReason, this.field_20101_t);
        }
    }

    public SocketAddress getRemoteAddress() {
        return this.remoteSocketAddress;
    }

    public void serverShutdown() {
        this.wakeThreads();
        this.isServerTerminating = true;
        this.readThread.interrupt();
        new Thread(() -> {
            try {
                Thread.sleep(2000L);
                if (this.isRunning) {
                    this.writeThread.interrupt();
                    this.networkShutdown("disconnect.closed", new Object[0]);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }).start();
    }

    public int getNumChunkDataPackets() {
        return this.chunkDataPackets.size();
    }
}

