/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.entity;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.net.entity.INetworkEntry;
import net.minecraft.core.net.entity.IPacketEntry;
import net.minecraft.core.net.entity.ITrackedEntry;
import net.minecraft.core.net.entity.IVehicleEntry;
import net.minecraft.core.net.entity.entries.AnimalNetEntry;
import net.minecraft.core.net.entity.entries.ArrowNetEntry;
import net.minecraft.core.net.entity.entries.BoatNetEntry;
import net.minecraft.core.net.entity.entries.BobberEntry;
import net.minecraft.core.net.entity.entries.CannonballEntry;
import net.minecraft.core.net.entity.entries.EggNetEntry;
import net.minecraft.core.net.entity.entries.FallingSandNetEntry;
import net.minecraft.core.net.entity.entries.FireballNetEntry;
import net.minecraft.core.net.entity.entries.FireflyNetEntry;
import net.minecraft.core.net.entity.entries.ItemNetEntry;
import net.minecraft.core.net.entity.entries.MinecartNetEntry;
import net.minecraft.core.net.entity.entries.PaintingNetEntry;
import net.minecraft.core.net.entity.entries.PebbleEntry;
import net.minecraft.core.net.entity.entries.PlayerMPNetEntry;
import net.minecraft.core.net.entity.entries.SnowballNetEntry;
import net.minecraft.core.net.entity.entries.SquidNetEntry;
import net.minecraft.core.net.entity.entries.TNTNetEntry;
import net.minecraft.core.net.packet.Packet;
import net.minecraft.core.net.packet.Packet23VehicleSpawn;
import net.minecraft.server.entity.EntityTrackerEntry;
import org.jetbrains.annotations.NotNull;

public class NetEntityHandler {
    private static final Map<Class<?>, INetworkEntry<?>> entryClassMap = new LinkedHashMap();
    private static final List<INetworkEntry<?>> netEntries = new ArrayList();
    private static final List<IPacketEntry<?>> packetEntries = new ArrayList();
    private static final List<ITrackedEntry<?>> trackedEntries = new ArrayList();
    private static final Map<Integer, IVehicleEntry<?>> typeToProviderMap = new HashMap();
    private static final Map<IVehicleEntry<?>, Integer> providerToTypeMap = new HashMap();
    private static boolean isListDirty = false;

    public static <T> void registerNetworkEntry(INetworkEntry<T> networkEntity) {
        NetEntityHandler.addEntryRaw(networkEntity, -1);
    }

    public static <T> void registerNetworkEntry(IVehicleEntry<T> typedEntity, int type) {
        NetEntityHandler.addEntryRaw(typedEntity, type);
    }

    private static <T> void addEntryRaw(INetworkEntry<T> entry, int type) {
        Class<T> entityClass = entry.getAppliedClass();
        if (entryClassMap.containsKey(entityClass)) {
            INetworkEntry<?> previousEntry = entryClassMap.get(entityClass);
            netEntries.remove(previousEntry);
            packetEntries.remove(previousEntry);
            trackedEntries.remove(previousEntry);
            entryClassMap.remove(entityClass);
            if (type >= 0 && typeToProviderMap.containsKey(type)) {
                providerToTypeMap.remove(typeToProviderMap.remove(type));
            }
        }
        entryClassMap.put(entityClass, entry);
        netEntries.add(entry);
        if (type >= 0 && entry instanceof IVehicleEntry) {
            typeToProviderMap.put(type, (IVehicleEntry)entry);
            providerToTypeMap.put((IVehicleEntry)entry, type);
        }
        if (entry instanceof IPacketEntry) {
            packetEntries.add((IPacketEntry)entry);
        }
        if (entry instanceof ITrackedEntry) {
            trackedEntries.add((ITrackedEntry)entry);
        }
        isListDirty = true;
    }

    public static Packet getSpawnPacket(@NotNull EntityTrackerEntry trackerEntry) {
        if (isListDirty) {
            NetEntityHandler.sortEntries();
        }
        for (IPacketEntry<?> netEnt : packetEntries) {
            if (!netEnt.getAppliedClass().isAssignableFrom(trackerEntry.trackedEntity.getClass())) continue;
            Packet packet = netEnt instanceof IVehicleEntry ? ((Packet23VehicleSpawn)((IVehicleEntry)netEnt).getSpawnPacket(trackerEntry, trackerEntry.trackedEntity)).setType(providerToTypeMap.get(netEnt)) : netEnt.getSpawnPacket(trackerEntry, trackerEntry.trackedEntity);
            return packet;
        }
        throw new IllegalArgumentException("Don't know how to add " + trackerEntry.trackedEntity.getClass() + "!");
    }

    public static <T> ITrackedEntry<T> getTrackedEntry(T entity) {
        if (isListDirty) {
            NetEntityHandler.sortEntries();
        }
        for (ITrackedEntry<?> tracked : trackedEntries) {
            if (!tracked.getAppliedClass().isAssignableFrom(entity.getClass())) continue;
            return tracked;
        }
        return null;
    }

    public static boolean hasType(int type) {
        return typeToProviderMap.containsKey(type);
    }

    public static IVehicleEntry<?> getTypeEntry(int type) {
        return typeToProviderMap.get(type);
    }

    private static void sortEntries() {
        Comparator networkEntryComparator = (o1, o2) -> {
            if (o1.getAppliedClass().isAssignableFrom(o2.getAppliedClass())) {
                return 1;
            }
            if (o2.getAppliedClass().isAssignableFrom(o1.getAppliedClass())) {
                return -1;
            }
            return o1.getAppliedClass().getSimpleName().compareTo(o2.getAppliedClass().getSimpleName());
        };
        netEntries.sort(networkEntryComparator);
        packetEntries.sort(networkEntryComparator);
        trackedEntries.sort(networkEntryComparator);
        isListDirty = false;
    }

    static {
        NetEntityHandler.registerNetworkEntry(new AnimalNetEntry());
        NetEntityHandler.registerNetworkEntry(new SquidNetEntry());
        NetEntityHandler.registerNetworkEntry(new FireflyNetEntry());
        NetEntityHandler.registerNetworkEntry(new ItemNetEntry());
        NetEntityHandler.registerNetworkEntry(new PaintingNetEntry());
        NetEntityHandler.registerNetworkEntry(new PlayerMPNetEntry());
        NetEntityHandler.registerNetworkEntry(new ArrowNetEntry(), 1);
        NetEntityHandler.registerNetworkEntry(new CannonballEntry(), 2);
        NetEntityHandler.registerNetworkEntry(new EggNetEntry(), 3);
        NetEntityHandler.registerNetworkEntry(new FireballNetEntry(), 4);
        NetEntityHandler.registerNetworkEntry(new PebbleEntry(), 5);
        NetEntityHandler.registerNetworkEntry(new SnowballNetEntry(), 6);
        NetEntityHandler.registerNetworkEntry(new BoatNetEntry(), 10);
        NetEntityHandler.registerNetworkEntry(new MinecartNetEntry(), 11);
        NetEntityHandler.registerNetworkEntry(new FallingSandNetEntry(), 20);
        NetEntityHandler.registerNetworkEntry(new TNTNetEntry(), 21);
        NetEntityHandler.registerNetworkEntry(new BobberEntry(), 30);
    }
}

