/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.block.BlockBed;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.data.gamerule.GameRules;
import net.minecraft.core.entity.EntityLiving;
import net.minecraft.core.entity.SpawnListEntry;
import net.minecraft.core.entity.monster.EntityArmoredZombie;
import net.minecraft.core.entity.monster.EntitySkeleton;
import net.minecraft.core.entity.monster.EntitySpider;
import net.minecraft.core.entity.monster.EntityZombie;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.enums.EnumCreatureType;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.phys.Vec3d;
import net.minecraft.core.world.World;
import net.minecraft.core.world.biome.Biome;
import net.minecraft.core.world.chunk.ChunkCoordinate;
import net.minecraft.core.world.chunk.ChunkCoordinates;
import net.minecraft.core.world.chunk.ChunkPosition;
import net.minecraft.core.world.pathfinder.Node;
import net.minecraft.core.world.pathfinder.Path;
import net.minecraft.core.world.pathfinder.PathFinder;

public final class SpawnerMobs {
    private static final Set<ChunkCoordinate> eligibleChunksForSpawning = new HashSet<ChunkCoordinate>();
    private static final Class<?>[] nightSpawnEntities = new Class[]{EntitySpider.class, EntityZombie.class, EntitySkeleton.class, EntityArmoredZombie.class};

    private static ChunkPosition getRandomSpawningPointInChunk(World world, int x, int z) {
        int newX = x + world.rand.nextInt(16);
        int newY = world.rand.nextInt(world.getHeightBlocks());
        int newZ = z + world.rand.nextInt(16);
        return new ChunkPosition(newX, newY, newZ);
    }

    public static int performSpawning(World world, boolean spawnHostileMobs, boolean spawnPassiveMobs) {
        if (!spawnHostileMobs && !spawnPassiveMobs) {
            return 0;
        }
        eligibleChunksForSpawning.clear();
        for (EntityPlayer player : world.players) {
            int playerChunkX = MathHelper.floor_double(player.x / 16.0);
            int playerChunkZ = MathHelper.floor_double(player.z / 16.0);
            int spawnRadius = 8;
            for (int dx = -8; dx <= 8; ++dx) {
                for (int dz = -8; dz <= 8; ++dz) {
                    if (!world.isChunkLoaded(dx + playerChunkX, dz + playerChunkZ)) continue;
                    eligibleChunksForSpawning.add(new ChunkCoordinate(dx + playerChunkX, dz + playerChunkZ));
                }
            }
        }
        int totalSpawned = 0;
        ChunkCoordinates spawnChunk = world.getSpawnPoint();
        ChunkCoordinate[] spawnChunks = new ChunkCoordinate[9];
        for (int x = 0; x < 3; ++x) {
            for (int z = 0; z < 3; ++z) {
                spawnChunks[x * 3 + z] = new ChunkCoordinate(spawnChunk.x + (x - 1), spawnChunk.z + (z - 1));
            }
        }
        for (EnumCreatureType creatureType : EnumCreatureType.values()) {
            if (creatureType.getPeacefulCreature() && !spawnPassiveMobs || !creatureType.getPeacefulCreature() && !spawnHostileMobs || world.countEntities(creatureType.getCreatureClass()) > creatureType.getMaxNumberOfCreature() * eligibleChunksForSpawning.size() / 256) continue;
            for (ChunkCoordinate chunk : eligibleChunksForSpawning) {
                boolean checkSpawnDist = false;
                for (ChunkCoordinate c : spawnChunks) {
                    if (!c.equals(chunk)) continue;
                    checkSpawnDist = true;
                    break;
                }
                int blockX = chunk.x * 16;
                int blockZ = chunk.z * 16;
                Biome biome = world.getBlockBiome(blockX, world.getHeightBlocks() - 1, blockZ);
                List<SpawnListEntry> spawnableList = biome.getSpawnableList(creatureType);
                if (spawnableList == null || spawnableList.isEmpty()) continue;
                int totalSpawnRarity = 0;
                for (SpawnListEntry spawnListEntry : spawnableList) {
                    totalSpawnRarity += spawnListEntry.spawnFrequency;
                }
                int calculatedSpawnChance = world.rand.nextInt(totalSpawnRarity);
                SpawnListEntry spawnListEntry = spawnableList.get(0);
                for (SpawnListEntry listEntry : spawnableList) {
                    if ((calculatedSpawnChance -= listEntry.spawnFrequency) >= 0) continue;
                    spawnListEntry = listEntry;
                    break;
                }
                ChunkPosition chunkPosition = SpawnerMobs.getRandomSpawningPointInChunk(world, blockX, blockZ);
                int x = chunkPosition.x;
                int y = chunkPosition.y;
                int z = chunkPosition.z;
                if (world.getBlockMaterial(x, y, z) != creatureType.getCreatureMaterial()) continue;
                int countSpawned = 0;
                int range = 6;
                block12: for (int i = 0; i < 3; ++i) {
                    int ix = x;
                    int iy = y;
                    int iz = z;
                    for (int spawnAttempt = 0; spawnAttempt < 4; ++spawnAttempt) {
                        EntityLiving mobToSpawn;
                        double spawnDistanceZ;
                        double spawnDistanceY;
                        double spawnDistanceX;
                        double spawnDistanceSquared;
                        double dz;
                        double dy;
                        double dx;
                        if (!SpawnerMobs.canCreatureTypeSpawnAtLocation(creatureType, world, ix += world.rand.nextInt(6) - world.rand.nextInt(6), iy += world.rand.nextInt(2) - world.rand.nextInt(2), iz += world.rand.nextInt(6) - world.rand.nextInt(6)) || world.getClosestPlayer(dx = (double)ix + 0.5, dy = (double)iy, dz = (double)iz + 0.5, 24.0) != null || checkSpawnDist && (spawnDistanceSquared = (spawnDistanceX = dx - (double)spawnChunk.x) * spawnDistanceX + (spawnDistanceY = dy - (double)spawnChunk.y) * spawnDistanceY + (spawnDistanceZ = dz - (double)spawnChunk.z) * spawnDistanceZ) < 576.0) continue;
                        try {
                            mobToSpawn = (EntityLiving)spawnListEntry.entityClass.getConstructor(World.class).newInstance(world);
                        }
                        catch (Exception e) {
                            new RuntimeException("Error spawning entity class '" + spawnListEntry.entityClass.getSimpleName() + "' class missing default constructor for World! Skipping spawn attempt!", e).printStackTrace();
                            return totalSpawned;
                        }
                        mobToSpawn.moveTo(dx, dy, dz, world.rand.nextFloat() * 360.0f, 0.0f);
                        if (!mobToSpawn.getCanSpawnHere()) continue;
                        mobToSpawn.spawnInit();
                        world.entityJoinedWorld(mobToSpawn);
                        if (++countSpawned >= mobToSpawn.getMaxSpawnedInChunk()) continue block12;
                    }
                }
                totalSpawned += countSpawned;
            }
        }
        return totalSpawned;
    }

    private static boolean canCreatureTypeSpawnAtLocation(EnumCreatureType enumcreaturetype, World world, int x, int y, int z) {
        if (enumcreaturetype.getCreatureMaterial() == Material.water) {
            return world.getBlockMaterial(x, y, z).isLiquid() && !world.isBlockNormalCube(x, y + 1, z);
        }
        return world.isBlockNormalCube(x, y - 1, z) && !world.isBlockNormalCube(x, y, z) && !world.getBlockMaterial(x, y, z).isLiquid();
    }

    public static boolean performSleepSpawning(World world, List<EntityPlayer> list) {
        if (!world.getGameRuleValue(GameRules.DO_NIGHTMARES).booleanValue()) {
            return false;
        }
        boolean spawnedEntity = false;
        PathFinder pathFinder = new PathFinder(world);
        for (EntityPlayer player : list) {
            Class<?>[] entityClasses;
            if (!player.isPlayerSleeping() || player.getGamemode().isPlayerInvulnerable() || (entityClasses = nightSpawnEntities) == null || entityClasses.length == 0) continue;
            boolean spawnedEntityForPlayer = false;
            for (int i = 0; i < 20 && !spawnedEntityForPlayer; ++i) {
                boolean isCollisionFree;
                Path pathEntity;
                EntityLiving entity;
                int spawnY;
                int x = MathHelper.floor_double(player.x) + world.rand.nextInt(32) - world.rand.nextInt(32);
                int z = MathHelper.floor_double(player.z) + world.rand.nextInt(32) - world.rand.nextInt(32);
                int y = MathHelper.floor_double(player.y) + world.rand.nextInt(16) - world.rand.nextInt(16);
                for (spawnY = y = MathHelper.clamp(y, 1, world.getHeightBlocks()); spawnY > 2 && !world.isBlockNormalCube(x, spawnY - 1, z); --spawnY) {
                }
                while (!SpawnerMobs.canCreatureTypeSpawnAtLocation(EnumCreatureType.monster, world, x, spawnY, z) && spawnY < y + 16 && spawnY < world.getHeightBlocks()) {
                    ++spawnY;
                }
                if (spawnY >= y + 16) {
                    spawnY = y;
                    continue;
                }
                float entityX = (float)x + 0.5f;
                float entityY = spawnY;
                float entityZ = (float)z + 0.5f;
                try {
                    entity = (EntityLiving)entityClasses[world.rand.nextInt(entityClasses.length)].getConstructor(World.class).newInstance(world);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return spawnedEntity;
                }
                entity.moveTo(entityX, entityY, entityZ, world.rand.nextFloat() * 360.0f, 0.0f);
                if (!entity.getCanSpawnHere() || (pathEntity = pathFinder.findPath(entity, player, 32.0f)) == null || pathEntity.length <= 1) continue;
                Node pathPoint = pathEntity.last();
                boolean bl = isCollisionFree = world.checkBlockCollisionBetweenPoints(Vec3d.createVector(player.x, player.y + 1.5, player.z), Vec3d.createVector(pathPoint.x, (float)pathPoint.y + 1.5f, pathPoint.z)) == null;
                if (!(Math.abs((double)((float)pathPoint.x + 0.5f) - player.x) < 1.5) || !(Math.abs((double)((float)pathPoint.z + 0.5f) - player.z) < 1.5) || !(Math.abs((double)((float)pathPoint.y + 0.5f) - player.y) < 1.5) || !isCollisionFree) continue;
                ChunkCoordinates pos = BlockBed.getNearestEmptyChunkCoordinates(world, MathHelper.floor_double(player.x), MathHelper.floor_double(player.y), MathHelper.floor_double(player.z), 1);
                if (pos == null) {
                    pos = new ChunkCoordinates(x, spawnY + 1, z);
                }
                entity.moveTo((float)pos.x + 0.5f, pos.y, (float)pos.z + 0.5f, 0.0f, 0.0f);
                entity.spawnInit();
                world.entityJoinedWorld(entity);
                player.wakeUpPlayer(true, false);
                world.playSoundEffect(null, 2001, (int)player.x, (int)player.y - 1, (int)player.z, world.getBlockId((int)player.x, (int)player.y - 1, (int)player.z));
                entity.playLivingSound();
                spawnedEntity = true;
                spawnedEntityForPlayer = true;
            }
        }
        return spawnedEntity;
    }
}

