/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.save;

import java.util.Objects;
import net.minecraft.core.world.save.DimensionData;
import net.minecraft.core.world.save.LevelData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SaveFile
implements Comparable<SaveFile> {
    @NotNull
    private final String fileName;
    @NotNull
    private final String displayName;
    @Nullable
    private final LevelData levelData;
    @NotNull
    private final DimensionData[] dimensionData;
    private final long lastTimePlayed;
    private final long sizeOnDisk;
    private final boolean needsConversion;
    private final boolean corrupted;

    public SaveFile(@NotNull String fileName, @NotNull String displayName, @Nullable LevelData levelData, DimensionData @NotNull [] dimensionData, long lastTimePlayed, long sizeOnDisk, boolean needsConversion) {
        this.fileName = Objects.requireNonNull(fileName);
        this.displayName = Objects.requireNonNull(displayName);
        this.lastTimePlayed = lastTimePlayed;
        this.sizeOnDisk = sizeOnDisk;
        this.needsConversion = needsConversion;
        this.levelData = levelData;
        this.dimensionData = Objects.requireNonNull(dimensionData);
        this.corrupted = levelData == null || dimensionData[0] == null;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    @Nullable
    public LevelData getLevelData() {
        return this.levelData;
    }

    @Nullable
    public DimensionData[] getDimensionData() {
        return this.dimensionData;
    }

    public long getSizeOnDisk() {
        return this.sizeOnDisk;
    }

    public boolean getNeedsConversion() {
        return this.needsConversion;
    }

    public boolean isCorrupted() {
        return this.corrupted;
    }

    public long getLastTimePlayed() {
        return this.lastTimePlayed;
    }

    public int getMostRecentSave(SaveFile save) {
        if (this.lastTimePlayed < save.lastTimePlayed) {
            return 1;
        }
        if (this.lastTimePlayed > save.lastTimePlayed) {
            return -1;
        }
        return this.fileName.compareTo(save.fileName);
    }

    @Override
    public int compareTo(@NotNull SaveFile save) {
        return this.getMostRecentSave(save);
    }
}

