/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.entity.fx;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.fx.EntityArrowGoldenFX;
import net.minecraft.client.entity.fx.EntityBubbleFX;
import net.minecraft.client.entity.fx.EntityDiggingFX;
import net.minecraft.client.entity.fx.EntityExplodeFX;
import net.minecraft.client.entity.fx.EntityFireflyFX;
import net.minecraft.client.entity.fx.EntityFlameFX;
import net.minecraft.client.entity.fx.EntityFootStepFX;
import net.minecraft.client.entity.fx.EntityHeartFX;
import net.minecraft.client.entity.fx.EntityItemFX;
import net.minecraft.client.entity.fx.EntityLavaFX;
import net.minecraft.client.entity.fx.EntityLeafFX;
import net.minecraft.client.entity.fx.EntityNoteFX;
import net.minecraft.client.entity.fx.EntityPortalFX;
import net.minecraft.client.entity.fx.EntityReddustFX;
import net.minecraft.client.entity.fx.EntitySlimeChunkFX;
import net.minecraft.client.entity.fx.EntitySmokeFX;
import net.minecraft.client.entity.fx.EntitySnowShovelFX;
import net.minecraft.client.entity.fx.EntitySplashFX;
import net.minecraft.client.entity.fx.ParticleLambda;
import net.minecraft.client.util.dispatch.Dispatcher;
import net.minecraft.core.block.Block;
import net.minecraft.core.entity.animal.EntityFireflyCluster;
import net.minecraft.core.item.Item;
import net.minecraft.core.util.helper.BlockParticleHelper;
import net.minecraft.core.util.helper.MathHelper;

public class ParticleDispatcher
extends Dispatcher<String, ParticleLambda> {
    private static final ParticleDispatcher instance = new ParticleDispatcher();
    private static final ParticleLambda blank = (world, x, y, z, motionX, motionY, motionZ, data) -> null;

    public static ParticleDispatcher getInstance() {
        return instance;
    }

    public List<String> getParticleIds() {
        return new ArrayList<String>(this.dispatches.keySet());
    }

    @Override
    protected ParticleLambda getDefault() {
        return blank;
    }

    private ParticleDispatcher() {
        Minecraft mc = Minecraft.getMinecraft(this);
        this.addDispatch("bubble", (world, x, y, z, motionX, motionY, motionZ, data) -> new EntityBubbleFX(world, x, y, z, motionX, motionY, motionZ, true));
        this.addDispatch("smoke", (world, x, y, z, motionX, motionY, motionZ, data) -> new EntitySmokeFX(world, x, y, z, motionX, motionY, motionX));
        this.addDispatch("note", (world, x, y, z, motionX, motionY, motionZ, data) -> new EntityNoteFX(world, x, y, z, motionX, motionY, motionX));
        this.addDispatch("portal", (world, x, y, z, motionX, motionY, motionZ, data) -> new EntityPortalFX(world, x, y, z, motionX, motionY, motionX));
        this.addDispatch("explode", (world, x, y, z, motionX, motionY, motionZ, data) -> new EntityExplodeFX(world, x, y, z, motionX, motionY, motionX));
        this.addDispatch("flame", (world, x, y, z, motionX, motionY, motionZ, data) -> new EntityFlameFX(world, x, y, z, motionX, motionY, motionX, EntityFlameFX.Type.ORANGE));
        this.addDispatch("blueflame", (world, x, y, z, motionX, motionY, motionZ, data) -> new EntityFlameFX(world, x, y, z, motionX, motionY, motionX, EntityFlameFX.Type.BLUE));
        this.addDispatch("soulflame", (world, x, y, z, motionX, motionY, motionZ, data) -> new EntityFlameFX(world, x, y, z, motionX, motionY, motionX, EntityFlameFX.Type.SOUL));
        this.addDispatch("lava", (world, x, y, z, motionX, motionY, motionZ, data) -> new EntityLavaFX(world, x, y, z));
        this.addDispatch("footstep", (world, x, y, z, motionX, motionY, motionZ, data) -> new EntityFootStepFX(mc.renderEngine, world, x, y, z));
        this.addDispatch("splash", (world1, d, d1, d2, d3, d4, d5, data) -> new EntitySplashFX(world1, d, d1, d2, d3, d4, d5));
        this.addDispatch("largesmoke", (world, x, y, z, motionX, motionY, motionZ, data) -> new EntitySmokeFX(world, x, y, z, motionX, motionY, motionX, 2.5f));
        this.addDispatch("reddust", (world, x, y, z, motionX, motionY, motionZ, data) -> new EntityReddustFX(world, x, y, z, (float)motionX, (float)motionY, (float)motionZ, data));
        this.addDispatch("item", (world, x, y, z, motionX, motionY, motionZ, data) -> new EntityItemFX(world, x, y, z, Item.itemsList[MathHelper.clamp(data, 0, Item.itemsList.length - 1)]));
        this.addDispatch("block", (world, x, y, z, motionX, motionY, motionZ, data) -> new EntityDiggingFX(world, x, y, z, motionX, motionY, motionZ, Block.blocksList[BlockParticleHelper.decodeBlockID(data)], BlockParticleHelper.decodeBlockSide(data), BlockParticleHelper.decodeBlockMeta(data)).setParticleColor((int)x, (int)y, (int)z));
        this.addDispatch("snowshovel", (world, x, y, z, motionX, motionY, motionZ, data) -> new EntitySnowShovelFX(world, x, y, z, motionX, motionY, motionX));
        this.addDispatch("heart", (world, x, y, z, motionX, motionY, motionZ, data) -> new EntityHeartFX(world, x, y, z, motionX, motionY, motionX));
        this.addDispatch("slimechunk", (world, x, y, z, motionX, motionY, motionZ, data) -> {
            if (((Boolean)mc.gameSettings.slimeParticles.value).booleanValue()) {
                return new EntitySlimeChunkFX(world, x, y, z, Item.slimeball);
            }
            return null;
        });
        this.addDispatch("fireflyGreen", (world, x, y, z, motionX, motionY, motionZ, data) -> new EntityFireflyFX(world, x, y, z, motionX, motionY, motionX, EntityFireflyCluster.FireflyColor.GREEN.getId()));
        this.addDispatch("fireflyBlue", (world, x, y, z, motionX, motionY, motionZ, data) -> new EntityFireflyFX(world, x, y, z, motionX, motionY, motionX, EntityFireflyCluster.FireflyColor.BLUE.getId()));
        this.addDispatch("fireflyOrange", (world, x, y, z, motionX, motionY, motionZ, data) -> new EntityFireflyFX(world, x, y, z, motionX, motionY, motionX, EntityFireflyCluster.FireflyColor.ORANGE.getId()));
        this.addDispatch("fireflyRed", (world, x, y, z, motionX, motionY, motionZ, data) -> new EntityFireflyFX(world, x, y, z, motionX, motionY, motionX, EntityFireflyCluster.FireflyColor.RED.getId()));
        this.addDispatch("arrowtrail", (world, x, y, z, motionX, motionY, motionZ, data) -> new EntityArrowGoldenFX(world, x, y, z, motionX, motionY, motionX));
        this.addDispatch("fallingleaf", (world, x, y, z, motionX, motionY, motionZ, data) -> {
            int id = world.getBlockId((int)x, (int)y, (int)z);
            if (id != 0) {
                return new EntityLeafFX(world, x, y, z, motionX, motionY, motionX).func_4041_a((int)x, (int)y, (int)z);
            }
            return null;
        });
    }
}

