/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.options.components;

import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.options.GuiOptions;
import net.minecraft.client.gui.options.components.ButtonComponent;
import net.minecraft.client.option.KeyBinding;

public class KeyBindingComponent
extends ButtonComponent {
    private final KeyBinding keyBinding;
    private final GuiButton guiButton;
    private final GuiButton clearButton;

    public KeyBindingComponent(KeyBinding keyBinding) {
        super(keyBinding.getId());
        this.keyBinding = keyBinding;
        this.guiButton = new GuiButton(0, 0, 0, 150, 20, keyBinding.getKeyName());
        this.clearButton = new GuiButton(0, 0, 0, 12, 20, "X");
    }

    @Override
    protected void buttonClicked(int mouseButton, int x, int y, int width, int height, int relativeMouseX, int relativeMouseY) {
        if (this.clearButton.mouseClicked(mc, this.clearButton.xPosition + (relativeMouseX - this.guiButton.width), this.clearButton.yPosition + relativeMouseY)) {
            this.keyBinding.unbind();
            this.guiButton.displayString = this.keyBinding.getKeyName();
        } else {
            GuiOptions.pickingKeyBinding = this.keyBinding;
            GuiOptions.pickingKeyBindingComponent = this;
        }
    }

    @Override
    protected void renderButton(int x, int y, int relativeButtonX, int relativeButtonY, int buttonWidth, int buttonHeight, int relativeMouseX, int relativeMouseY) {
        super.renderButton(x, y, relativeButtonX, relativeButtonY, buttonWidth, buttonHeight, relativeMouseX, relativeMouseY);
        this.guiButton.xPosition = x + relativeButtonX;
        this.guiButton.yPosition = y + relativeButtonY;
        this.guiButton.width = buttonWidth - this.clearButton.width;
        this.guiButton.height = buttonHeight;
        this.guiButton.drawButton(mc, x + relativeMouseX, y + relativeMouseY);
        this.clearButton.xPosition = x + relativeButtonX + this.guiButton.width;
        this.clearButton.yPosition = y + relativeButtonY;
        this.clearButton.enabled = this.keyBinding.isBound();
        this.clearButton.drawButton(mc, x + relativeMouseX, y + relativeMouseY);
    }

    public void update() {
        this.guiButton.displayString = this.keyBinding.getKeyName();
    }

    @Override
    public void resetValue() {
        this.keyBinding.resetToDefault();
        this.guiButton.displayString = this.keyBinding.getKeyName();
    }

    @Override
    public boolean isDefault() {
        return this.keyBinding.isDefault();
    }
}

