/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.options.data;

import java.io.File;
import net.betterthanadventure.utils.BiomeFinder;
import net.betterthanadventure.utils.DataDumper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiControllerSetup;
import net.minecraft.client.gui.GuiHudDesigner;
import net.minecraft.client.gui.modelviewer.GuiModelViewer;
import net.minecraft.client.gui.options.components.AvailableTexturePackListComponent;
import net.minecraft.client.gui.options.components.BooleanOptionComponent;
import net.minecraft.client.gui.options.components.FloatOptionComponent;
import net.minecraft.client.gui.options.components.FramerateOptionComponent;
import net.minecraft.client.gui.options.components.IntegerOptionComponent;
import net.minecraft.client.gui.options.components.KeyBindingComponent;
import net.minecraft.client.gui.options.components.LanguagePackListComponent;
import net.minecraft.client.gui.options.components.OptionsCategory;
import net.minecraft.client.gui.options.components.SearchFieldComponent;
import net.minecraft.client.gui.options.components.SelectedTexturePackListComponent;
import net.minecraft.client.gui.options.components.ShortcutComponent;
import net.minecraft.client.gui.options.components.ToggleableOptionComponent;
import net.minecraft.client.gui.options.components.TooltipPickerComponent;
import net.minecraft.client.gui.options.data.OptionsPage;
import net.minecraft.client.gui.options.data.OptionsPageRegistry;
import net.minecraft.client.option.enums.Colorblindness;
import net.minecraft.client.option.enums.Difficulty;
import net.minecraft.client.option.enums.LightmapStyle;
import net.minecraft.client.option.enums.MipmapType;
import net.minecraft.client.option.enums.RenderDistance;
import net.minecraft.client.option.enums.RenderScale;
import net.minecraft.client.option.enums.TooltipStyle;
import net.minecraft.client.player.controller.PlayerControllerSP;
import net.minecraft.core.Global;
import net.minecraft.core.block.Block;
import net.minecraft.core.enums.PlacementMode;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Utils;
import net.minecraft.core.world.World;

public abstract class OptionsPages {
    private static final Minecraft mc = Minecraft.getMinecraft(OptionsPages.class);
    public static final OptionsPage GENERAL = OptionsPages.register(new OptionsPage("gui.options.page.general.title", new ItemStack(Block.grassRetro)).withComponent(new OptionsCategory("gui.options.page.general.category.gameplay").withComponent(new FloatOptionComponent(OptionsPages.mc.gameSettings.FoV)).withComponent(new ToggleableOptionComponent<Difficulty>(OptionsPages.mc.gameSettings.difficulty)).withComponent(new ToggleableOptionComponent<PlacementMode>(OptionsPages.mc.gameSettings.placementMode)).withComponent(new BooleanOptionComponent(OptionsPages.mc.gameSettings.autoHit)).withComponent(new BooleanOptionComponent(OptionsPages.mc.gameSettings.viewBobbing))).withComponent(new OptionsCategory("gui.options.page.general.category.user_interface").withComponent(new IntegerOptionComponent(OptionsPages.mc.gameSettings.guiScale)).withComponent(new FloatOptionComponent(OptionsPages.mc.gameSettings.screenPadding)).withComponent(new TooltipPickerComponent<TooltipStyle>(OptionsPages.mc.gameSettings.tooltipStyle)).withComponent(new BooleanOptionComponent(OptionsPages.mc.gameSettings.fpsInOverlay)).withComponent(new BooleanOptionComponent(OptionsPages.mc.gameSettings.versionInOverlay)).withComponent(new BooleanOptionComponent(OptionsPages.mc.gameSettings.foodHealthRegenOverlay)).withComponent(new BooleanOptionComponent(OptionsPages.mc.gameSettings.armorDurabilityOverlay)).withComponent(new BooleanOptionComponent(OptionsPages.mc.gameSettings.heldItemCountOverlay)).withComponent(new BooleanOptionComponent(OptionsPages.mc.gameSettings.heldItemTooltips)).withComponent(new BooleanOptionComponent(OptionsPages.mc.gameSettings.alwaysShowDescriptions)).withComponent(new BooleanOptionComponent(OptionsPages.mc.gameSettings.hideUndiscoveredItems))).withComponent(new OptionsCategory("gui.options.page.general.category.miscellaneous").withComponent(new BooleanOptionComponent(OptionsPages.mc.gameSettings.discordRichPresence)).withComponent(new BooleanOptionComponent(OptionsPages.mc.gameSettings.enableItemClumping)).withComponent(new BooleanOptionComponent(OptionsPages.mc.gameSettings.forceUnicodeFont)).withComponent(new FloatOptionComponent(OptionsPages.mc.gameSettings.autosaveTimer))).withComponent(new ShortcutComponent("gui.options.page.general.button.edit_hud", () -> mc.displayGuiScreen(new GuiHudDesigner(OptionsPages.mc.currentScreen)))).withComponent(new ShortcutComponent("gui.options.page.general.button.open_worlds_folder", () -> Utils.openDirectory(new File(mc.getMinecraftDir(), "saves")))).withComponent(new ShortcutComponent("gui.options.page.general.button.open_screenshots_folder", () -> {
        File f = new File(mc.getMinecraftDir(), "screenshots");
        f.mkdirs();
        Utils.openDirectory(f);
    })));
    public static final OptionsPage AUDIO = OptionsPages.register(new OptionsPage("gui.options.page.audio.title", new ItemStack(Item.recordCat)).withComponent(new OptionsCategory("gui.options.page.audio.category.audio").withComponent(new BooleanOptionComponent(OptionsPages.mc.gameSettings.muteOnLostFocus)).withComponent(new FloatOptionComponent(OptionsPages.mc.gameSettings.masterVolume)).withComponent(new FloatOptionComponent(OptionsPages.mc.gameSettings.musicVolume)).withComponent(new FloatOptionComponent(OptionsPages.mc.gameSettings.worldSoundsVolume)).withComponent(new FloatOptionComponent(OptionsPages.mc.gameSettings.weatherSoundsVolume)).withComponent(new FloatOptionComponent(OptionsPages.mc.gameSettings.entitySoundsVolume)).withComponent(new FloatOptionComponent(OptionsPages.mc.gameSettings.caveSoundsVolume)).withComponent(new FloatOptionComponent(OptionsPages.mc.gameSettings.guiSoundsVolume))));
    public static final OptionsPage VIDEO = OptionsPages.register(new OptionsPage("gui.options.page.video.title", new ItemStack(Item.flag)).withComponent(new OptionsCategory("gui.options.page.video.category.graphics").withComponent(new BooleanOptionComponent(OptionsPages.mc.gameSettings.fullscreen)).withComponent(new BooleanOptionComponent(OptionsPages.mc.gameSettings.borderlessFullscreen)).withComponent(new ToggleableOptionComponent<RenderScale>(OptionsPages.mc.gameSettings.renderScale)).withComponent(new ToggleableOptionComponent<Integer>(OptionsPages.mc.gameSettings.fancyGraphics)).withComponent(new ToggleableOptionComponent<RenderDistance>(OptionsPages.mc.gameSettings.renderDistance)).withComponent(new BooleanOptionComponent(OptionsPages.mc.gameSettings.ambientOcclusion)).withComponent(new ToggleableOptionComponent<Integer>(OptionsPages.mc.gameSettings.mipmapLevels)).withComponent(new ToggleableOptionComponent<MipmapType>(OptionsPages.mc.gameSettings.mipmapType)).withComponent(new ToggleableOptionComponent<Colorblindness>(OptionsPages.mc.gameSettings.colorblindnessFix))).withComponent(new OptionsCategory("gui.options.page.video.category.performance").withComponent(new BooleanOptionComponent(OptionsPages.mc.gameSettings.enableVsync)).withComponent(new FramerateOptionComponent(OptionsPages.mc.gameSettings.customFpsLimit)).withComponent(new BooleanOptionComponent(OptionsPages.mc.gameSettings.advancedOpenGL))).withComponent(new OptionsCategory("gui.options.page.video.category.post_processing").withComponent(new FloatOptionComponent(OptionsPages.mc.gameSettings.gamma)).withComponent(new FloatOptionComponent(OptionsPages.mc.gameSettings.colorCorrection)).withComponent(new FloatOptionComponent(OptionsPages.mc.gameSettings.fxaa)).withComponent(new ToggleableOptionComponent<Integer>(OptionsPages.mc.gameSettings.bloom)).withComponent(new BooleanOptionComponent(OptionsPages.mc.gameSettings.heatHaze))).withComponent(new OptionsCategory("gui.options.page.video.category.visuals").withComponent(new ToggleableOptionComponent<LightmapStyle>(OptionsPages.mc.gameSettings.lightmapStyle)).withComponent(new FloatOptionComponent(OptionsPages.mc.gameSettings.brightness)).withComponent(new BooleanOptionComponent(OptionsPages.mc.gameSettings.fog)).withComponent(new BooleanOptionComponent(OptionsPages.mc.gameSettings.biomeWater)).withComponent(new BooleanOptionComponent(OptionsPages.mc.gameSettings.treeShadows)).withComponent(new BooleanOptionComponent(OptionsPages.mc.gameSettings.vignette)).withComponent(new BooleanOptionComponent(OptionsPages.mc.gameSettings.items3D)).withComponent(new BooleanOptionComponent(OptionsPages.mc.gameSettings.clouds)).withComponent(new FloatOptionComponent(OptionsPages.mc.gameSettings.cloudHeight)).withComponent(new BooleanOptionComponent(OptionsPages.mc.gameSettings.aurora)).withComponent(new BooleanOptionComponent(OptionsPages.mc.gameSettings.slimeParticles)).withComponent(new FloatOptionComponent(OptionsPages.mc.gameSettings.blockOutlineWidth))));
    public static final OptionsPage CONTROLS = OptionsPages.register(new OptionsPage("gui.options.page.controls.title", new ItemStack(Item.boat)).withComponent(new ShortcutComponent("gui.options.page.controls.button.controller_setup", () -> mc.displayGuiScreen(new GuiControllerSetup(OptionsPages.mc.currentScreen)))).withComponent(new OptionsCategory("gui.options.page.controls.category.mouse").withComponent(new FloatOptionComponent(OptionsPages.mc.gameSettings.mouseSensitivity)).withComponent(new BooleanOptionComponent(OptionsPages.mc.gameSettings.invertMouse)).withComponent(new BooleanOptionComponent(OptionsPages.mc.gameSettings.rawMouseInput)).withComponent(new BooleanOptionComponent(OptionsPages.mc.gameSettings.enableItemDragging)).withComponent(new BooleanOptionComponent(OptionsPages.mc.gameSettings.smoothCamera)).withComponent(new FloatOptionComponent(OptionsPages.mc.gameSettings.flightSmoothness)).withComponent(new BooleanOptionComponent(OptionsPages.mc.gameSettings.turnWithVehicle))).withComponent(new OptionsCategory("gui.options.page.controls.category.keyboard").withComponent(new BooleanOptionComponent(OptionsPages.mc.gameSettings.sneakToggle)).withComponent(new BooleanOptionComponent(OptionsPages.mc.gameSettings.swapCraftingButtons))).withComponent(new OptionsCategory("gui.options.page.controls.category.controller").withComponent(new FloatOptionComponent(OptionsPages.mc.gameSettings.controllerSensitivity)).withComponent(new FloatOptionComponent(OptionsPages.mc.gameSettings.controllerMenuSensitivity)).withComponent(new FloatOptionComponent(OptionsPages.mc.gameSettings.controllerDeadzoneLeft)).withComponent(new FloatOptionComponent(OptionsPages.mc.gameSettings.controllerDeadzoneRight)).withComponent(new BooleanOptionComponent(OptionsPages.mc.gameSettings.controllerSwapShoulderButtons)).withComponent(new BooleanOptionComponent(OptionsPages.mc.gameSettings.controllerSwapAB)).withComponent(new BooleanOptionComponent(OptionsPages.mc.gameSettings.controllerSwapXY))).withComponent(new OptionsCategory("gui.options.page.controls.category.interactions").withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keyAttack)).withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keyInteract)).withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keyPickBlock))).withComponent(new OptionsCategory("gui.options.page.controls.category.movement").withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keyForward)).withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keyBack)).withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keyLeft)).withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keyRight)).withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keyJump)).withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keySneak)).withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keyFly)).withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keyAutoWalk)).withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keySprint))).withComponent(new OptionsCategory("gui.options.page.controls.category.user_interface").withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keyInventory)).withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keyChat)).withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keyCommand)).withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keyGuidebook)).withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keyShowRecipe)).withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keyShowUsage)).withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keyPlayerList)).withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keyHideGui)).withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keyToggleDebug)).withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keyToggleOverlay)).withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keySortInventory))).withComponent(new OptionsCategory("gui.options.page.controls.category.hotbar").withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keyHotBarLeft)).withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keyHotBarRight)).withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keyHotBarSwitch)).withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keyDrop)).withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keyHotBarSlot1)).withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keyHotBarSlot2)).withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keyHotBarSlot3)).withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keyHotBarSlot4)).withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keyHotBarSlot5)).withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keyHotBarSlot6)).withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keyHotBarSlot7)).withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keyHotBarSlot8)).withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keyHotBarSlot9))).withComponent(new OptionsCategory("gui.options.page.controls.category.view").withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keyLookLeft)).withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keyLookRight)).withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keyLookUp)).withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keyLookDown)).withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keyCenterView)).withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keyZoom)).withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keyCinematicCamera)).withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keySwitchPerspective)).withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keyPhotoMode))).withComponent(new OptionsCategory("gui.options.page.controls.category.miscellaneous").withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keyToggleFog)).withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keyToggleGamma)).withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keyLockRotation)).withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keyScreenshot))));
    public static final OptionsPage TEXTURE_PACKS = OptionsPages.register(new OptionsPage("gui.options.page.texture_packs.title", new ItemStack(Item.painting)).withComponent(new ShortcutComponent("gui.options.page.texture_packs.button.open_folder", () -> Utils.openDirectory(new File(mc.getMinecraftDir(), "texturepacks")))).withComponent(new OptionsCategory("gui.options.page.texture_packs.category.textures").withComponent(new ToggleableOptionComponent<Integer>(OptionsPages.mc.gameSettings.animations)).withComponent(new BooleanOptionComponent(OptionsPages.mc.gameSettings.customAnimations)).withComponent(new BooleanOptionComponent(OptionsPages.mc.gameSettings.mobVariants)).withComponent(new BooleanOptionComponent(OptionsPages.mc.gameSettings.customLightmap))).withComponent(new ShortcutComponent("gui.options.page.texture_packs.button.apply", () -> OptionsPages.mc.texturePackList.refreshIfReady())).withComponent(new OptionsCategory("gui.options.page.texture_packs.category.texture_packs.selected").withComponent(new SelectedTexturePackListComponent())).withComponent(new OptionsCategory("gui.options.page.texture_packs.category.texture_packs.available").withComponent(new AvailableTexturePackListComponent())));
    public static final OptionsPage LANGUAGE = OptionsPages.register(new OptionsPage("gui.options.page.language_packs.title", new ItemStack(Item.book)).withComponent(new ShortcutComponent("gui.options.page.language_packs.button.open_folder", () -> Utils.openDirectory(new File(mc.getMinecraftDir(), "languages")))).withComponent(new OptionsCategory("gui.options.page.language_packs.category.language_packs").withComponent(new LanguagePackListComponent())));
    public static final OptionsPage SEARCH = OptionsPages.register(new OptionsPage("gui.options.page.search.title", new ItemStack(Block.glass)).withComponent(new SearchFieldComponent()));
    public static final OptionsPage DEBUG = new OptionsPage("gui.options.page.debug.title", Block.bedrock.getDefaultStack()).withComponent(new KeyBindingComponent(OptionsPages.mc.gameSettings.keyToggleTextureAtlas)).withComponent(new ShortcutComponent("gui.options.page.debug.button.open.model_viewer", () -> {
        OptionsPages.mc.playerController = new PlayerControllerSP(mc);
        mc.changeWorld(new World(), "Loading Model Viewer");
        mc.displayGuiScreen(new GuiModelViewer());
    })).withComponent(new ShortcutComponent("gui.options.page.debug.button.open.biome_finder", () -> {
        BiomeFinder.main(new String[0]);
        Global.accessor = mc;
    })).withComponent(new ShortcutComponent("gui.options.page.debug.button.open.datadumper", () -> {
        DataDumper.main(new String[0]);
        Utils.openDirectory(new File(mc.getMinecraftDir(), "infodump"));
        Global.accessor = mc;
    }));

    public static OptionsPage register(OptionsPage page) {
        OptionsPageRegistry.getInstance().register(page);
        return page;
    }

    static void init() {
    }
}

