/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.block.color.BlockColor;
import net.minecraft.client.render.block.color.BlockColorDispatcher;
import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.stitcher.IconCoordinate;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockFluid;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.WorldSource;

public class BlockModelFluid<T extends Block>
extends BlockModelStandard<T> {
    public BlockModelFluid(Block block) {
        super(block);
    }

    @Override
    public boolean render(Tessellator tessellator, int x, int y, int z) {
        this.block.setBlockBoundsBasedOnState(BlockModelFluid.renderBlocks.blockAccess, x, y, z);
        int color = ((BlockColor)BlockColorDispatcher.getInstance().getDispatch(this.block)).getWorldColor(BlockModelFluid.renderBlocks.blockAccess, x, y, z);
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        boolean renderTop = this.shouldSideBeRendered(BlockModelFluid.renderBlocks.blockAccess, x, y + 1, z, 1);
        boolean flag1 = this.shouldSideBeRendered(BlockModelFluid.renderBlocks.blockAccess, x, y - 1, z, 0);
        boolean[] aflag = new boolean[]{this.shouldSideBeRendered(BlockModelFluid.renderBlocks.blockAccess, x, y, z - 1, 2), this.shouldSideBeRendered(BlockModelFluid.renderBlocks.blockAccess, x, y, z + 1, 3), this.shouldSideBeRendered(BlockModelFluid.renderBlocks.blockAccess, x - 1, y, z, 4), this.shouldSideBeRendered(BlockModelFluid.renderBlocks.blockAccess, x + 1, y, z, 5)};
        if (!(renderTop || flag1 || aflag[0] || aflag[1] || aflag[2] || aflag[3])) {
            return false;
        }
        boolean didRender = false;
        float sideBottom = 0.5f;
        float sideTop = 1.0f;
        float sideNorthSouth = 0.8f;
        float sideEastWest = 0.6f;
        double d = 0.0;
        double d1 = 1.0;
        float yOff = 0.001f;
        Material material = this.block.blockMaterial;
        int meta = BlockModelFluid.renderBlocks.blockAccess.getBlockMetadata(x, y, z);
        float f7 = BlockFluid.getFluidHeight(BlockModelFluid.renderBlocks.blockAccess, x, y, z, material);
        float f8 = BlockFluid.getFluidHeight(BlockModelFluid.renderBlocks.blockAccess, x, y, z + 1, material);
        float f9 = BlockFluid.getFluidHeight(BlockModelFluid.renderBlocks.blockAccess, x + 1, y, z + 1, material);
        float f10 = BlockFluid.getFluidHeight(BlockModelFluid.renderBlocks.blockAccess, x + 1, y, z, material);
        if (BlockModelFluid.renderBlocks.renderAllFaces || renderTop) {
            didRender = true;
            IconCoordinate texture = this.getBlockTextureFromSideAndMetadata(Side.TOP, meta);
            float rotation = (float)BlockFluid.getSlopeAngle(BlockModelFluid.renderBlocks.blockAccess, x, y, z, material);
            if (rotation > -999.0f) {
                texture = this.getBlockTextureFromSideAndMetadata(Side.NORTH, meta);
            } else {
                rotation = 0.0f;
            }
            float blockBrightness = 1.0f;
            if (LightmapHelper.isLightmapEnabled()) {
                int light = this.block.getLightmapCoord(BlockModelFluid.renderBlocks.blockAccess, x, y, z);
                int lightUp = this.block.getLightmapCoord(BlockModelFluid.renderBlocks.blockAccess, x, y + 1, z);
                tessellator.setLightmapCoord(LightmapHelper.max(light, lightUp));
            } else {
                blockBrightness = this.getBlockBrightness(BlockModelFluid.renderBlocks.blockAccess, x, y, z);
            }
            if (texture.namespaceId.contains("_flowing")) {
                double centerU = texture.getSubIconU(0.5);
                double centerV = texture.getSubIconV(0.5);
                float cSin = MathHelper.cos(rotation) / 2.0f;
                float sin = MathHelper.sin(rotation) / 2.0f;
                double minU = texture.getIconUMin();
                double maxU = texture.getIconUMax();
                double minV = texture.getIconVMin();
                double maxV = texture.getIconVMax();
                tessellator.setColorOpaque_F(1.0f * blockBrightness * r, 1.0f * blockBrightness * g, 1.0f * blockBrightness * b);
                tessellator.addVertexWithUV(x, (float)y + f7, z, (minU - centerU) * (double)sin - (maxV - centerV) * (double)cSin + centerU, (maxV - centerV) * (double)sin + (minU - centerU) * (double)cSin + centerV);
                tessellator.addVertexWithUV(x, (float)y + f8, z + 1, (maxU - centerU) * (double)sin - (maxV - centerV) * (double)cSin + centerU, (maxV - centerV) * (double)sin + (maxU - centerU) * (double)cSin + centerV);
                tessellator.addVertexWithUV(x + 1, (float)y + f9, z + 1, (maxU - centerU) * (double)sin - (minV - centerV) * (double)cSin + centerU, (minV - centerV) * (double)sin + (maxU - centerU) * (double)cSin + centerV);
                tessellator.addVertexWithUV(x + 1, (float)y + f10, z, (minU - centerU) * (double)sin - (minV - centerV) * (double)cSin + centerU, (minV - centerV) * (double)sin + (minU - centerU) * (double)cSin + centerV);
            } else {
                tessellator.setColorOpaque_F(1.0f * blockBrightness * r, 1.0f * blockBrightness * g, 1.0f * blockBrightness * b);
                tessellator.addVertexWithUV(x, (float)y + f7, z, texture.getIconUMin(), texture.getIconVMax());
                tessellator.addVertexWithUV(x, (float)y + f8, z + 1, texture.getIconUMax(), texture.getIconVMax());
                tessellator.addVertexWithUV(x + 1, (float)y + f9, z + 1, texture.getIconUMax(), texture.getIconVMin());
                tessellator.addVertexWithUV(x + 1, (float)y + f10, z, texture.getIconUMin(), texture.getIconVMin());
            }
        }
        if (BlockModelFluid.renderBlocks.renderAllFaces || flag1) {
            float brightness = 1.0f;
            if (LightmapHelper.isLightmapEnabled()) {
                tessellator.setLightmapCoord(this.block.getLightmapCoord(BlockModelFluid.renderBlocks.blockAccess, x, y - 1, z));
            } else {
                brightness = this.getBlockBrightness(BlockModelFluid.renderBlocks.blockAccess, x, y - 1, z);
            }
            tessellator.setColorOpaque_F(0.5f * brightness * r, 0.5f * brightness * g, 0.5f * brightness * b);
            renderBlocks.renderBottomFace(tessellator, this.block, x, (float)y + 0.001f, z, this.getBlockTextureFromSideAndMetadata(Side.TOP, 0));
            didRender = true;
        }
        for (int side = 0; side < 4; ++side) {
            float f21;
            float f19;
            float f20;
            float f17;
            float f15;
            float f13;
            int xB = x;
            int yB = y;
            int zB = z;
            if (side == 0) {
                --zB;
            }
            if (side == 1) {
                ++zB;
            }
            if (side == 2) {
                --xB;
            }
            if (side == 3) {
                ++xB;
            }
            float uOff = side == 0 || side == 1 ? ((x & 1) == 0 ? 0.0f : 0.5f) : ((z & 1) == 0 ? 0.0f : 0.5f);
            IconCoordinate texture = this.getBlockTextureFromSideAndMetadata(Side.getSideById(side + 2), meta);
            if (!BlockModelFluid.renderBlocks.renderAllFaces && !aflag[side]) continue;
            if (side == 0) {
                f13 = f7;
                f15 = f10;
                f17 = (float)x + 1.0E-4f;
                f20 = (float)(x + 1) - 1.0E-4f;
                f19 = (float)z + 1.0E-4f;
                f21 = (float)z + 1.0E-4f;
            } else if (side == 1) {
                f13 = f9;
                f15 = f8;
                f17 = (float)(x + 1) - 1.0E-4f;
                f20 = (float)x + 1.0E-4f;
                f19 = (float)(z + 1) - 1.0E-4f;
                f21 = (float)(z + 1) - 0.001f;
            } else if (side == 2) {
                f13 = f8;
                f15 = f7;
                f17 = (float)x + 1.0E-4f;
                f20 = (float)x + 1.0E-4f;
                f19 = (float)(z + 1) - 1.0E-4f;
                f21 = (float)z + 1.0E-4f;
            } else {
                f13 = f10;
                f15 = f9;
                f17 = (float)(x + 1) - 1.0E-4f;
                f20 = (float)(x + 1) - 1.0E-4f;
                f19 = (float)z + 1.0E-4f;
                f21 = (float)(z + 1) - 1.0E-4f;
            }
            didRender = true;
            float vOff = (y & 1) == 0 ? 0.0f : 0.5f;
            double d4 = texture.getSubIconU(0.0f + uOff);
            double d5 = texture.getSubIconU(0.5f + uOff);
            double d6 = texture.getSubIconV(0.5f - f13 / 2.0f + vOff);
            double d7 = texture.getSubIconV(0.5f - f15 / 2.0f + vOff);
            double d8 = texture.getSubIconV(0.5f + vOff);
            float brightness = 1.0f;
            if (LightmapHelper.isLightmapEnabled()) {
                tessellator.setLightmapCoord(this.block.getLightmapCoord(BlockModelFluid.renderBlocks.blockAccess, xB, yB, zB));
            } else {
                brightness = this.getBlockBrightness(BlockModelFluid.renderBlocks.blockAccess, xB, yB, zB);
            }
            brightness = side < 2 ? (brightness *= 0.8f) : (brightness *= 0.6f);
            tessellator.setColorOpaque_F(1.0f * brightness * r, 1.0f * brightness * g, 1.0f * brightness * b);
            tessellator.addVertexWithUV(f17, (float)y + f13, f19, d4, d6);
            tessellator.addVertexWithUV(f20, (float)y + f15, f21, d5, d7);
            tessellator.addVertexWithUV(f20, y, f21, d5, d8);
            tessellator.addVertexWithUV(f17, y, f19, d4, d8);
        }
        this.block.minY = d;
        this.block.maxY = d1;
        return didRender;
    }

    @Override
    public boolean shouldItemRender3d() {
        return false;
    }

    @Override
    public boolean shouldSideBeRendered(WorldSource blockAccess, int x, int y, int z, int side) {
        Material material = blockAccess.getBlockMaterial(x, y, z);
        if (material == this.block.blockMaterial) {
            return false;
        }
        if (material == Material.ice) {
            return true;
        }
        if (side == Side.TOP.getId()) {
            return true;
        }
        return super.shouldSideBeRendered(blockAccess, x, y, z, side);
    }
}

