/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.camera;

import net.minecraft.client.render.culling.CameraFrustum;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.phys.Vec3d;

public interface ICamera {
    public void tick();

    public void applyGlTransformations();

    public boolean showPlayer();

    public double getX(float var1);

    default public double getX() {
        return this.getX(1.0f);
    }

    public double getY(float var1);

    default public double getY() {
        return this.getY(1.0f);
    }

    public double getZ(float var1);

    default public double getZ() {
        return this.getZ(1.0f);
    }

    default public Vec3d getPosition(float partialTick) {
        return Vec3d.createVector(this.getX(partialTick), this.getY(partialTick), this.getZ(partialTick));
    }

    default public Vec3d getPosition() {
        return this.getPosition(1.0f);
    }

    public double getXRot(float var1);

    default public double getXRot() {
        return this.getXRot(1.0f);
    }

    public double getYRot(float var1);

    default public double getYRot() {
        return this.getYRot(1.0f);
    }

    default public Vec3d getViewVector(float partialTick) {
        float xRot = (float)this.getXRot(partialTick);
        float yRot = (float)this.getYRot(partialTick);
        float xzLen = -MathHelper.cos(-xRot * ((float)Math.PI / 180));
        float x = MathHelper.sin(-yRot * ((float)Math.PI / 180) - (float)Math.PI);
        float y = MathHelper.sin(-xRot * ((float)Math.PI / 180));
        float z = MathHelper.cos(-yRot * ((float)Math.PI / 180) - (float)Math.PI);
        return Vec3d.createVector(x * xzLen, y, z * xzLen);
    }

    default public Vec3d getRotationVector(float partialTick) {
        double pitch = this.getXRot(partialTick);
        double yaw = this.getYRot(partialTick);
        double toRads = Math.PI / 180;
        float xzLen = -MathHelper.cos((float)(-pitch * toRads));
        float x = MathHelper.sin((float)(-yaw * toRads - Math.PI));
        float y = MathHelper.sin((float)(-pitch * toRads));
        float z = MathHelper.cos((float)(-yaw * toRads - Math.PI));
        return Vec3d.createVector(x * xzLen, y, z * xzLen);
    }

    default public Vec3d getRotationVector() {
        return this.getRotationVector(1.0f);
    }

    public double getFov();

    public CameraFrustum getFrustum();

    default public double distanceToSqr(double x, double y, double z, float partialTick) {
        float dx = (float)(this.getX(partialTick) - x);
        float dy = (float)(this.getY(partialTick) - y);
        float dz = (float)(this.getZ(partialTick) - z);
        return dx * dx + dy * dy + dz * dz;
    }

    default public double distanceToSqr(double x, double y, double z) {
        return this.distanceToSqr(x, y, z, 1.0f);
    }

    default public double distanceTo(Entity entity, float partialTick) {
        return this.distanceTo(entity.x, entity.y, entity.z, partialTick);
    }

    default public double distanceTo(Entity entity) {
        return this.distanceTo(entity, 1.0f);
    }

    default public double distanceTo(double x, double y, double z, float partialTick) {
        return MathHelper.sqrt_double(this.distanceToSqr(x, y, z, partialTick));
    }

    default public double distanceTo(double x, double y, double z) {
        return this.distanceTo(x, y, z, 1.0f);
    }
}

