/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.dynamictexture;

import java.awt.image.BufferedImage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.render.dynamictexture.DynamicTexture;
import net.minecraft.client.render.stitcher.TextureRegistry;
import net.minecraft.core.world.Dimension;
import net.minecraft.core.world.chunk.ChunkCoordinates;

public class DynamicTextureCompass
extends DynamicTexture {
    private Minecraft mc;
    private byte[] compassImageData;
    private double angleFinal;
    private double delta;
    private double scaleFactor;

    public DynamicTextureCompass(Minecraft minecraft) {
        this.mc = minecraft;
    }

    @Override
    public void postInit() {
        this.setTexture(TextureRegistry.getTexture("minecraft:item/tool_compass"));
        BufferedImage atlas = this.texture.parentAtlas.atlas;
        this.compassImageData = new byte[this.texture.getArea() * 4];
        for (int x = 0; x < this.texture.width; ++x) {
            for (int y = 0; y < this.texture.height; ++y) {
                DynamicTextureCompass.putPixel(this.compassImageData, y * this.texture.width + x, atlas.getRGB(this.texture.iconX + x, this.texture.iconY + y));
            }
        }
        this.scaleFactor = (double)this.texture.width / 16.0;
    }

    @Override
    public void update() {
        int a;
        int b;
        int g;
        int r;
        int j;
        int y2;
        int x2;
        int i;
        double angleSmooth;
        for (int _x = 0; _x < this.texture.width; ++_x) {
            for (int _y = 0; _y < this.texture.height; ++_y) {
                int i2 = _y * this.texture.width + _x;
                int a2 = this.compassImageData[i2 * 4 + 3] & 0xFF;
                int r2 = this.compassImageData[i2 * 4 + 0] & 0xFF;
                int g2 = this.compassImageData[i2 * 4 + 1] & 0xFF;
                int b2 = this.compassImageData[i2 * 4 + 2] & 0xFF;
                this.imageData[i2 * 4 + 0] = (byte)r2;
                this.imageData[i2 * 4 + 1] = (byte)g2;
                this.imageData[i2 * 4 + 2] = (byte)b2;
                this.imageData[i2 * 4 + 3] = (byte)a2;
            }
        }
        double angle = 0.0;
        if (this.mc.theWorld != null && this.mc.thePlayer != null) {
            ChunkCoordinates var21 = this.mc.theWorld.getSpawnPoint();
            double var23 = (double)var21.x - this.mc.thePlayer.x;
            double var25 = (double)var21.z - this.mc.thePlayer.z;
            angle = (double)(this.mc.thePlayer.yRot - 90.0f) * Math.PI / 180.0 - Math.atan2(var25, var23);
            if (this.mc.theWorld.dimension == Dimension.nether) {
                angle = Math.random() * Math.PI * 2.0;
            }
        }
        for (angleSmooth = angle - this.angleFinal; angleSmooth < -Math.PI; angleSmooth += Math.PI * 2) {
        }
        while (angleSmooth >= Math.PI) {
            angleSmooth -= Math.PI * 2;
        }
        if (angleSmooth < -1.0) {
            angleSmooth = -1.0;
        }
        if (angleSmooth > 1.0) {
            angleSmooth = 1.0;
        }
        this.delta += angleSmooth * 0.1;
        this.delta *= 0.8;
        this.angleFinal += this.delta;
        double x = Math.sin(this.angleFinal);
        double y = Math.cos(this.angleFinal);
        double xs = (double)this.texture.width / 2.0 + 0.5;
        double ys = (double)this.texture.height / 2.0 - 0.5;
        for (i = (int)(-4.0 * this.scaleFactor); i <= (int)(4.0 * this.scaleFactor); ++i) {
            x2 = (int)(xs + y * (double)i * 0.3);
            y2 = (int)(ys - x * (double)i * 0.3 * 0.5);
            j = y2 * this.texture.width + x2;
            r = 100;
            g = 100;
            b = 100;
            a = 255;
            this.imageData[j * 4 + 0] = (byte)r;
            this.imageData[j * 4 + 1] = (byte)g;
            this.imageData[j * 4 + 2] = (byte)b;
            this.imageData[j * 4 + 3] = (byte)a;
        }
        for (i = (int)(-8.0 * this.scaleFactor); i <= (int)(16.0 * this.scaleFactor); ++i) {
            x2 = (int)(xs + x * (double)i * 0.3);
            y2 = (int)(ys + y * (double)i * 0.3 * 0.5);
            j = y2 * this.texture.width + x2;
            r = i >= 0 ? 255 : 100;
            g = i >= 0 ? 20 : 100;
            b = i >= 0 ? 20 : 100;
            a = 255;
            this.imageData[j * 4 + 0] = (byte)r;
            this.imageData[j * 4 + 1] = (byte)g;
            this.imageData[j * 4 + 2] = (byte)b;
            this.imageData[j * 4 + 3] = (byte)a;
        }
    }
}

