/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.stitcher;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import net.minecraft.client.render.stitcher.AtlasStitcher;
import org.jetbrains.annotations.NotNull;

public class IconCoordinate
implements Comparable<IconCoordinate> {
    public int iconX;
    public int iconY;
    public int width;
    public int height;
    protected final String sourceImage;
    public final String namespaceId;
    public final AtlasStitcher parentAtlas;
    private BufferedImage _imageStorage;

    public IconCoordinate(AtlasStitcher stitcher, String namespaceId, String sourceImage) {
        this.parentAtlas = stitcher;
        this.namespaceId = namespaceId;
        this.sourceImage = sourceImage;
    }

    protected void setImage(BufferedImage image) {
        this._imageStorage = image;
    }

    protected void discardImage() {
        this._imageStorage = null;
    }

    public void setDimension(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public void setPosition(int x, int y) {
        this.iconX = x;
        this.iconY = y;
    }

    public int getArea() {
        return this.width * this.height;
    }

    protected void drawToAtlas(Graphics2D atlas) {
        atlas.drawImage((Image)this._imageStorage, this.iconX, this.iconY, null);
    }

    public double getIconUMin() {
        return (double)this.iconX * this.parentAtlas.getInverseWidth();
    }

    public double getIconUMax() {
        return ((double)this.iconX + (double)this.width) * this.parentAtlas.getInverseWidth();
    }

    public double getIconVMin() {
        return (double)this.iconY * this.parentAtlas.getInverseHeight();
    }

    public double getIconVMax() {
        return ((double)this.iconY + (double)this.height) * this.parentAtlas.getInverseHeight();
    }

    public double getSubIconU(double offset) {
        return ((double)this.iconX + offset * (double)this.width) * this.parentAtlas.getInverseWidth();
    }

    public double getSubIconV(double offset) {
        return ((double)this.iconY + offset * (double)this.height) * this.parentAtlas.getInverseHeight();
    }

    public String toString() {
        return String.format("W:%d, H:%d, X:%d, Y:%d | ID:%s, Source:%s", this.width, this.height, this.iconX, this.iconY, this.namespaceId, this.sourceImage);
    }

    @Override
    public int compareTo(@NotNull IconCoordinate o) {
        int res = o.height - this.height;
        if (res != 0) {
            return res;
        }
        return this.namespaceId.compareTo(o.namespaceId);
    }
}

