/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.stitcher;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.stream.Stream;
import net.minecraft.client.render.stitcher.AtlasStitcher;
import net.minecraft.client.render.stitcher.IconCoordinate;
import net.minecraft.core.data.DataLoader;

public class TextureRegistry {
    public static HashMap<String, AtlasStitcher> stitcherMap = new HashMap();
    public static AtlasStitcher blockAtlas = TextureRegistry.register("block", new AtlasStitcher("textures/block", true, "/assets/minecraft/textures/block/texture_missing.png"));
    public static AtlasStitcher itemAtlas = TextureRegistry.register("item", new AtlasStitcher("textures/item", true, "/assets/minecraft/textures/item/texture_missing.png"));
    public static AtlasStitcher particleAtlas = TextureRegistry.register("particle", new AtlasStitcher("textures/particle", false, null));
    public static AtlasStitcher artAtlas = TextureRegistry.register("art", new AtlasStitcher("textures/art", false, null));

    public static IconCoordinate getTexture(String key) {
        if (key == null) {
            return null;
        }
        String[] split1 = key.split(":");
        if (split1.length != 2) {
            throw new IllegalArgumentException("Key '" + key + "' is improperly formatted! should follow the scheme 'key:atlas/id'");
        }
        String[] split2 = split1[1].split("/", 2);
        AtlasStitcher atlas = stitcherMap.get(split2[0]);
        if (atlas == null) {
            throw new IllegalArgumentException("Failed to find atlas '" + split2[0] + "'!");
        }
        return atlas.getTexture(split1[0] + ":" + split2[1]);
    }

    public static Boolean hasTexture(String key) {
        if (key == null) {
            return null;
        }
        String[] split1 = key.split(":");
        if (split1.length != 2) {
            throw new IllegalArgumentException("Key '" + key + "' is improperly formatted! should follow the scheme 'key:atlas/id'");
        }
        String[] split2 = split1[1].split("/", 2);
        AtlasStitcher atlas = stitcherMap.get(split2[0]);
        if (atlas == null) {
            throw new IllegalArgumentException("Failed to find atlas '" + split2[0] + "'!");
        }
        return atlas.textureMap.containsKey(split1[0] + ":" + split2[1]);
    }

    public static AtlasStitcher register(String id, AtlasStitcher atlas) {
        stitcherMap.put(id, atlas);
        return atlas;
    }

    public static void initializeAllFiles(String namespace, AtlasStitcher atlas) throws URISyntaxException, IOException, NullPointerException {
        Path myPath;
        String path = String.format("%s/%s/%s", "/assets", namespace, atlas.directoryPath);
        URI uri = DataLoader.class.getResource(path).toURI();
        FileSystem fileSystem = null;
        if (uri.getScheme().equals("jar")) {
            fileSystem = FileSystems.newFileSystem(uri, Collections.emptyMap());
            myPath = fileSystem.getPath(path, new String[0]);
        } else {
            myPath = Paths.get(uri);
        }
        Stream<Path> walk = Files.walk(myPath, 1, new FileVisitOption[0]);
        Iterator it = walk.iterator();
        while (it.hasNext()) {
            Path file = (Path)it.next();
            String name = file.getFileName().toString();
            if (!name.endsWith(".png")) continue;
            atlas.getTexture(namespace + ":" + file.getFileName().toString().replace(".png", ""));
        }
        walk.close();
        if (fileSystem != null) {
            fileSystem.close();
        }
    }

    static {
        try {
            for (AtlasStitcher stitcher : stitcherMap.values()) {
                TextureRegistry.initializeAllFiles("minecraft", stitcher);
            }
        }
        catch (Exception e) {
            new RuntimeException(e).printStackTrace();
            System.out.println("Failed to fully initialize assets, some issue may occur!");
        }
    }
}

