/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.achievement.stat;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.core.achievement.AchievementList;
import net.minecraft.core.achievement.stat.Stat;
import net.minecraft.core.achievement.stat.StatBasic;
import net.minecraft.core.achievement.stat.StatItem;
import net.minecraft.core.achievement.stat.StatMob;
import net.minecraft.core.block.Block;
import net.minecraft.core.crafting.legacy.CraftingManager;
import net.minecraft.core.crafting.legacy.recipe.IRecipe;
import net.minecraft.core.crafting.legacy.recipe.RecipesFurnace;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityDispatcher;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;

public abstract class StatList {
    protected static Map<Integer, Stat> statMap = new HashMap<Integer, Stat>();
    public static List<Stat> statList1 = new ArrayList<Stat>();
    public static List<Stat> statList2 = new ArrayList<Stat>();
    public static List<Stat> usedItemStatsList = new ArrayList<Stat>();
    public static List<Stat> statList3 = new ArrayList<Stat>();
    public static Stat startGameStat = new StatBasic(1000, "stat.startGame").setClientside().registerStat();
    public static Stat createWorldStat = new StatBasic(1001, "stat.createWorld").setClientside().registerStat();
    public static Stat loadWorldStat = new StatBasic(1002, "stat.loadWorld").setClientside().registerStat();
    public static Stat joinMultiplayerStat = new StatBasic(1003, "stat.joinMultiplayer").setClientside().registerStat();
    public static Stat leaveGameStat = new StatBasic(1004, "stat.leaveGame").setClientside().registerStat();
    public static Stat minutesPlayedStat = new StatBasic(1100, "stat.playOneMinute", Stat.statTypeTime).setClientside().registerStat();
    public static Stat distanceWalkedStat = new StatBasic(2000, "stat.walkOneCm", Stat.statTypeDistance).setClientside().registerStat();
    public static Stat distanceSwumStat = new StatBasic(2001, "stat.swimOneCm", Stat.statTypeDistance).setClientside().registerStat();
    public static Stat distanceFallenStat = new StatBasic(2002, "stat.fallOneCm", Stat.statTypeDistance).setClientside().registerStat();
    public static Stat distanceClimbedStat = new StatBasic(2003, "stat.climbOneCm", Stat.statTypeDistance).setClientside().registerStat();
    public static Stat distanceFlownStat = new StatBasic(2004, "stat.flyOneCm", Stat.statTypeDistance).setClientside().registerStat();
    public static Stat distanceDoveStat = new StatBasic(2005, "stat.diveOneCm", Stat.statTypeDistance).setClientside().registerStat();
    public static Stat distanceByMinecartStat = new StatBasic(2006, "stat.minecartOneCm", Stat.statTypeDistance).setClientside().registerStat();
    public static Stat distanceByBoatStat = new StatBasic(2007, "stat.boatOneCm", Stat.statTypeDistance).setClientside().registerStat();
    public static Stat distanceByPigStat = new StatBasic(2008, "stat.pigOneCm", Stat.statTypeDistance).setClientside().registerStat();
    public static Stat jumpStat = new StatBasic(2010, "stat.jump").setClientside().registerStat();
    public static Stat dropStat = new StatBasic(2011, "stat.drop").setClientside().registerStat();
    public static Stat damageDealtStat = new StatBasic(2020, "stat.damageDealt").registerStat();
    public static Stat damageTakenStat = new StatBasic(2021, "stat.damageTaken").registerStat();
    public static Stat deathsStat = new StatBasic(2022, "stat.deaths").registerStat();
    public static Stat mobKillsStat = new StatBasic(2023, "stat.mobKills").registerStat();
    public static Stat playerKillsStat = new StatBasic(2024, "stat.playerKills").registerStat();
    public static Stat fishCaughtStat = new StatBasic(2025, "stat.fishCaught").registerStat();
    public static Stat[] mineBlockStatArray = StatList.func_25153_a("stat.mineBlock", 0x1000000);
    public static Stat[] craftedItemStats;
    public static Stat[] usedItemStats;
    public static Stat[] breakItemStats;
    public static Stat[] pickUpItemStats;
    public static Map<String, Stat> mobEncounterStats;
    private static boolean blocksInitialized;
    private static boolean itemsInitialized;

    public static void init() {
    }

    public static void onBlockInit() {
        usedItemStats = StatList.initUsedItemStats(usedItemStats, "stat.useItem", 0x1020000, 0, Block.blocksList.length);
        breakItemStats = StatList.initBreakItemStats(breakItemStats, "stat.breakItem", 0x1030000, 0, Block.blocksList.length);
        blocksInitialized = true;
        StatList.blocksAndItemsInitialized();
    }

    public static void onItemInit() {
        usedItemStats = StatList.initUsedItemStats(usedItemStats, "stat.useItem", 0x1020000, Block.blocksList.length, Item.itemsList.length);
        breakItemStats = StatList.initBreakItemStats(breakItemStats, "stat.breakItem", 0x1030000, Block.blocksList.length, Item.itemsList.length);
        itemsInitialized = true;
        StatList.blocksAndItemsInitialized();
    }

    public static void blocksAndItemsInitialized() {
        if (!blocksInitialized || !itemsInitialized) {
            return;
        }
        HashSet<Integer> hashset = new HashSet<Integer>();
        for (IRecipe irecipe : CraftingManager.getInstance().getRecipeList()) {
            hashset.add(irecipe.getRecipeOutput().itemID);
        }
        for (ItemStack itemstack : RecipesFurnace.getInstance().getSmeltingList().values()) {
            hashset.add(itemstack.itemID);
        }
        craftedItemStats = new Stat[Item.itemsList.length];
        for (Integer integer : hashset) {
            if (Item.itemsList[integer] == null) continue;
            StatList.craftedItemStats[integer.intValue()] = new StatItem(0x1010000 + integer, "stat.craftItem", integer).registerStat();
        }
        pickUpItemStats = new Stat[Item.itemsList.length];
        for (int i = 0; i < Item.itemsList.length; ++i) {
            StatList.pickUpItemStats[i] = new StatItem(0x1040000 + i, "", i).registerStat().setClientside();
        }
        mobEncounterStats = new HashMap<String, Stat>();
        for (Map.Entry<String, Class<? extends Entity>> entry : EntityDispatcher.keyToClassMap.entrySet()) {
            mobEncounterStats.put(entry.getKey(), new StatMob(0x1050000 + EntityDispatcher.getEntityID(entry.getValue()), "stat.encounterMob", entry.getKey()).registerStat());
        }
        StatList.replaceAllSimilarBlocks(craftedItemStats);
    }

    private static Stat[] func_25153_a(String s, int i) {
        Stat[] astatbase = new Stat[Block.blocksList.length];
        for (int j = 0; j < Block.blocksList.length; ++j) {
            if (Block.blocksList[j] == null || !Block.blocksList[j].getEnableStats()) continue;
            astatbase[j] = new StatItem(i + j, s, j).registerStat();
            statList3.add((StatItem)astatbase[j]);
        }
        StatList.replaceAllSimilarBlocks(astatbase);
        return astatbase;
    }

    private static Stat[] initUsedItemStats(Stat[] astatbase, String s, int i, int j, int k) {
        if (astatbase == null) {
            astatbase = new Stat[Item.itemsList.length];
        }
        for (int l = j; l < k; ++l) {
            if (Item.itemsList[l] == null) continue;
            astatbase[l] = new StatItem(i + l, s, l).registerStat();
            if (l < Block.blocksList.length) continue;
            usedItemStatsList.add((StatItem)astatbase[l]);
        }
        StatList.replaceAllSimilarBlocks(astatbase);
        return astatbase;
    }

    private static Stat[] initBreakItemStats(Stat[] astatbase, String s, int i, int j, int k) {
        if (astatbase == null) {
            astatbase = new Stat[Item.itemsList.length];
        }
        for (int l = j; l < k; ++l) {
            if (Item.itemsList[l] == null || !Item.itemsList[l].isDamagable()) continue;
            astatbase[l] = new StatItem(i + l, s, l).registerStat();
        }
        StatList.replaceAllSimilarBlocks(astatbase);
        return astatbase;
    }

    private static void replaceAllSimilarBlocks(Stat[] astatbase) {
        StatList.replaceSimilarBlocks(astatbase, Block.fluidWaterStill.id, Block.fluidWaterFlowing.id);
        StatList.replaceSimilarBlocks(astatbase, Block.fluidLavaStill.id, Block.fluidLavaStill.id);
        StatList.replaceSimilarBlocks(astatbase, Block.pumpkinCarvedActive.id, Block.pumpkinCarvedIdle.id);
        StatList.replaceSimilarBlocks(astatbase, Block.furnaceStoneActive.id, Block.furnaceStoneIdle.id);
        StatList.replaceSimilarBlocks(astatbase, Block.oreRedstoneGlowingStone.id, Block.oreRedstoneStone.id);
        StatList.replaceSimilarBlocks(astatbase, Block.repeaterActive.id, Block.repeaterIdle.id);
        StatList.replaceSimilarBlocks(astatbase, Block.torchRedstoneActive.id, Block.torchRedstoneIdle.id);
        StatList.replaceSimilarBlocks(astatbase, Block.mushroomRed.id, Block.mushroomBrown.id);
        StatList.replaceSimilarBlocks(astatbase, Block.grass.id, Block.dirt.id);
        StatList.replaceSimilarBlocks(astatbase, Block.farmlandDirt.id, Block.dirt.id);
    }

    private static void replaceSimilarBlocks(Stat[] astatbase, int i, int j) {
        if (astatbase[i] != null && astatbase[j] == null) {
            astatbase[j] = astatbase[i];
            return;
        }
        statList1.remove(astatbase[i]);
        statList3.remove(astatbase[i]);
        statList2.remove(astatbase[i]);
        astatbase[i] = astatbase[j];
    }

    public static Stat getStat(int i) {
        return statMap.get(i);
    }

    static {
        blocksInitialized = false;
        itemsInitialized = false;
        AchievementList.init();
    }
}

