/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.item.tool;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityLiving;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.material.ToolMaterial;
import net.minecraft.core.world.World;

public class ItemToolSword
extends Item {
    private int weaponDamage;
    private ToolMaterial material;

    public ItemToolSword(String name, int id, ToolMaterial enumtoolmaterial) {
        super(name, id);
        this.maxStackSize = 1;
        this.setMaxDamage(enumtoolmaterial.getDurability());
        this.weaponDamage = 4 + enumtoolmaterial.getDamage() * 2;
        this.material = enumtoolmaterial;
    }

    @Override
    public float getStrVsBlock(ItemStack itemstack, Block block) {
        return block.id != Block.cobweb.id ? 1.5f : 15.0f;
    }

    @Override
    public boolean hitEntity(ItemStack itemstack, EntityLiving entityliving, EntityLiving entityliving1) {
        itemstack.damageItem(1, entityliving1);
        return true;
    }

    @Override
    public boolean onBlockDestroyed(World world, ItemStack itemstack, int i, int j, int k, int l, EntityLiving entityliving) {
        Block block = Block.blocksList[i];
        if (block != null && (block.getHardness() > 0.0f || this.isSilkTouch())) {
            itemstack.damageItem(2, entityliving);
        }
        return true;
    }

    @Override
    public int getDamageVsEntity(Entity entity) {
        return this.weaponDamage;
    }

    @Override
    public boolean canHarvestBlock(EntityLiving entityLiving, ItemStack itemStack, Block block) {
        return block.hasTag(BlockTags.MINEABLE_BY_SWORD);
    }

    @Override
    public boolean isSilkTouch() {
        return this.material.isSilkTouch();
    }
}

