/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.entity.entries;

import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityLiving;
import net.minecraft.core.entity.projectile.EntityArrow;
import net.minecraft.core.entity.projectile.EntityArrowGolden;
import net.minecraft.core.entity.projectile.EntityArrowPurple;
import net.minecraft.core.net.entity.ITrackedEntry;
import net.minecraft.core.net.entity.IVehicleEntry;
import net.minecraft.core.net.packet.Packet23VehicleSpawn;
import net.minecraft.core.world.World;
import net.minecraft.server.entity.EntityTracker;
import net.minecraft.server.entity.EntityTrackerEntry;
import org.jetbrains.annotations.NotNull;

public class ArrowNetEntry
implements IVehicleEntry<EntityArrow>,
ITrackedEntry<EntityArrow> {
    @Override
    @NotNull
    public Class<EntityArrow> getAppliedClass() {
        return EntityArrow.class;
    }

    @Override
    public int getTrackingDistance() {
        return 64;
    }

    @Override
    public int getPacketDelay() {
        return 20;
    }

    @Override
    public boolean sendMotionUpdates() {
        return false;
    }

    @Override
    public void onEntityTracked(EntityTracker tracker, EntityTrackerEntry trackerEntry, EntityArrow trackedObject) {
    }

    @Override
    public Entity getEntity(World world, double x, double y, double z, int metadata, boolean hasVelocity, double xd, double yd, double zd, Entity owner) {
        if (metadata == 2) {
            return new EntityArrowGolden(world, x, y, z);
        }
        if (metadata == 1) {
            return new EntityArrowPurple(world, x, y, z);
        }
        return new EntityArrow(world, x, y, z, metadata);
    }

    @Override
    public Packet23VehicleSpawn getSpawnPacket(EntityTrackerEntry tracker, EntityArrow trackedObject) {
        EntityLiving entityliving = trackedObject.owner;
        return new Packet23VehicleSpawn(trackedObject, trackedObject.getArrowType(), entityliving == null ? -1 : entityliving.id, trackedObject.xd, trackedObject.yd, trackedObject.zd);
    }
}

