/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.packet;

import com.mojang.nbt.CompoundTag;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.net.handler.NetHandler;
import net.minecraft.core.net.packet.Packet;

public class Packet104WindowItems
extends Packet {
    public int windowId;
    public ItemStack[] itemStack;

    public Packet104WindowItems() {
    }

    public Packet104WindowItems(int i, List<ItemStack> list) {
        this.windowId = i;
        this.itemStack = new ItemStack[list.size()];
        for (int j = 0; j < this.itemStack.length; ++j) {
            ItemStack itemstack = list.get(j);
            this.itemStack[j] = itemstack != null ? itemstack.copy() : null;
        }
    }

    @Override
    public void readPacketData(DataInputStream dis) throws IOException {
        this.windowId = dis.readByte();
        int word0 = dis.readShort();
        this.itemStack = new ItemStack[word0];
        for (int i = 0; i < word0; ++i) {
            short word1 = dis.readShort();
            if (word1 < 0) continue;
            byte byte0 = dis.readByte();
            short word2 = dis.readShort();
            CompoundTag tag = null;
            if (dis.readByte() == 1) {
                tag = Packet104WindowItems.readCompressedCompoundTag(dis);
            }
            this.itemStack[i] = new ItemStack(word1, (int)byte0, (int)word2, tag);
        }
    }

    @Override
    public void writePacketData(DataOutputStream dos) throws IOException {
        dos.writeByte(this.windowId);
        dos.writeShort(this.itemStack.length);
        for (int i = 0; i < this.itemStack.length; ++i) {
            if (this.itemStack[i] == null) {
                dos.writeShort(-1);
                continue;
            }
            dos.writeShort((short)this.itemStack[i].itemID);
            dos.writeByte((byte)this.itemStack[i].stackSize);
            dos.writeShort((short)this.itemStack[i].getMetadata());
            if (!this.itemStack[i].getData().getValues().isEmpty()) {
                dos.writeByte(0);
                continue;
            }
            dos.writeByte(1);
            Packet104WindowItems.writeCompressedCompoundTag(this.itemStack[i].getData(), dos);
        }
    }

    @Override
    public void processPacket(NetHandler netHandler) {
        netHandler.handleWindowItems(this);
    }

    @Override
    public int getPacketSize() {
        return 3 + this.itemStack.length * 5;
    }
}

