/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.packet;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.security.Key;
import net.minecraft.core.net.handler.NetHandler;
import net.minecraft.core.net.packet.Packet;
import net.minecraft.core.util.helper.AES;

public class Packet3Chat
extends Packet {
    public static final String ENCRYPTION_ERROR_MESSAGE = "This crash is caused by outdated Java, please update to 8u161 or newer! If your Java version is out of date due to a technical requirement, please add the JCE Unlimited Strength Jurisdiction Policy Files to your installation. https://www.oracle.com/java/technologies/javase-jce-all-downloads.html";
    public String message;
    public int type;
    public boolean encrypted;

    public Packet3Chat() {
    }

    public Packet3Chat(String string) {
        this(string, 0, null);
    }

    public Packet3Chat(String string, Key key) {
        this(string, 0, key);
    }

    public Packet3Chat(String string, int type, Key key) {
        if (string.length() > 512) {
            string = string.substring(0, 512);
        }
        if (key != null) {
            try {
                this.message = AES.encrypt(string, key);
                this.encrypted = true;
            }
            catch (Exception e) {
                throw new RuntimeException(ENCRYPTION_ERROR_MESSAGE, e);
            }
        } else {
            this.message = string;
            this.encrypted = false;
        }
        this.type = type;
    }

    @Override
    public void readPacketData(DataInputStream in) throws IOException {
        this.type = in.readByte();
        this.message = Packet3Chat.readString(in, 1024);
        this.encrypted = in.readBoolean();
    }

    @Override
    public void writePacketData(DataOutputStream out) throws IOException {
        out.writeByte(this.type);
        Packet3Chat.writeString(this.message, out);
        out.writeBoolean(this.encrypted);
    }

    @Override
    public void processPacket(NetHandler netHandler) {
        netHandler.handleChat(this);
    }

    @Override
    public int getPacketSize() {
        return this.message.length() + 1;
    }
}

